/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.log.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.log.DistributedLogReaderService;
import de.rcenvironment.core.log.RemotableLogReaderService;
import de.rcenvironment.core.log.SerializableLogEntry;
import de.rcenvironment.core.log.SerializableLogListener;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class DistributedLogReaderServiceImpl
implements DistributedLogReaderService {
    private static final Log LOGGER = LogFactory.getLog(DistributedLogReaderServiceImpl.class);
    private CommunicationService communicationService;
    private List<SerializableLogListener> logListeners = new ArrayList<SerializableLogListener>();

    protected void activate(BundleContext bundleContext) {
    }

    protected void bindCommunicationService(CommunicationService newCommunicationService) {
        this.communicationService = newCommunicationService;
    }

    @Override
    public void addLogListener(SerializableLogListener logListener, InstanceNodeSessionId nodeId) {
        try {
            RemotableLogReaderService service = (RemotableLogReaderService)this.communicationService.getRemotableService(RemotableLogReaderService.class, (NetworkDestination)nodeId);
            service.addLogListener(logListener);
            this.logListeners.add(logListener);
        }
        catch (RemoteOperationException e) {
            LOGGER.warn((Object)StringUtils.format((String)"Failed to add remote log listener on %s: %s", (Object[])new Object[]{nodeId, e.getMessage()}));
        }
    }

    @Override
    public List<SerializableLogEntry> getLog(InstanceNodeSessionId nodeId) {
        try {
            RemotableLogReaderService service = (RemotableLogReaderService)this.communicationService.getRemotableService(RemotableLogReaderService.class, (NetworkDestination)nodeId);
            return service.getLog();
        }
        catch (RemoteOperationException e) {
            LOGGER.warn((Object)StringUtils.format((String)"Failed to get log data from %s: %s", (Object[])new Object[]{nodeId, e.getMessage()}));
            return new LinkedList<SerializableLogEntry>();
        }
    }

    @Override
    public void removeLogListener(SerializableLogListener logListener, InstanceNodeSessionId nodeId) {
        try {
            RemotableLogReaderService service = (RemotableLogReaderService)this.communicationService.getRemotableService(RemotableLogReaderService.class, (NetworkDestination)nodeId);
            service.removeLogListener(logListener);
            this.logListeners.remove(logListener);
        }
        catch (RemoteOperationException e) {
            LOGGER.warn((Object)StringUtils.format((String)"Failed to remove remote log listener from %s: %s", (Object[])new Object[]{nodeId, e.getMessage()}));
        }
    }
}

