/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.extras.testscriptrunner.definitions.common.InstanceManagementStepDefinitionBase;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.en.Then;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.junit.Assert;

public class AssertOutputStepDefinitions
extends InstanceManagementStepDefinitionBase {
    public AssertOutputStepDefinitions(TestScenarioExecutionContext executionContext) {
        super(executionContext);
    }

    @Then(value="^the(?: last)? output(?: of(?: (all|each))?(?: instance[s]?)?(?: \"([^\"]*)\")?)? should( not)? contain( the pattern)? \"([^\"]*)\"$")
    public void thenLastOutputContains(String allFlag, String instanceIds, String negationFlag, String useRegexpMarker, String subString) throws Exception {
        boolean useRegex;
        boolean shouldContain = negationFlag == null;
        boolean bl = useRegex = useRegexpMarker != null;
        if (allFlag == null && instanceIds == null) {
            this.assertPropertyOfLastCommandOutput(this.executionContext.getLastInstanceWithSingleCommandExecution(), shouldContain, useRegex, subString);
        } else {
            AssertLastCommandOutput assertLastCommandOutput = new AssertLastCommandOutput(shouldContain, useRegex, subString);
            this.iterateInstances(assertLastCommandOutput, allFlag, instanceIds);
        }
    }

    @Then(value="^the file[s]? \"([^\"]*)\"(?: of(?: (all|each))?(?: instance[s]?)?(?: \"([^\"]*)\")?)? should( not)? contain( the pattern)? \"([^\"]+)\"$")
    public void thenFilesContain(String relativeFilePathList, String allFlag, String instanceIds, String notFlag, String useRegexpMarker, String subString) throws Exception {
        boolean shouldContain = notFlag == null;
        boolean useRegex = useRegexpMarker != null;
        for (String relativeFilePath : this.parseCommaSeparatedList(relativeFilePathList)) {
            AssertFileContains assertFileContains = new AssertFileContains(shouldContain, useRegex, subString, relativeFilePath);
            this.iterateInstances(assertFileContains, allFlag, instanceIds);
        }
    }

    @Then(value="^the file[s]? \"([^\"]*)\"(?: of(?: (all|each))?(?: instance[s]?)?(?: \"([^\"]*)\")?)? should be absent or empty$")
    public void thenFilesExist(String relativeFilePathList, String allFlag, String instanceIds) throws Exception {
        for (String relativeFilePath : this.parseCommaSeparatedList(relativeFilePathList)) {
            AssertFileEmpty assertFileEmpty = new AssertFileEmpty(relativeFilePath);
            this.iterateInstances(assertFileEmpty, allFlag, instanceIds);
        }
    }

    @Then(value="^the log output of( all)?(?: instance[s]?)?(?: \"([^\"]*)\")? should indicate a clean shutdown with no warnings or errors$")
    public void thenLogOutputCleanShutdownWithoutWarnings(String allFlag, String instanceIds) throws Exception {
        AssertFileEmpty warningLogEmpty = new AssertFileEmpty("warnings.log");
        AssertFileContains debugLogContainsNoneUnfinished = new AssertFileContains(true, false, "Known unfinished operations on shutdown: <none>", "debug.log");
        AssertFileContains debugLogContainsExitCode0 = new AssertFileContains(true, false, "Main application shutdown complete, exit code: 0", "debug.log");
        this.iterateInstances(warningLogEmpty, allFlag, instanceIds);
        this.iterateInstances(debugLogContainsNoneUnfinished, allFlag, instanceIds);
        this.iterateInstances(debugLogContainsExitCode0, allFlag, instanceIds);
    }

    @Then(value="^the log output of( all)?(?: instance[s]?)?(?: \"([^\"]*)\")? should indicate a clean shutdown with these allowed warnings or errors:$")
    public void thenLogOutputCleanShutdownWithAllowedWarnings(String allFlag, String instanceIds, String allowedWarnings) throws Exception {
        AssertFileMayContainOnly warningLogContainOnly = new AssertFileMayContainOnly("warnings.log", allowedWarnings);
        AssertFileContains debugLogContainsNoneUnfinished = new AssertFileContains(true, false, "Known unfinished operations on shutdown: <none>", "debug.log");
        AssertFileContains debugLogContainsExitCode0 = new AssertFileContains(true, false, "Main application shutdown complete, exit code: 0", "debug.log");
        this.iterateInstances(warningLogContainOnly, allFlag, instanceIds);
        this.iterateInstances(debugLogContainsNoneUnfinished, allFlag, instanceIds);
        this.iterateInstances(debugLogContainsExitCode0, allFlag, instanceIds);
    }

    @Then(value="^the log output of( all)?(?: instance[s]?)?(?: \"([^\"]*)\")? should indicate a clean shutdown without checking for further warnings or errors")
    public void thenLogOutputCleanShutdown(String allFlag, String instanceIds) throws Exception {
        AssertFileContains debugLogContainsNoneUnfinished = new AssertFileContains(true, false, "Known unfinished operations on shutdown: <none>", "debug.log");
        AssertFileContains debugLogContainsExitCode0 = new AssertFileContains(true, false, "Main application shutdown complete, exit code: 0", "debug.log");
        this.iterateInstances(debugLogContainsNoneUnfinished, allFlag, instanceIds);
        this.iterateInstances(debugLogContainsExitCode0, allFlag, instanceIds);
    }

    @Then(value="^the log output of( all)?(?: instance[s]?)?(?: \"([^\"]*)\")? should (not )?contain (the pattern )?\"((?:[^\"]|\\\")*)\"$")
    public void thenLogOutputContainsAtShutdown(String allFlag, String instanceIds, String negationFlag, String useRegexpMarker, String subString) throws Exception {
        subString = subString.replace("\\\"", "\"");
        this.thenFilesContain("debug.log", allFlag, instanceIds, negationFlag, useRegexpMarker, subString);
    }

    @Then(value="^the log output of( all)?(?: instance[s]?)?(?: \"([^\"]*)\")? should not contain(?: any) (error|warning)[s]?$")
    public void thenLogOutputNoErrors(String allFlag, String instanceIds, String type) throws OperationFailureException {
        this.thenLogOutputNumberErrors(allFlag, instanceIds, 0, null, type);
    }

    @Then(value="^the log output of( all)?(?: instance[s]?)?(?: \"([^\"]*)\")? should contain (\\d+)(?: to (\\d+))? (error|warning)[s]?$")
    public void thenLogOutputNumberErrors(String allFlag, String instanceIds, Integer lowerBoundInput, Integer upperBoundInput, String type) throws OperationFailureException {
        int[] assertReturn = this.assertBounds(lowerBoundInput, upperBoundInput);
        int lowerBound = assertReturn[0];
        int upperBound = assertReturn[1];
        Pattern typePattern = Pattern.compile(StringUtils.format((String)this.getRegexBaseFormatForLogMatching(type), (Object[])new Object[]{"[\\w\\.]+", ".+"}));
        for (ManagedInstance instance : this.resolveInstanceList(allFlag != null, instanceIds)) {
            int numberErrorsOrWarnings = this.countErrorsOrWarnings(instance, typePattern);
            this.assertNumberErrorsOrWarningsInsideBoundaries(numberErrorsOrWarnings, lowerBound, upperBound, instance, type);
        }
    }

    @Then(value="^the log output of( all)?(?: instance[s]?)?(?: \"([^\"]*)\")? should (consist of|conform to):$")
    public void thenLogOutputConformance(String allFlag, String instanceIds, String mode, DataTable errorTable) throws Exception {
        AssertErrorLog assertErrorLog = new AssertErrorLog(errorTable, mode.equals("conform to"));
        this.iterateInstances(assertErrorLog, allFlag, instanceIds);
    }

    private void assertNumberErrorsOrWarningsInsideBoundaries(int numberErrorsOrWarnings, int lowerBound, int upperBound, ManagedInstance instance, String type) {
        if (numberErrorsOrWarnings < lowerBound || numberErrorsOrWarnings > upperBound) {
            Assert.fail((String)StringUtils.format((String)"Expected between %s and %s %ss on instance %s. Saw %s instead.", (Object[])new Object[]{lowerBound, upperBound, type, instance, numberErrorsOrWarnings}));
        } else {
            this.printToCommandConsole(StringUtils.format((String)"Expected between %s and %s %ss on instance %s. Saw %s as expected.", (Object[])new Object[]{lowerBound, upperBound, type, instance, numberErrorsOrWarnings}));
        }
    }

    private int countErrorsOrWarnings(ManagedInstance instance, Pattern typePattern) throws OperationFailureException {
        String warningLog = this.getWarningsLog(instance);
        Scanner logScanner = new Scanner(warningLog);
        int logCount = 0;
        while (logScanner.hasNextLine()) {
            String nextLine = logScanner.nextLine();
            if (!nextLine.contains(" ERROR ") && !nextLine.contains(" WARN ")) continue;
            ++logCount;
        }
        logScanner.close();
        return logCount;
    }

    private String getWarningsLog(ManagedInstance instance) throws OperationFailureException {
        try {
            return instance.getProfileRelativeFileContent("warnings.log", false);
        }
        catch (OperationFailureException e) {
            throw this.testExecutionError(StringUtils.format((String)"Trying to access warnings log of instance %s produced an error: %s", (Object[])new Object[]{instance}), e.getCause());
        }
    }

    private int[] assertBounds(Integer lowerBound, Integer upperBound) {
        if (upperBound == null) {
            return new int[]{lowerBound, lowerBound};
        }
        if (upperBound < lowerBound) {
            throw this.testAssertionFailure(StringUtils.format((String)"Upper bound %s is lower than lower bound %s.", (Object[])new Object[]{upperBound, lowerBound}));
        }
        return new int[]{lowerBound, upperBound};
    }

    private String getRegexBaseFormatForLogMatching(String type) {
        String baseFormat;
        if (type.equals("error") || type.equals("Error") || type.equals("ERROR")) {
            baseFormat = "^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} ERROR - %s - E#\\d+: %s";
        } else if (type.equals("warning") || type.equals("Warning") || type.equals("WARNING") || type.equals("warn") || type.equals("Warn") || type.equals("WARN")) {
            baseFormat = "^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} WARN  - %s - %s";
        } else {
            throw this.internalError(StringUtils.format((String)"Type %s is not supported.", (Object[])new Object[]{type}));
        }
        return baseFormat;
    }

    private void assertErrorContents(ManagedInstance instance, DataTable errorTable, boolean unspecifiedAccepted) throws OperationFailureException {
        String[] stringArray = instance.getProfileRelativeFileContent("warnings.log", false).split("\\r?\\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.handleErrorLine(line, errorTable, unspecifiedAccepted);
            ++n2;
        }
    }

    private void handleErrorLine(String line, DataTable errorTable, boolean unspecifiedAccepted) {
        for (Map row : errorTable.asMaps(String.class, String.class)) {
            String presence = (String)row.get("Presence");
            String type = (String)row.get("Type");
            String origin = (String)row.get("Origin");
            String message = (String)row.get("Message");
            boolean positive = this.isRowPositive(presence);
            message = message.equals("") || message == null ? ".+" : Pattern.quote(message);
            origin = origin.equals("") || origin == null ? "[\\w\\.]+" : Pattern.quote(origin);
            Pattern p = Pattern.compile(StringUtils.format((String)this.getRegexBaseFormatForLogMatching(type), (Object[])new Object[]{origin, message}));
            if (!p.matcher(line).matches()) continue;
            if (positive) {
                this.printToCommandConsole(StringUtils.format((String)"Found and accepted expected error/warning %s", (Object[])new Object[]{line}));
                return;
            }
            throw this.testAssertionFailure(StringUtils.format((String)"Found explicitly unwanted error/warning %s", (Object[])new Object[]{line}));
        }
        if (!unspecifiedAccepted) {
            throw this.testAssertionFailure(StringUtils.format((String)"Found unexpected error/warning %s (failing since in whitelisting mode)", (Object[])new Object[]{line}));
        }
        this.printToCommandConsole(StringUtils.format((String)"Found unexpected error/warning %s (accepting since in blacklisting mode)", (Object[])new Object[]{line}));
    }

    private boolean isRowPositive(String presence) {
        switch (presence) {
            case "y": 
            case "yes": {
                return true;
            }
            case "n": 
            case "no": {
                return false;
            }
        }
        throw this.internalError(StringUtils.format((String)"%s is not a supported form of presence", (Object[])new Object[]{presence}));
    }

    private void subStringContained(String string, String subString, boolean shouldContain, boolean useRegex, String errorBase) {
        String patternError = "";
        if (useRegex) {
            patternError = "the pattern ";
        }
        if (!this.stringContainsOrContainsNot(string, subString, shouldContain, useRegex)) {
            String containError = "";
            if (shouldContain) {
                containError = "not ";
            }
            throw this.testAssertionFailure(StringUtils.format((String)"%s did %scontain %s\"%s\"", (Object[])new Object[]{errorBase, containError, patternError, subString}));
        }
        String containError = "not ";
        if (shouldContain) {
            containError = "";
        }
        this.printToCommandConsole(StringUtils.format((String)"As expected %s did %scontain %s\"%s\"", (Object[])new Object[]{errorBase, containError, patternError, subString}));
    }

    private void assertPropertyOfLastCommandOutput(ManagedInstance instance, boolean shouldContain, boolean useRegex, String subString) {
        this.subStringContained(instance.getLastCommandOutput(), subString, shouldContain, useRegex, StringUtils.format((String)"  The command output of instance \"%s\"", (Object[])new Object[]{instance}));
    }

    private void assertRelativeFileContains(ManagedInstance instance, String relativeFilePath, boolean shouldContain, boolean useRegex, String subString) throws OperationFailureException {
        String fileContent = instance.getProfileRelativeFileContent(relativeFilePath, false);
        if (fileContent == null) {
            throw this.testExecutionError(StringUtils.format((String)"The expected file \"%s\" in profile \"%s\" does not exist", (Object[])new Object[]{relativeFilePath, instance}));
        }
        this.subStringContained(fileContent, subString, shouldContain, useRegex, StringUtils.format((String)"the file \"%s\" of instance \"%s\"", (Object[])new Object[]{relativeFilePath, instance}));
    }

    private void assertRelativeFileMayContainOnly(ManagedInstance instance, String relativeFilePath, String[] allowedWarnings) throws OperationFailureException {
        String fileContent = instance.getProfileRelativeFileContent(relativeFilePath, false);
        ArrayList<String> failedLines = new ArrayList<String>();
        if (fileContent == null) {
            this.printToCommandConsole(StringUtils.format((String)"Success: the file \"%s\" in profile \"%s\" is absent.", (Object[])new Object[]{relativeFilePath, instance}));
        } else if (fileContent.isEmpty()) {
            this.printToCommandConsole(StringUtils.format((String)"Success: the file \"%s\" in profile \"%s\" is empty.", (Object[])new Object[]{relativeFilePath, instance}));
        } else {
            String[] linesOfFile;
            int allowedWarningsCount = 0;
            ArrayList<String> detectedAllowedWarnings = new ArrayList<String>();
            int warnCount = 0;
            String[] stringArray = linesOfFile = instance.getProfileRelativeFileContent("warnings.log", false).split("\\r?\\n");
            int n = linesOfFile.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Boolean warningWasAllowed = false;
                String[] stringArray2 = allowedWarnings;
                int n3 = allowedWarnings.length;
                int n4 = 0;
                while (n4 < n3) {
                    String warning = stringArray2[n4];
                    if (line.contains(warning)) {
                        warningWasAllowed = true;
                        detectedAllowedWarnings.add(line);
                        ++allowedWarningsCount;
                        break;
                    }
                    ++n4;
                }
                if (!warningWasAllowed.booleanValue()) {
                    ++warnCount;
                    failedLines.add(line);
                }
                ++n2;
            }
            if (warnCount > 0) {
                throw this.testAssertionFailure(StringUtils.format((String)"The file \"%s\" in profile \"%s\" should not show these warnings: (error count: %d warnings); full file content:\n%s", (Object[])new Object[]{relativeFilePath, instance, warnCount, failedLines}));
            }
            this.printToCommandConsole("Detected " + allowedWarningsCount + " allowed warnings  for instance \"" + instance + "\":");
            for (String warning : detectedAllowedWarnings) {
                this.printToCommandConsole("  - " + warning);
            }
        }
    }

    private void assertRelativeFileIsEmpty(ManagedInstance instance, String relativeFilePath) throws OperationFailureException {
        String fileContent = instance.getProfileRelativeFileContent(relativeFilePath, false);
        if (fileContent == null) {
            this.printToCommandConsole(StringUtils.format((String)"As expected the file \"%s\" in profile \"%s\" is absent.", (Object[])new Object[]{relativeFilePath, instance}));
        } else if (fileContent.isEmpty()) {
            this.printToCommandConsole(StringUtils.format((String)"As expected the file \"%s\" in profile \"%s\" is empty.", (Object[])new Object[]{relativeFilePath, instance}));
        } else {
            throw this.testAssertionFailure(StringUtils.format((String)"The file \"%s\" in profile \"%s\" should have been absent or empty, but exists (content size: %d characters); full file content:\n%s", (Object[])new Object[]{relativeFilePath, instance, fileContent.length(), fileContent}));
        }
    }

    private class AssertErrorLog
    implements InstanceManagementStepDefinitionBase.InstanceIterator {
        private DataTable errorTable;
        private boolean unspecifiedAccepted;

        AssertErrorLog(DataTable errorTable, boolean unspecifiedAccepted) {
            this.errorTable = errorTable;
            this.unspecifiedAccepted = unspecifiedAccepted;
        }

        @Override
        public void iterateActionOverInstance(ManagedInstance instance) throws OperationFailureException {
            AssertOutputStepDefinitions.this.assertErrorContents(instance, this.errorTable, this.unspecifiedAccepted);
        }
    }

    private class AssertFileContains
    implements InstanceManagementStepDefinitionBase.InstanceIterator {
        private boolean shouldContain;
        private boolean useRegex;
        private String subString;
        private String relativeFilePath;

        AssertFileContains(boolean shouldContain, boolean useRegex, String subString, String relativeFilePath) {
            this.shouldContain = shouldContain;
            this.useRegex = useRegex;
            this.subString = subString;
            this.relativeFilePath = relativeFilePath;
        }

        @Override
        public void iterateActionOverInstance(ManagedInstance instance) throws OperationFailureException {
            AssertOutputStepDefinitions.this.assertRelativeFileContains(instance, this.relativeFilePath, this.shouldContain, this.useRegex, this.subString);
        }
    }

    private class AssertFileEmpty
    implements InstanceManagementStepDefinitionBase.InstanceIterator {
        private String relativeFilePath;

        AssertFileEmpty(String relativeFilePath) {
            this.relativeFilePath = relativeFilePath;
        }

        @Override
        public void iterateActionOverInstance(ManagedInstance instance) throws OperationFailureException, IOException {
            AssertOutputStepDefinitions.this.assertRelativeFileIsEmpty(instance, this.relativeFilePath);
        }
    }

    private class AssertFileMayContainOnly
    implements InstanceManagementStepDefinitionBase.InstanceIterator {
        private String relativeFilePath;
        private String allowedWarnings;
        private String[] allowedWarningList;

        AssertFileMayContainOnly(String relativeFilePath, String allowedWarnings) {
            this.relativeFilePath = relativeFilePath;
            this.allowedWarnings = allowedWarnings;
            this.allowedWarningList = this.allowedWarnings.split("\\r?\\n");
        }

        @Override
        public void iterateActionOverInstance(ManagedInstance instance) throws OperationFailureException {
            AssertOutputStepDefinitions.this.assertRelativeFileMayContainOnly(instance, this.relativeFilePath, this.allowedWarningList);
        }
    }

    private class AssertLastCommandOutput
    implements InstanceManagementStepDefinitionBase.InstanceIterator {
        private boolean shouldContain;
        private boolean useRegex;
        private String subString;

        AssertLastCommandOutput(boolean shouldContain, boolean useRegex, String subString) {
            this.shouldContain = shouldContain;
            this.useRegex = useRegex;
            this.subString = subString;
        }

        @Override
        public void iterateActionOverInstance(ManagedInstance instance) throws OperationFailureException {
            AssertOutputStepDefinitions.this.assertPropertyOfLastCommandOutput(instance, this.shouldContain, this.useRegex, this.subString);
        }
    }
}

