/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.FeatureParser;
import io.cucumber.core.gherkin.FeatureParserException;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.messages.CucumberQuery;
import io.cucumber.core.gherkin.messages.GherkinMessagesFeature;
import io.cucumber.core.gherkin.messages.GherkinMessagesPickle;
import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.gherkin.GherkinDialectProvider;
import io.cucumber.gherkin.GherkinParser;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.ParseError;
import io.cucumber.messages.types.Source;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class GherkinMessagesFeatureParser
implements FeatureParser {
    @Deprecated
    public Optional<Feature> parse(URI path, String source, Supplier<UUID> idGenerator) {
        Optional<Feature> optional;
        ByteArrayInputStream is = new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8));
        try {
            optional = this.parse(path, is, idGenerator);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FeatureParserException("Failed to parse resource at: " + path, (Throwable)e);
            }
        }
        ((InputStream)is).close();
        return optional;
    }

    public Optional<Feature> parse(URI path, InputStream source, Supplier<UUID> idGenerator) throws IOException {
        List envelopes = GherkinParser.builder().idGenerator(() -> ((UUID)idGenerator.get()).toString()).build().parse(path.toString(), source).collect(Collectors.toList());
        List errors = envelopes.stream().map(Envelope::getParseError).filter(Optional::isPresent).map(Optional::get).map(ParseError::getMessage).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            throw new FeatureParserException("Failed to parse resource at: " + path + "\n" + String.join((CharSequence)"\n", errors));
        }
        return envelopes.stream().map(Envelope::getGherkinDocument).filter(Optional::isPresent).map(Optional::get).findFirst().map(GherkinDocument::getFeature).filter(Optional::isPresent).map(Optional::get).map(feature -> {
            CucumberQuery cucumberQuery = new CucumberQuery();
            cucumberQuery.update((io.cucumber.messages.types.Feature)feature);
            GherkinDialectProvider dialectProvider = new GherkinDialectProvider();
            String language = feature.getLanguage();
            GherkinDialect dialect = (GherkinDialect)dialectProvider.getDialect(language).orElseThrow(() -> new IllegalStateException(language + "was not a known gherkin Dialect"));
            List pickleMessages = envelopes.stream().map(Envelope::getPickle).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            List<Pickle> pickles = pickleMessages.stream().map(pickle -> new GherkinMessagesPickle((io.cucumber.messages.types.Pickle)pickle, path, dialect, cucumberQuery)).collect(Collectors.toList());
            Source sourceMessage = envelopes.stream().map(Envelope::getSource).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new IllegalStateException("source message was not emitted by parser"));
            return new GherkinMessagesFeature((io.cucumber.messages.types.Feature)feature, path, sourceMessage.getData(), pickles, envelopes);
        });
    }

    public String version() {
        return "8";
    }
}

