/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.api.model;

import java.io.Serializable;
import java.util.List;

public class ProcessInformation
implements Serializable {
    private static final long serialVersionUID = -7273457883589693406L;
    private List<ProcessInformation> children;
    private double cpuUsage;
    private long ramUsage;
    private long pid;
    private String name;

    public ProcessInformation(long pid, String name, List<ProcessInformation> children, double cpuUsage, long ramUsage) {
        this.pid = pid;
        this.name = name;
        this.children = children;
        this.cpuUsage = cpuUsage;
        this.ramUsage = ramUsage;
    }

    public List<ProcessInformation> getChildren() {
        return this.children;
    }

    public double getCpuUsage() {
        return this.cpuUsage;
    }

    public long getRamUsage() {
        return this.ramUsage;
    }

    public long getPid() {
        return this.pid;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int result = 1;
        result = this.children == null ? (result *= 31) : 31 * result + this.children.hashCode();
        long temp = Double.doubleToLongBits(this.cpuUsage);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = this.name == null ? (result *= 31) : 31 * result + this.name.hashCode();
        result = 31 * result + (int)(this.pid ^ this.pid >>> 32);
        result = 31 * result + (int)(this.ramUsage ^ this.ramUsage >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInformation other = (ProcessInformation)obj;
        if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
            return false;
        }
        if (Double.doubleToLongBits(this.cpuUsage) != Double.doubleToLongBits(other.cpuUsage)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.pid != other.pid) {
            return false;
        }
        return this.ramUsage == other.ramUsage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb = this.getChildInfo(this.children, 0, sb);
        return sb.toString();
    }

    private StringBuilder getChildInfo(List<ProcessInformation> c, int level, StringBuilder sb) {
        this.toLevelString(level, sb);
        for (ProcessInformation pinf : c) {
            this.getChildInfo(pinf.getChildren(), level + 1, sb);
        }
        return sb;
    }

    private void toLevelString(int lvl, StringBuilder sb) {
        int i = 0;
        while (i <= lvl) {
            sb.append("    ");
            ++i;
        }
        sb.append(String.valueOf(this.name) + ": " + this.cpuUsage + "\n");
    }
}

