/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.evaluationmemory.execution.validator;

import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractComponentValidator;
import java.util.ArrayList;
import java.util.List;

public class EvaluationMemoryComponentValidator
extends AbstractComponentValidator {
    public String getIdentifier() {
        return "de.rcenvironment.evaluationmemory";
    }

    protected List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription componentDescription) {
        String memoryFile;
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        boolean selectAtWfStart = Boolean.valueOf(this.getProperty(componentDescription, "select_at_wf_start"));
        if (!selectAtWfStart && ((memoryFile = this.getProperty(componentDescription, "mem_file")) == null || memoryFile.trim().isEmpty())) {
            ComponentValidationMessage noFile = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "mem_file", "Define a evaluation memory file", "No memory file given");
            messages.add(noFile);
        }
        this.checkIfAtLeastInputsOrOutputsAreDefined(componentDescription, messages);
        return messages;
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }

    private void checkIfAtLeastInputsOrOutputsAreDefined(ComponentDescription componentDescription, List<ComponentValidationMessage> messages) {
        if (this.getInputs(componentDescription).size() < 1) {
            messages.add(new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, null, "", "No inputs/outputs defined"));
        }
    }
}

