/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.headless.textui;

import com.googlecode.lanterna.TerminalFacade;
import com.googlecode.lanterna.gui.DefaultBackgroundRenderer;
import com.googlecode.lanterna.gui.GUIScreen;
import com.googlecode.lanterna.gui.GUIScreenBackgroundRenderer;
import com.googlecode.lanterna.gui.dialog.DialogButtons;
import com.googlecode.lanterna.gui.dialog.DialogResult;
import com.googlecode.lanterna.gui.dialog.MessageBox;
import com.googlecode.lanterna.terminal.Terminal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuestionDialogTextUI {
    private static final String BACKGROUND_MESSAGE = "Error during startup...";
    private GUIScreen guiScreen;
    private String dialogTitle;
    private String dialogQuestion;
    private Terminal terminal;
    private final Log log = LogFactory.getLog(this.getClass());

    public QuestionDialogTextUI(String dialogTitle, String dialogQuestion, Terminal terminal) {
        this.dialogTitle = dialogTitle;
        this.dialogQuestion = dialogQuestion;
        this.terminal = terminal;
    }

    public QuestionDialogTextUI(String dialogTitle, String dialogQuestion) {
        this.dialogTitle = dialogTitle;
        this.dialogQuestion = dialogQuestion;
    }

    public boolean run() {
        this.guiScreen = this.terminal != null ? TerminalFacade.createGUIScreen((Terminal)this.terminal) : TerminalFacade.createGUIScreen();
        if (this.guiScreen == null) {
            this.log.error((Object)"Failed to initialize text-mode UI; terminating");
            throw new IllegalStateException();
        }
        this.guiScreen.setBackgroundRenderer((GUIScreenBackgroundRenderer)new DefaultBackgroundRenderer(BACKGROUND_MESSAGE));
        this.guiScreen.getScreen().startScreen();
        DialogResult confirmation = MessageBox.showMessageBox((GUIScreen)this.guiScreen, (String)this.dialogTitle, (String)this.dialogQuestion, (DialogButtons)DialogButtons.YES_NO);
        this.guiScreen.getScreen().stopScreen();
        return confirmation == DialogResult.YES;
    }
}

