/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.statistics.utils;

import java.util.regex.Pattern;

public final class CompactStacktraceBuilder {
    private final Pattern matchPattern;
    private final String separator;
    private final boolean includeMethodNames;

    public CompactStacktraceBuilder(String matchRegexp) {
        this(matchRegexp, "<", true);
    }

    public CompactStacktraceBuilder(String matchRegexp, String separator, boolean includeMethodNames) {
        this.matchPattern = Pattern.compile(matchRegexp);
        this.separator = separator;
        this.includeMethodNames = includeMethodNames;
    }

    public String getSingleLineStacktrace() {
        return this.getSingleLineStacktrace(1);
    }

    public String getSingleLineStacktrace(int skipInitial) {
        StringBuilder buffer = new StringBuilder();
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        int p = skipInitial + 1;
        while (p < stackTrace.length) {
            StackTraceElement traceStep = stackTrace[p];
            String className = traceStep.getClassName();
            if (buffer.length() != 0) {
                buffer.append(this.separator);
            }
            if (this.matchPattern.matcher(className).matches()) {
                buffer.append(className.substring(className.lastIndexOf(".") + 1));
                if (this.includeMethodNames) {
                    buffer.append(".");
                    buffer.append(traceStep.getMethodName());
                }
                buffer.append(":");
                buffer.append(traceStep.getLineNumber());
            }
            ++p;
        }
        return buffer.toString();
    }
}

