/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.gui;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.outputwriter.common.OutputLocation;
import de.rcenvironment.components.outputwriter.common.OutputLocationList;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class EditOutputLocationsCommand
extends WorkflowNodeCommand {
    private String oldGroupId;
    private OutputLocation out;
    private boolean executable = true;
    private boolean undoable = false;
    private Refreshable[] refreshable;
    private ObjectMapper mapper;
    private String oldJsonString;
    private List<String> oldInputs;

    public EditOutputLocationsCommand(OutputLocation out, Refreshable ... refreshable) {
        this.out = out;
        this.refreshable = refreshable;
        this.mapper = JsonUtils.getDefaultObjectMapper();
        this.mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
    }

    public void initialize() {
    }

    public boolean canExecute() {
        return this.executable;
    }

    public boolean canUndo() {
        return this.undoable;
    }

    public void execute() {
        try {
            EndpointDescription oldDesc;
            String inputJsonString = this.getProperties().getConfigurationDescription().getConfigurationValue("outputLocations");
            OutputLocationList list = inputJsonString != null && !inputJsonString.isEmpty() ? (OutputLocationList)this.mapper.readValue(inputJsonString, OutputLocationList.class) : new OutputLocationList();
            this.oldInputs = list.getOutputLocationById(this.out.getGroupId()) != null ? list.getOutputLocationById(this.out.getGroupId()).getInputs() : new ArrayList<String>();
            list.addOrReplaceOutputLocation(this.out);
            if (this.getProperties().getInputDescriptionsManager().isValidEndpointGroupName(this.out.getGroupId())) {
                this.getProperties().getInputDescriptionsManager().addDynamicEndpointGroupDescription("dynamicAndGroup", this.out.getGroupId());
            }
            for (String inputName : this.out.getInputs()) {
                oldDesc = this.getProperties().getInputDescriptionsManager().getEndpointDescription(inputName);
                if (oldDesc == null) continue;
                this.getProperties().getInputDescriptionsManager().editDynamicEndpointDescription(inputName, inputName, oldDesc.getDataType(), oldDesc.getMetaData(), oldDesc.getDynamicEndpointIdentifier(), this.out.getGroupId());
            }
            for (String inputName : this.oldInputs) {
                if (this.out.getInputs().contains(inputName) || (oldDesc = this.getProperties().getInputDescriptionsManager().getEndpointDescription(inputName)) == null) continue;
                this.getProperties().getInputDescriptionsManager().editDynamicEndpointDescription(inputName, inputName, oldDesc.getDataType(), oldDesc.getMetaData(), oldDesc.getDynamicEndpointIdentifier(), "write");
            }
            String outputJsonString = this.mapper.writeValueAsString((Object)list);
            this.getProperties().getConfigurationDescription().setConfigurationValue("outputLocations", outputJsonString);
            this.oldJsonString = inputJsonString;
            this.executable = false;
            this.undoable = true;
            if (this.refreshable != null) {
                Refreshable[] refreshableArray = this.refreshable;
                int n = this.refreshable.length;
                int n2 = 0;
                while (n2 < n) {
                    Refreshable r = refreshableArray[n2];
                    r.refresh();
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("Error when writing components to JSON: " + e.getMessage()));
        }
    }

    public void undo() {
        EndpointDescription oldDesc;
        String formerGroupId;
        if (this.oldGroupId != null) {
            this.getProperties().getInputDescriptionsManager().removeDynamicEndpointGroupDescription(this.out.getGroupId());
            this.getProperties().getInputDescriptionsManager().addDynamicEndpointGroupDescription("dynamicAndGroup", this.oldGroupId);
        }
        if ((formerGroupId = this.oldGroupId) == null) {
            formerGroupId = this.out.getGroupId();
        }
        for (String inputName : this.oldInputs) {
            oldDesc = this.getProperties().getInputDescriptionsManager().getEndpointDescription(inputName);
            if (oldDesc == null) continue;
            this.getProperties().getInputDescriptionsManager().editDynamicEndpointDescription(inputName, inputName, oldDesc.getDataType(), oldDesc.getMetaData(), oldDesc.getDynamicEndpointIdentifier(), formerGroupId);
        }
        for (String inputName : this.out.getInputs()) {
            if (this.oldInputs.contains(inputName) || (oldDesc = this.getProperties().getInputDescriptionsManager().getEndpointDescription(inputName)) == null) continue;
            this.getProperties().getInputDescriptionsManager().editDynamicEndpointDescription(inputName, inputName, oldDesc.getDataType(), oldDesc.getMetaData(), oldDesc.getDynamicEndpointIdentifier(), "write");
        }
        this.getProperties().getConfigurationDescription().setConfigurationValue("outputLocations", this.oldJsonString);
        this.undoable = false;
        this.executable = true;
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }
}

