/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.execution;

import de.rcenvironment.components.script.common.ScriptComponentHistoryDataItem;
import de.rcenvironment.components.script.common.registry.ScriptExecutor;
import de.rcenvironment.components.script.common.registry.ScriptExecutorFactoryRegistry;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ThreadHandler;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceException;

public class ScriptComponent
extends DefaultComponent {
    private ScriptExecutorFactoryRegistry scriptExecutorRegistry;
    private ComponentContext componentContext;
    private ScriptExecutor executor;
    private String script;
    private ScriptLanguage scriptLanguage;
    private ScriptComponentHistoryDataItem historyDataItem;
    private String scriptFileRef;
    private Log log = LogFactory.getLog(ScriptComponent.class);
    private volatile boolean canceled;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public boolean treatStartAsComponentRun() {
        return this.componentContext.getInputs().isEmpty();
    }

    public void start() throws ComponentException {
        this.canceled = false;
        try {
            this.scriptExecutorRegistry = (ScriptExecutorFactoryRegistry)this.componentContext.getService(ScriptExecutorFactoryRegistry.class);
        }
        catch (ServiceException e) {
            throw new ComponentException("ScriptExecutorFactoryRegistry was not initialized. Please check your configuration and make sure the right python path is set.", (Throwable)e);
        }
        String language = this.componentContext.getConfigurationValue("scriptLanguage");
        this.scriptLanguage = ScriptLanguage.getByName((String)language);
        this.log.debug((Object)("ScriptLanguage: " + language));
        this.setExecutor(this.scriptExecutorRegistry.requestScriptExecutor(this.scriptLanguage));
        this.script = this.componentContext.getConfigurationValue("script");
        try {
            this.executor.prepareExecutor(this.componentContext);
        }
        catch (ComponentException e) {
            throw new ComponentException("ScriptExecutorFactoryRegistry was not initialized. Please check your configuration and make sure the right python path is set.", (Throwable)e);
        }
        if (this.treatStartAsComponentRun()) {
            this.processInputs();
        }
    }

    public void processInputs() throws ComponentException {
        this.initializeNewHistoryDataItem();
        this.executor.prepareNewRun(this.scriptLanguage, this.script, this.historyDataItem);
        if (this.historyDataItem != null && this.scriptFileRef == null) {
            try {
                this.scriptFileRef = ((ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class)).createTaggedReferenceFromString(this.componentContext, this.script);
                this.historyDataItem.setScriptFileReference(this.scriptFileRef);
            }
            catch (IOException e) {
                String errorMessage = "Failed to store Python script into the data management; it will not be available in the workflow data browser";
                String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LogFactory.getLog(ScriptComponent.class), (String)errorMessage, (Throwable)e);
                this.componentContext.getLog().componentError(errorMessage, (Throwable)e, errorId);
            }
        }
        try {
            this.executor.runScript();
        }
        catch (ComponentException e) {
            if (this.canceled) {
                return;
            }
            throw e;
        }
        this.executor.postRun();
        this.writeFinalHistoryDataItem();
    }

    public void onStartInterrupted(ThreadHandler executingThreadHandler) {
        this.cancelScriptExecution(executingThreadHandler);
    }

    public void onProcessInputsInterrupted(ThreadHandler executingThreadHandler) {
        this.cancelScriptExecution(executingThreadHandler);
    }

    private void cancelScriptExecution(ThreadHandler executingThreadHandler) {
        this.canceled = true;
        if (this.executor == null) {
            this.log.error((Object)"Cannot cancel the execution, as the script executor (Script Component) is not propertly prepared.");
            return;
        }
        if (this.executor.isCancelable()) {
            this.executor.cancelScript();
        } else {
            executingThreadHandler.interrupt();
        }
    }

    public void setExecutor(ScriptExecutor executor) {
        this.executor = executor;
    }

    public void completeStartOrProcessInputsAfterFailure() throws ComponentException {
        this.writeFinalHistoryDataItem();
    }

    public void tearDown(Component.FinalComponentState state) {
        if (this.executor != null) {
            this.executor.tearDown();
        }
    }

    private void initializeNewHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.historyDataItem = new ScriptComponentHistoryDataItem();
        }
    }

    private void writeFinalHistoryDataItem() {
        if (this.historyDataItem != null && Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyDataItem);
        }
    }

    public void reset() throws ComponentException {
        super.reset();
        this.executor.reset();
    }
}

