/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.evaluationmemory.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;

public class EvaluationMemoryComponentHistoryDataItem
extends CommonComponentHistoryDataItem {
    private static final long serialVersionUID = -5443884702114523764L;
    private static final String FORMAT_VERSION_1 = "1";
    private static final String CURRENT_FORMAT_VERSION = "1";
    private static final String MEMORY_FILE_PATH = "mfp";
    private static final String MEMORY_FILE_REFERENCE = "mfr";
    private String memoryFilePath;
    private String memoryFileReference;
    private String identifier;

    public EvaluationMemoryComponentHistoryDataItem(String identifier) {
        this.identifier = identifier;
    }

    public String getFormatVersion() {
        return StringUtils.escapeAndConcat((String[])new String[]{super.getFormatVersion(), "1"});
    }

    public void setMemoryFilePath(String memoryFilePath) {
        this.memoryFilePath = memoryFilePath;
    }

    public String getMemoryFilePath() {
        return this.memoryFilePath;
    }

    public void setMemoryFileReference(String memoryFileReference) {
        this.memoryFileReference = memoryFileReference;
    }

    public String getMemoryFileReference() {
        return this.memoryFileReference;
    }

    public String serialize(TypedDatumSerializer serializer) throws IOException {
        JsonNode rootNode;
        String data = super.serialize(serializer);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(data);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        ((ObjectNode)rootNode).put(MEMORY_FILE_PATH, this.memoryFilePath);
        ((ObjectNode)rootNode).put(MEMORY_FILE_REFERENCE, this.memoryFileReference);
        return rootNode.toString();
    }

    public static EvaluationMemoryComponentHistoryDataItem fromString(String historyData, TypedDatumSerializer serializer, String identifier) throws IOException {
        EvaluationMemoryComponentHistoryDataItem historyDataItem = new EvaluationMemoryComponentHistoryDataItem(identifier);
        CommonComponentHistoryDataItem.initializeCommonHistoryDataFromString((CommonComponentHistoryDataItem)historyDataItem, (String)historyData, (TypedDatumSerializer)serializer);
        EvaluationMemoryComponentHistoryDataItem.readReferenceFromString(historyData, historyDataItem);
        return historyDataItem;
    }

    private static void readReferenceFromString(String historyData, EvaluationMemoryComponentHistoryDataItem historyDataItem) throws IOException {
        JsonNode rootNode;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(historyData);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        historyDataItem.memoryFilePath = ((ObjectNode)rootNode).get(MEMORY_FILE_PATH).textValue();
        historyDataItem.memoryFileReference = ((ObjectNode)rootNode).get(MEMORY_FILE_REFERENCE).textValue();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
}

