/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.keys.model.CommonModel;
import org.eclipse.ui.internal.keys.model.ContextElement;
import org.eclipse.ui.internal.keys.model.KeyController;
import org.eclipse.ui.services.IServiceLocator;

public class ContextModel
extends CommonModel {
    private static final String CONTEXT_ID_ACTION_SETS = "org.eclipse.ui.contexts.actionSet";
    private static final String CONTEXT_ID_INTERNAL = ".internal.";
    public static final String PROP_CONTEXTS = "contexts";
    public static final String PROP_CONTEXT_MAP = "contextIdElementMap";
    private List<ContextElement> contexts;
    private Map<String, ContextElement> contextIdToFilteredContexts;
    private Map<String, ContextElement> contextIdToElement;
    private IContextService contextService;

    public ContextModel(KeyController kc) {
        super(kc);
    }

    public void init(IServiceLocator locator) {
        Context[] definedContexts;
        this.contextService = locator.getService(IContextService.class);
        this.contexts = new ArrayList<ContextElement>();
        this.contextIdToFilteredContexts = new HashMap<String, ContextElement>();
        this.contextIdToElement = new HashMap<String, ContextElement>();
        Context[] contextArray = definedContexts = this.contextService.getDefinedContexts();
        int n = definedContexts.length;
        int n2 = 0;
        while (n2 < n) {
            Context definedContext = contextArray[n2];
            ContextElement ce = new ContextElement(this.controller);
            ce.init(definedContext);
            ce.setParent(this);
            this.contexts.add(ce);
            this.contextIdToElement.put(definedContext.getId(), ce);
            ++n2;
        }
    }

    public List<ContextElement> getContexts() {
        return this.contexts;
    }

    public void setContexts(List<ContextElement> contexts) {
        List<ContextElement> old = this.contexts;
        this.contexts = contexts;
        this.controller.firePropertyChange(this, PROP_CONTEXTS, old, contexts);
    }

    public Map<String, ContextElement> getContextIdToElement() {
        return this.contextIdToElement;
    }

    public void setContextIdToElement(Map<String, ContextElement> contextToElement) {
        Map<String, ContextElement> old = this.contextIdToElement;
        this.contextIdToElement = contextToElement;
        this.controller.firePropertyChange(this, PROP_CONTEXT_MAP, old, contextToElement);
    }

    public void filterContexts(boolean actionSets, boolean internal) {
        String parentId;
        for (ContextElement contextElement : this.contexts) {
            boolean removeContext = false;
            if (actionSets && contextElement.getId().equalsIgnoreCase(CONTEXT_ID_ACTION_SETS)) {
                removeContext = true;
            } else {
                try {
                    parentId = ((Context)contextElement.getModelObject()).getParentId();
                    while (parentId != null) {
                        if (parentId.equalsIgnoreCase(CONTEXT_ID_ACTION_SETS)) {
                            removeContext = true;
                        }
                        parentId = this.contextService.getContext(parentId).getParentId();
                    }
                }
                catch (NotDefinedException notDefinedException) {}
            }
            if (internal && contextElement.getId().contains(CONTEXT_ID_INTERNAL)) {
                removeContext = true;
            }
            if (!removeContext) continue;
            this.contextIdToFilteredContexts.put(contextElement.getId(), contextElement);
            this.contextIdToElement.remove(contextElement.getId());
        }
        this.contexts.removeAll(this.contextIdToFilteredContexts.values());
        Iterator<String> iterator = this.contextIdToFilteredContexts.keySet().iterator();
        while (iterator.hasNext()) {
            boolean restoreContext = false;
            ContextElement contextElement = this.contextIdToFilteredContexts.get(iterator.next());
            try {
                if (!actionSets) {
                    if (contextElement.getId().equalsIgnoreCase(CONTEXT_ID_ACTION_SETS)) {
                        restoreContext = true;
                    } else {
                        parentId = ((Context)contextElement.getModelObject()).getParentId();
                        if (parentId != null && parentId.equalsIgnoreCase(CONTEXT_ID_ACTION_SETS)) {
                            restoreContext = true;
                        }
                    }
                }
            }
            catch (NotDefinedException notDefinedException) {}
            if (!internal && contextElement.getId().contains(CONTEXT_ID_INTERNAL)) {
                restoreContext = true;
            }
            if (!restoreContext) continue;
            this.contexts.add(contextElement);
            this.contextIdToElement.put(contextElement.getId(), contextElement);
            iterator.remove();
        }
    }
}

