/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.common;

import de.rcenvironment.core.instancemanagement.InstanceManagementService;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ManagedInstance {
    private final String id;
    private String installationId;
    private Map<String, Integer> serverPorts = new HashMap<String, Integer>();
    private final List<String> configuredAutostartConnectionIds = new ArrayList<String>();
    private String lastCommandOutput;
    private Map<String, String> cachedFileContent = new HashMap<String, String>();
    private boolean potentiallyRunning;
    private final InstanceManagementService instanceManagementService;
    private final Log log = LogFactory.getLog(this.getClass());

    public ManagedInstance(String instanceId, String installationId, InstanceManagementService instanceManagementService) {
        this.id = instanceId;
        this.installationId = installationId;
        this.instanceManagementService = instanceManagementService;
    }

    public String toString() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public synchronized String getInstallationId() {
        return this.installationId;
    }

    public synchronized void setInstallationId(String installationId) {
        this.installationId = installationId;
    }

    public synchronized Integer getServerPort(String connectionType, int serverNumber) {
        if (connectionType.equals("ssh") || connectionType.equals("upl")) {
            connectionType = "ssh";
            serverNumber = 0;
        }
        return this.serverPorts.get(String.valueOf(connectionType) + serverNumber);
    }

    public synchronized void setServerPort(String connectionType, int serverNumber, Integer serverPort) {
        this.serverPorts.put(String.valueOf(connectionType) + serverNumber, serverPort);
    }

    public List<String> accessConfiguredAutostartConnectionIds() {
        return this.configuredAutostartConnectionIds;
    }

    public synchronized String getLastCommandOutput() {
        return this.lastCommandOutput;
    }

    public synchronized void setLastCommandOutput(String lastCommandOutput) {
        this.lastCommandOutput = lastCommandOutput;
    }

    public synchronized String getProfileRelativeFileContent(String relativePath, boolean forceReload) throws OperationFailureException {
        String content;
        File fileLocation;
        if (!this.potentiallyRunning) {
            if (this.cachedFileContent.containsKey(relativePath)) {
                return this.cachedFileContent.get(relativePath);
            }
        } else {
            this.log.warn((Object)("Requested file " + relativePath + " of potentially running instance " + this.id + "; not using I/O cache"));
        }
        if (!(fileLocation = this.instanceManagementService.resolveRelativePathWithinProfileDirectory(this.id, relativePath)).exists()) {
            content = null;
        } else {
            try {
                content = FileUtils.readFileToString((File)fileLocation, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new OperationFailureException("Error opening profile-relative file " + fileLocation, (Throwable)e);
            }
        }
        if (!this.potentiallyRunning) {
            this.cachedFileContent.put(relativePath, content);
        }
        return content;
    }

    public synchronized File getAbsolutePathFromRelative(String relativePath) {
        return this.instanceManagementService.resolveRelativePathWithinProfileDirectory(this.id, relativePath);
    }

    public synchronized void onStarting() {
        this.potentiallyRunning = true;
        this.cachedFileContent.clear();
    }

    public synchronized void onStopped() {
        this.potentiallyRunning = false;
    }

    public synchronized boolean getPotentiallyRunning() {
        return this.potentiallyRunning;
    }
}

