/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileInPlaceEditorInput;

public final class EditorsHelper {
    private static final String TXT = "txt";

    private EditorsHelper() {
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return TXT;
        }
        String f = filename.trim();
        int lastSlash = f.lastIndexOf(File.separator);
        int lastDot = f.lastIndexOf(".");
        if (lastDot > lastSlash) {
            return f.substring(lastDot + 1);
        }
        return TXT;
    }

    private static IEditorDescriptor findEditorForFilename(String filename) {
        IEditorDescriptor editor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(filename);
        if (editor == null) {
            editor = PlatformUI.getWorkbench().getEditorRegistry().getEditors("*.txt")[0];
        }
        return editor;
    }

    public static boolean closeEditor(IEditorPart editor, boolean save) {
        IWorkbenchPage page;
        IWorkbenchPartSite site = editor.getSite();
        if (site != null && (page = site.getPage()) != null) {
            return page.closeEditor(editor, save);
        }
        return true;
    }

    public static void openFileInEditor(IFile ifile, Runnable ... callbacks) throws PartInitException {
        if (ifile == null) {
            return;
        }
        EditorsHelper.openAndObserveFileInEditor(new ObservedFile(ifile), EditorsHelper.findEditorForFilename(ifile.getName()), (IEditorInput)new FileInPlaceEditorInput(ifile), callbacks);
    }

    public static void openExternalFileInEditor(File file, Runnable ... callbacks) throws PartInitException {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath()));
        EditorsHelper.openAndObserveFileInEditor(new ObservedFile(file), EditorsHelper.findEditorForFilename(file.getName()), (IEditorInput)new FileStoreEditorInput(fileStore), callbacks);
    }

    private static IEditorPart openAndObserveFileInEditor(ObservedFile observedFile, IEditorDescriptor editorDescriptor, IEditorInput editorInput, final Runnable ... callbacks) throws PartInitException {
        final IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(editorInput, editorDescriptor.getId());
        if (editor != null) {
            EditorsHelper.observeEditedFile(observedFile, editor, new Runnable(){

                @Override
                public void run() {
                    if (callbacks != null) {
                        Runnable[] runnableArray = callbacks;
                        int n = callbacks.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Runnable action = runnableArray[n2];
                            action.run();
                            ++n2;
                        }
                    }
                }
            });
            PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean arg1) {
                    return EditorsHelper.closeEditor(editor, true);
                }

                public void postShutdown(IWorkbench workbench) {
                }
            });
        }
        return editor;
    }

    private static void observeEditedFile(final ObservedFile observedFile, IEditorPart editor, final Runnable callback) {
        final AtomicLong timeStamp = new AtomicLong(observedFile.getLastModified());
        editor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int id) {
                long ts;
                if (id == 257 && !((IEditorPart)source).isDirty() && (ts = observedFile.getLastModified()) > timeStamp.longValue()) {
                    timeStamp.set(ts);
                    callback.run();
                }
            }
        });
    }

    static class ObservedFile {
        private File file;
        private IFile iFile;

        ObservedFile(IFile iFile) {
            this.iFile = iFile;
        }

        ObservedFile(File file) {
            this.file = file;
        }

        public long getLastModified() {
            if (this.file != null) {
                return this.file.lastModified();
            }
            return this.iFile.getModificationStamp();
        }
    }
}

