/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.testing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class JsonMatchers {
    private JsonMatchers() {
    }

    public static <T> Matcher<String> isJsonList(final Matcher<List<T>> matcher) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText("is a valid JSON list that");
                matcher.describeTo(description);
            }

            protected void describeMismatchSafely(String string, Description mismatchDescription) {
                try {
                    mismatchDescription.appendText("is a valid JSON list that");
                    List<Object> jsonList = this.tryParseJsonListFromString(string);
                    matcher.describeMismatch(jsonList, mismatchDescription);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    mismatchDescription.appendText("string \"" + string + "\" does not describe not a valid JSON list");
                }
            }

            protected boolean matchesSafely(String string) {
                try {
                    List<Object> jsonList = this.tryParseJsonListFromString(string);
                    return matcher.matches(jsonList);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    return false;
                }
            }

            private List<Object> tryParseJsonListFromString(String string) throws JsonProcessingException {
                return (List)new ObjectMapper().readValue(string, ArrayList.class);
            }
        };
    }

    public static Matcher<String> isJsonObject() {
        return JsonMatchers.isJsonObject((Matcher<? extends Object>)CoreMatchers.anything());
    }

    public static Matcher<String> isJsonObject(final Matcher<? extends Object> matcher) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText("is a valid JSON object that");
                matcher.describeTo(description);
            }

            protected void describeMismatchSafely(String string, Description mismatchDescription) {
                try {
                    mismatchDescription.appendText("is a valid JSON object that");
                    Map<String, Object> jsonObject = this.tryParseJsonObjectFromString(string);
                    matcher.describeMismatch(jsonObject, mismatchDescription);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    mismatchDescription.appendText("string \"" + string + "\" is not a valid JSON object");
                }
            }

            protected boolean matchesSafely(String string) {
                try {
                    Map<String, Object> jsonObject = this.tryParseJsonObjectFromString(string);
                    return matcher.matches(jsonObject);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    return false;
                }
            }

            private Map<String, Object> tryParseJsonObjectFromString(String string) throws JsonProcessingException {
                return (Map)new ObjectMapper().readValue(string, HashMap.class);
            }
        };
    }
}

