/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration.editor;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.WorkflowIntegrationEditorInput;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Optional;
import java.util.TreeSet;

public final class WorkflowIntegrationEditorInputValidator {
    private WorkflowIntegrationEditorInputValidator() {
    }

    protected static Optional<String> validate(WorkflowIntegrationEditorInput editorInput) {
        TreeSet<String> nonValidComponents = new TreeSet<String>();
        WorkflowDescription workflowDescription = editorInput.getAdapter(WorkflowDescription.class);
        for (WorkflowNode node : workflowDescription.getWorkflowNodes()) {
            for (EndpointDescription input : node.getInputDescriptionsManager().getEndpointDescriptions()) {
                if (input.getEndpointDefinition() != null) continue;
                nonValidComponents.add(node.getComponentDescription().getComponentInterface().getDisplayName());
            }
            for (EndpointDescription output : node.getOutputDescriptionsManager().getEndpointDescriptions()) {
                if (output.getEndpointDefinition() != null) continue;
                nonValidComponents.add(node.getComponentDescription().getComponentInterface().getDisplayName());
            }
        }
        if (!nonValidComponents.isEmpty()) {
            return Optional.of(StringUtils.format((String)"Component meta data information missing for the following components:\n\n%s\n\nMost likely these components are currently not available at the local RCE instance.", (Object[])new Object[]{String.join((CharSequence)"\n", nonValidComponents)}));
        }
        return Optional.empty();
    }
}

