/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.filters;

import com.google.common.base.Predicate;
import edu.uci.ics.jung.algorithms.filters.Filter;
import edu.uci.ics.jung.graph.Graph;

public class EdgePredicateFilter<V, E>
implements Filter<V, E> {
    protected Predicate<E> edge_pred;

    public EdgePredicateFilter(Predicate<E> edge_pred) {
        this.edge_pred = edge_pred;
    }

    @Override
    public Graph<V, E> apply(Graph<V, E> g) {
        Graph filtered;
        try {
            filtered = (Graph)g.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to create copy of existing graph: ", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to create copy of existing graph: ", e);
        }
        for (Object v : g.getVertices()) {
            filtered.addVertex(v);
        }
        for (Object e : g.getEdges()) {
            if (!this.edge_pred.apply(e)) continue;
            filtered.addEdge(e, g.getIncidentVertices(e));
        }
        return filtered;
    }
}

