/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.model.internal;

import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.model.NetworkMessage;
import de.rcenvironment.core.communication.protocol.MessageMetaData;
import de.rcenvironment.core.communication.utils.MessageUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AbstractNetworkMessage
implements NetworkMessage {
    public static final String METADATA_KEY_REQUEST_ID = "common.requestId";
    protected MessageMetaData metaDataWrapper;
    private Map<String, String> metaData;
    private byte[] contentBytes;
    private Serializable deserializedContent;

    public AbstractNetworkMessage() {
        this.setMetaData(new HashMap<String, String>());
    }

    public AbstractNetworkMessage(Map<String, String> metaData) {
        this.setMetaData(metaData);
    }

    @Override
    public String getMessageType() {
        return this.metaDataWrapper.getMessageType();
    }

    @Override
    public byte[] getContentBytes() {
        return this.contentBytes;
    }

    public void setContentBytes(byte[] contentBytes) {
        this.contentBytes = contentBytes;
    }

    @Override
    public synchronized Serializable getDeserializedContent() throws SerializationException {
        if (this.contentBytes == null) {
            return null;
        }
        if (this.deserializedContent == null) {
            this.deserializedContent = MessageUtils.deserializeObject(this.contentBytes);
        }
        return this.deserializedContent;
    }

    public void setContent(Serializable messageBody) throws SerializationException {
        this.setContentBytes(MessageUtils.serializeObject(messageBody));
    }

    @Override
    public MessageMetaData accessMetaData() {
        return this.metaDataWrapper;
    }

    @Override
    public Map<String, String> accessRawMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map<String, String> metaData) {
        this.metaData = metaData;
        this.metaDataWrapper = MessageMetaData.wrap(metaData);
    }

    public String getRequestId() {
        return this.metaDataWrapper.getValue(METADATA_KEY_REQUEST_ID);
    }

    public void setRequestId(String requestId) {
        this.metaDataWrapper.setValue(METADATA_KEY_REQUEST_ID, requestId);
    }
}

