/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.component.workflow.execution.api.PersistentWorkflowDescriptionLoaderService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.component.workflow.update.api.PersistentWorkflowDescription;
import de.rcenvironment.core.component.workflow.update.api.PersistentWorkflowDescriptionUpdateService;
import de.rcenvironment.core.component.workflow.update.api.PersistentWorkflowDescriptionUpdateUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class PersistentWorkflowDescriptionLoaderServiceImpl
implements PersistentWorkflowDescriptionLoaderService {
    private static final String FAILED_TO_LOAD_WORKFLOW_FILE = "Failed to load workflow file: ";
    private PersistentWorkflowDescriptionUpdateService wfUpdateService;
    private final Log log = LogFactory.getLog(this.getClass());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WorkflowDescription loadWorkflowDescriptionFromFile(File wfFile, WorkflowDescriptionLoaderCallback callback) throws WorkflowFileException {
        try {
            WorkflowDescription wd;
            int wfVersion = this.readWorkflowVersionNumber(wfFile);
            if (wfVersion > 5) {
                throw new WorkflowFileException(FAILED_TO_LOAD_WORKFLOW_FILE + wfFile.getAbsolutePath() + StringUtils.format((String)". Its version (%d) is older than the expected one (%d). Most likely reason: Internal error on workflow update.", (Object[])new Object[]{wfVersion, 5}));
            }
            WorkflowDescriptionPersistenceHandler wdPesistenceHandler = new WorkflowDescriptionPersistenceHandler();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (FileInputStream fileInputStream = new FileInputStream(wfFile);){
                    wd = wdPesistenceHandler.readWorkflowDescriptionFromStream(fileInputStream);
                    return wd;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (WorkflowFileException e) {
                String backupFilename;
                block25: {
                    if (e.getParsedWorkflowDescription() == null) throw e;
                    if (!callback.arePartlyParsedWorkflowConsiderValid()) throw e;
                    backupFilename = String.valueOf(PersistentWorkflowDescriptionUpdateUtils.getFilenameForBackupFile(wfFile)) + ".wf";
                    FileUtils.copyFile((File)wfFile, (File)new File(wfFile.getParentFile().getAbsolutePath(), backupFilename));
                    wd = e.getParsedWorkflowDescription();
                    Throwable throwable = null;
                    Object var9_16 = null;
                    try {
                        FileOutputStream fos = new FileOutputStream(wfFile);
                        try {
                            try (ByteArrayOutputStream baos = wdPesistenceHandler.writeWorkflowDescriptionToStream(wd);){
                                baos.writeTo(fos);
                            }
                            if (fos == null) break block25;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (fos == null) throw throwable;
                            fos.close();
                            throw throwable;
                        }
                        fos.close();
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                            throw throwable;
                        }
                        if (throwable == throwable4) throw throwable;
                        throwable.addSuppressed(throwable4);
                        throw throwable;
                    }
                }
                callback.onWorkflowFileParsingPartlyFailed(backupFilename);
                return wd;
            }
        }
        catch (IOException | RuntimeException e) {
            throw new WorkflowFileException(FAILED_TO_LOAD_WORKFLOW_FILE + wfFile.getAbsolutePath(), e);
        }
    }

    @Override
    public WorkflowDescription loadWorkflowDescriptionFromFileConsideringUpdates(File wfFile, WorkflowDescriptionLoaderCallback callback, boolean abortIfWorkflowUpdateRequired) throws WorkflowFileException {
        try {
            block18: {
                int wfVersion = this.readWorkflowVersionNumber(wfFile);
                if (wfVersion > 5) {
                    throw new WorkflowFileException(FAILED_TO_LOAD_WORKFLOW_FILE + wfFile.getAbsolutePath() + StringUtils.format((String)". Its version (%d) is newer than the expected one (%d). Most likely reason: it was opened with a newer version of RCE before.", (Object[])new Object[]{wfVersion, 5}));
                }
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream fileInputStream = new FileInputStream(wfFile);){
                    boolean updateRequired;
                    PersistentWorkflowDescription persistentDescription = this.wfUpdateService.createPersistentWorkflowDescription(IOUtils.toString((InputStream)fileInputStream, (String)"UTF-8"));
                    boolean nonSilentUpdateRequired = updateRequired = this.wfUpdateService.isUpdateForWorkflowDescriptionAvailable(persistentDescription, false);
                    if (updateRequired && abortIfWorkflowUpdateRequired) {
                        throw new WorkflowFileException("The workflow file " + wfFile.getAbsolutePath() + " would require an update before execution, but the 'fail on required update' flag has been set. " + "Typically, this means that it was generated from an internal template which should be updated.");
                    }
                    if (!nonSilentUpdateRequired) {
                        updateRequired = this.wfUpdateService.isUpdateForWorkflowDescriptionAvailable(persistentDescription, true);
                    }
                    if (!updateRequired) break block18;
                    String backupFilename = null;
                    if (nonSilentUpdateRequired) {
                        backupFilename = String.valueOf(PersistentWorkflowDescriptionUpdateUtils.getFilenameForBackupFile(wfFile)) + ".wf";
                        FileUtils.copyFile((File)wfFile, (File)new File(wfFile.getParentFile().getAbsolutePath(), backupFilename));
                    }
                    try {
                        this.updateWorkflow(persistentDescription, wfFile);
                        this.onWorkflowFileUpdated(wfFile, !nonSilentUpdateRequired, backupFilename, callback);
                    }
                    catch (IOException | RuntimeException e) {
                        if (nonSilentUpdateRequired) {
                            throw new WorkflowFileException(StringUtils.format((String)"Failed to update workflow file: %s. Backup file was generated: %s.", (Object[])new Object[]{wfFile.getAbsolutePath(), backupFilename}), e);
                        }
                        throw new WorkflowFileException(StringUtils.format((String)"Failed to update workflow file: %s.", (Object[])new Object[]{wfFile.getAbsolutePath()}), e);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return this.loadWorkflowDescriptionFromFile(wfFile, callback);
        }
        catch (IOException e) {
            throw new WorkflowFileException(FAILED_TO_LOAD_WORKFLOW_FILE + wfFile.getAbsolutePath(), e);
        }
    }

    @Override
    public WorkflowDescription loadWorkflowDescriptionFromFileConsideringUpdates(File wfFile, WorkflowDescriptionLoaderCallback callback) throws WorkflowFileException {
        return this.loadWorkflowDescriptionFromFileConsideringUpdates(wfFile, callback, false);
    }

    @Reference
    protected void bindPersistentWorkflowDescriptionUpdateService(PersistentWorkflowDescriptionUpdateService newService) {
        this.wfUpdateService = newService;
    }

    private int readWorkflowVersionNumber(File wfFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream fileInputStream = new FileInputStream(wfFile);){
            return new WorkflowDescriptionPersistenceHandler().readWorkflowVersionNumber(fileInputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateWorkflow(PersistentWorkflowDescription persWfDescr, File file) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream tempInputStream = IOUtils.toInputStream((String)this.wfUpdateService.performWorkflowDescriptionUpdate(persWfDescr).getWorkflowDescriptionAsString(), (Charset)StandardCharsets.UTF_8);){
            FileUtils.write((File)file, (CharSequence)IOUtils.toString((InputStream)tempInputStream));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void onWorkflowFileUpdated(File wfFile, boolean silentUpdate, String backupFilename, WorkflowDescriptionLoaderCallback callback) {
        if (silentUpdate) {
            String message = StringUtils.format((String)"'%s' was updated (silently) (full path: %s)", (Object[])new Object[]{wfFile.getName(), wfFile.getAbsolutePath()});
            this.log.debug((Object)message);
            callback.onSilentWorkflowFileUpdated(message);
        } else {
            String message = StringUtils.format((String)"'%s' was updated (non-silently); backup file generated: %s (full path: %s)", (Object[])new Object[]{wfFile.getName(), backupFilename, wfFile.getAbsolutePath()});
            this.log.debug((Object)message);
            callback.onNonSilentWorkflowFileUpdated(message, backupFilename);
        }
    }
}

