/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.statushandlers;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.statushandlers.IStatusDialogConstants;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.statushandlers.WorkbenchStatusDialogManager;

public class WorkbenchErrorHandler
extends AbstractStatusHandler {
    private WorkbenchStatusDialogManager statusDialogManager;

    @Override
    public boolean supportsNotification(int type) {
        if (type == 1) {
            return true;
        }
        return super.supportsNotification(type);
    }

    @Override
    public void handle(StatusAdapter statusAdapter, int style) {
        statusAdapter.setProperty(WorkbenchStatusDialogManager.HINT, style);
        if ((style & 2) == 2 || (style & 4) == 4) {
            boolean block = (style & 4) == 4;
            Runnable uiRunnable = () -> {
                if (!PlatformUI.isWorkbenchRunning()) {
                    if ((style & 1) == 0) {
                        WorkbenchErrorHandler.log(statusAdapter);
                    }
                    return;
                }
                this.showStatusAdapter(statusAdapter, block);
            };
            if (Display.getCurrent() != null) {
                uiRunnable.run();
            } else {
                try {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(uiRunnable);
                }
                catch (SWTException e) {
                    if (e.code == 45) {
                        WorkbenchErrorHandler.log(statusAdapter);
                        return;
                    }
                    throw e;
                }
            }
        }
        if ((style & 1) == 1) {
            StatusManager.getManager().addLoggedStatus(statusAdapter.getStatus());
            WorkbenchErrorHandler.log(statusAdapter);
        }
    }

    private void showStatusAdapter(StatusAdapter statusAdapter, boolean block) {
        this.getStatusDialogManager().addStatusAdapter(statusAdapter, block);
        if (block) {
            Shell shell;
            while ((shell = this.getStatusDialogShell()) != null && !shell.isDisposed()) {
                if (shell.getDisplay().readAndDispatch()) continue;
                shell.getDisplay().sleep();
            }
        }
    }

    private static void log(StatusAdapter statusAdapter) {
        WorkbenchPlugin.log(statusAdapter.getStatus());
    }

    private Shell getStatusDialogShell() {
        return (Shell)this.getStatusDialogManager().getProperty(IStatusDialogConstants.SHELL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkbenchStatusDialogManager getStatusDialogManager() {
        if (this.statusDialogManager == null) {
            WorkbenchErrorHandler workbenchErrorHandler = this;
            synchronized (workbenchErrorHandler) {
                if (this.statusDialogManager == null) {
                    this.statusDialogManager = new WorkbenchStatusDialogManager(null);
                    this.statusDialogManager.setProperty(IStatusDialogConstants.SHOW_SUPPORT, Boolean.TRUE);
                    this.statusDialogManager.setProperty(IStatusDialogConstants.HANDLE_OK_STATUSES, Boolean.TRUE);
                    this.statusDialogManager.setProperty(IStatusDialogConstants.ERRORLOG_LINK, Boolean.TRUE);
                    this.configureStatusDialog(this.statusDialogManager);
                }
            }
        }
        return this.statusDialogManager;
    }

    protected void configureStatusDialog(WorkbenchStatusDialogManager statusDialog) {
    }
}

