/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.routing.internal.v2;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.channel.MessageChannelLifecycleListener;
import de.rcenvironment.core.communication.channel.MessageChannelLifecycleListenerAdapter;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.nodeproperties.NodePropertiesService;
import de.rcenvironment.core.communication.nodeproperties.NodeProperty;
import de.rcenvironment.core.communication.nodeproperties.spi.RawNodePropertiesChangeListener;
import de.rcenvironment.core.communication.routing.internal.v2.Link;
import de.rcenvironment.core.communication.routing.internal.v2.LinkState;
import de.rcenvironment.core.communication.routing.internal.v2.LinkStateKnowledgeChangeListener;
import de.rcenvironment.core.communication.routing.internal.v2.LinkStateSerializer;
import de.rcenvironment.core.communication.transport.spi.MessageChannel;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.service.AdditionalServiceDeclaration;
import de.rcenvironment.core.utils.common.service.AdditionalServicesProvider;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DistributedLinkStateManager
implements AdditionalServicesProvider {
    private static final String LSA_PROPERTY_KEY = "lsa";
    private final AsyncOrderedCallbackManager<LinkStateKnowledgeChangeListener> callbackManager = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);
    private NodePropertiesService nodePropertiesService;
    private NodeConfigurationService nodeConfigurationService;
    private final Map<String, Link> localOutgoingLinks;
    private volatile Map<InstanceNodeSessionId, LinkState> linkStateKnowledgeSnapshot;
    private volatile LinkState localLinkStateSnapshot;
    private InstanceNodeSessionId localNodeId;
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled(this.getClass());
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean localNodeIsRelay;
    private NodeIdentifierService nodeIdentifierService;

    public DistributedLinkStateManager() {
        this.localOutgoingLinks = new HashMap<String, Link>();
        this.linkStateKnowledgeSnapshot = Collections.unmodifiableMap(new HashMap());
    }

    public synchronized void activate() {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        this.localNodeId = this.nodeConfigurationService.getInstanceNodeSessionId();
        this.localNodeIsRelay = this.nodeConfigurationService.isRelay();
        this.localLinkStateSnapshot = new LinkState(this.localOutgoingLinks.values());
        this.setNewLocalLinkState(this.localLinkStateSnapshot);
        if (!this.localNodeIsRelay) {
            String serializedEmptyLinkState = LinkStateSerializer.serialize(new ArrayList<Link>());
            this.nodePropertiesService.addOrUpdateLocalNodeProperty(LSA_PROPERTY_KEY, serializedEmptyLinkState);
        }
    }

    public Collection<AdditionalServiceDeclaration> defineAdditionalServices() {
        ArrayList<AdditionalServiceDeclaration> result = new ArrayList<AdditionalServiceDeclaration>();
        result.add(new AdditionalServiceDeclaration(RawNodePropertiesChangeListener.class, (Object)new RawNodePropertiesChangeListener(){

            @Override
            public void onRawNodePropertiesAddedOrModified(Collection<? extends NodeProperty> newProperties) {
                DistributedLinkStateManager.this.updateOnNodePropertiesAddedOrModified(newProperties);
            }
        }));
        result.add(new AdditionalServiceDeclaration(MessageChannelLifecycleListener.class, (Object)new MessageChannelLifecycleListenerAdapter(){

            @Override
            public void onOutgoingChannelTerminated(MessageChannel connection) {
                DistributedLinkStateManager.this.updateOnOutgoingChannelTerminated(connection);
            }

            @Override
            public void onOutgoingChannelEstablished(MessageChannel connection) {
                DistributedLinkStateManager.this.updateOnOutgoingChannelEstablished(connection);
            }
        }));
        return result;
    }

    public Map<InstanceNodeSessionId, LinkState> getCurrentKnowledge() {
        return this.linkStateKnowledgeSnapshot;
    }

    public void bindNodePropertiesService(NodePropertiesService newInstance) {
        this.nodePropertiesService = newInstance;
    }

    public void bindNodeConfigurationService(NodeConfigurationService newInstance) {
        this.nodeConfigurationService = newInstance;
        this.nodeIdentifierService = this.nodeConfigurationService.getNodeIdentifierService();
    }

    public synchronized void addLinkStateKnowledgeChangeListener(LinkStateKnowledgeChangeListener listener) {
        final Map<InstanceNodeSessionId, LinkState> currentKnowledgeSnapshotCopy = this.linkStateKnowledgeSnapshot;
        this.callbackManager.addListenerAndEnqueueCallback((Object)listener, (AsyncCallback)new AsyncCallback<LinkStateKnowledgeChangeListener>(){

            public void performCallback(LinkStateKnowledgeChangeListener listener) {
                listener.onLinkStateKnowledgeChanged(currentKnowledgeSnapshotCopy);
            }
        });
    }

    public void removeLinkStateKnowledgeChangeListener(LinkStateKnowledgeChangeListener listener) {
        this.callbackManager.removeListener((Object)listener);
    }

    private synchronized void updateOnNodePropertiesAddedOrModified(Collection<? extends NodeProperty> newProperties) {
        HashMap<InstanceNodeSessionId, LinkState> deltaMap = null;
        for (NodeProperty nodeProperty : newProperties) {
            if (!nodeProperty.getKey().equals(LSA_PROPERTY_KEY)) continue;
            String linkStateData = nodeProperty.getValue();
            InstanceNodeSessionId updateSourceInstanceSessionId = nodeProperty.getInstanceNodeSessionId();
            if (this.localNodeId.isSameInstanceNodeSessionAs(updateSourceInstanceSessionId)) continue;
            try {
                LinkState deserialized = LinkStateSerializer.deserialize(linkStateData);
                if (deltaMap == null) {
                    deltaMap = new HashMap<InstanceNodeSessionId, LinkState>();
                }
                deltaMap.put(updateSourceInstanceSessionId, deserialized);
            }
            catch (IOException e) {
                this.log.error((Object)("Ignoring unreadable link state update for node " + updateSourceInstanceSessionId), (Throwable)e);
            }
        }
        if (deltaMap != null) {
            if (this.verboseLogging) {
                StringBuilder stringBuilder = new StringBuilder();
                String locationInfo = "";
                if (this.localNodeId != null) {
                    locationInfo = " " + this.localNodeId.toString();
                }
                stringBuilder.append(StringUtils.format((String)"Detected %d LSA property changes%s: ", (Object[])new Object[]{deltaMap.size(), locationInfo}));
                for (Map.Entry entry : deltaMap.entrySet()) {
                    stringBuilder.append(StringUtils.format((String)"\n  %s -> %s", (Object[])new Object[]{entry.getKey(), ((LinkState)entry.getValue()).getLinks()}));
                }
                this.log.debug((Object)stringBuilder.toString());
            }
            this.mergeIntoEffectiveLinkStateKnowledge(deltaMap);
        }
    }

    private synchronized void updateOnOutgoingChannelEstablished(MessageChannel connection) {
        String linkId = connection.getChannelId();
        String remoteInstanceNodeSessionIdString = connection.getRemoteNodeInformation().getInstanceNodeSessionIdString();
        Link link = new Link(linkId, remoteInstanceNodeSessionIdString);
        this.localOutgoingLinks.put(linkId, link);
        this.localLinkStateSnapshot = new LinkState(this.localOutgoingLinks.values());
        this.setNewLocalLinkState(this.localLinkStateSnapshot);
    }

    private synchronized void updateOnOutgoingChannelTerminated(MessageChannel connection) {
        this.localOutgoingLinks.remove(connection.getChannelId());
        this.localLinkStateSnapshot = new LinkState(this.localOutgoingLinks.values());
        this.setNewLocalLinkState(this.localLinkStateSnapshot);
    }

    private void setNewLocalLinkState(final LinkState linkState) {
        if (this.localNodeIsRelay) {
            String serialized = LinkStateSerializer.serialize(linkState.getLinks());
            this.nodePropertiesService.addOrUpdateLocalNodeProperty(LSA_PROPERTY_KEY, serialized);
        }
        HashMap<InstanceNodeSessionId, LinkState> deltaMap = new HashMap<InstanceNodeSessionId, LinkState>();
        deltaMap.put(this.localNodeId, linkState);
        this.mergeIntoEffectiveLinkStateKnowledge(deltaMap);
        this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<LinkStateKnowledgeChangeListener>(){

            public void performCallback(LinkStateKnowledgeChangeListener listener) {
                listener.onLocalLinkStateUpdated(linkState);
            }
        });
    }

    private void mergeIntoEffectiveLinkStateKnowledge(Map<InstanceNodeSessionId, LinkState> deltaMap) {
        HashMap<InstanceNodeSessionId, LinkState> tempMap = new HashMap<InstanceNodeSessionId, LinkState>(this.linkStateKnowledgeSnapshot);
        tempMap.putAll(deltaMap);
        final Map<InstanceNodeSessionId, LinkState> knowledgeSnapshotCopy = this.linkStateKnowledgeSnapshot = Collections.unmodifiableMap(tempMap);
        final Map<InstanceNodeSessionId, LinkState> deltaMapCopy = Collections.unmodifiableMap(deltaMap);
        this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<LinkStateKnowledgeChangeListener>(){

            public void performCallback(LinkStateKnowledgeChangeListener listener) {
                listener.onLinkStateKnowledgeChanged(knowledgeSnapshotCopy);
                listener.onLinkStatesUpdated(deltaMapCopy);
            }
        });
    }
}

