/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.testing;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class ListMatchers {
    private ListMatchers() {
    }

    public static <T> Matcher<T> emptyList() {
        return new BaseMatcher<T>(){

            public boolean matches(Object arg0) {
                return arg0 instanceof List && ((List)arg0).isEmpty();
            }

            public void describeTo(Description arg0) {
                arg0.appendText("is an empty list");
            }
        };
    }

    public static <T> Matcher<Object> list(final Matcher<List<T>> matcher) {
        return new BaseMatcher<Object>(){

            public boolean matches(Object item) {
                return item instanceof List && matcher.matches(item);
            }

            public void describeTo(Description arg0) {
                arg0.appendText("is a list");
            }
        };
    }

    @SafeVarargs
    public static <T> Matcher<List<T>> containingInAnyOrder(final Matcher<T> ... matchers) {
        return new TypeSafeMatcher<List<T>>(){

            public void describeTo(Description arg0) {
                arg0.appendValueList("contains elements that ", " and ", " in any order", (Object[])matchers);
            }

            protected boolean matchesSafely(List<T> arg0) {
                LinkedList<Matcher> notYetMatched = new LinkedList<Matcher>(Arrays.asList(matchers));
                for (Object entry : arg0) {
                    notYetMatched.stream().filter(matcher -> matcher.matches(entry)).findAny().ifPresent(notYetMatched::remove);
                }
                return notYetMatched.isEmpty();
            }
        };
    }
}

