/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.api;

import de.rcenvironment.core.component.execution.api.ConsoleRow;
import java.util.regex.Pattern;

public class ConsoleRowFilter
implements Cloneable {
    private String workflow;
    private String component;
    private boolean includeLifecycleEvents = true;
    private boolean includeComponentLog = true;
    private boolean includeStdout = true;
    private boolean includeStderr = true;
    private Pattern searchTermPattern;

    public void setWorkflow(String workflow) {
        this.workflow = workflow;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setIncludeMetaInfo(boolean includeMeta) {
        this.includeComponentLog = includeMeta;
    }

    public void setIncludeLifecylceEvents(boolean includeLifecycle) {
        this.includeLifecycleEvents = includeLifecycle;
    }

    public void setIncludeStdout(boolean includeStdout) {
        this.includeStdout = includeStdout;
    }

    public void setIncludeStderr(boolean includeStderr) {
        this.includeStderr = includeStderr;
    }

    public void setSearchTerm(String searchTerm) {
        if (searchTerm == null || searchTerm.length() == 0) {
            this.searchTermPattern = null;
            return;
        }
        searchTerm = searchTerm.replaceAll("(\\(|\\)|\\[|\\]|\\.|\\*|\\\\|\\^|\\$|\\||\\?|\\+|\\{|\\})", "\\\\$1");
        this.searchTermPattern = Pattern.compile(searchTerm, 2);
    }

    public boolean accept(ConsoleRow row) {
        boolean accept;
        switch (row.getType()) {
            case TOOL_OUT: {
                accept = this.includeStdout;
                break;
            }
            case TOOL_ERROR: {
                accept = this.includeStderr;
                break;
            }
            case COMPONENT_INFO: 
            case COMPONENT_WARN: 
            case COMPONENT_ERROR: 
            case WORKFLOW_ERROR: {
                accept = this.includeComponentLog;
                break;
            }
            case LIFE_CYCLE_EVENT: {
                if (row.getPayload().startsWith(ConsoleRow.WorkflowLifecyleEventType.NEW_STATE.name())) {
                    return false;
                }
                if (row.getPayload().startsWith(ConsoleRow.WorkflowLifecyleEventType.COMPONENT_TERMINATED.name())) {
                    accept = this.includeLifecycleEvents;
                    break;
                }
                accept = false;
                break;
            }
            default: {
                accept = false;
            }
        }
        if (accept && this.workflow != null && !this.workflow.equals(row.getWorkflowName())) {
            accept = false;
        }
        if (row.getType() == ConsoleRow.Type.WORKFLOW_ERROR) {
            if (accept && this.component != null && !this.component.isEmpty()) {
                accept = false;
            }
        } else if (accept && this.component != null && !this.component.equals(row.getComponentName())) {
            accept = false;
        }
        if (accept && this.searchTermPattern != null && !this.searchTermPattern.matcher(row.getPayload()).find()) {
            accept = false;
        }
        return accept;
    }

    public ConsoleRowFilter clone() {
        ConsoleRowFilter clone = new ConsoleRowFilter();
        clone.component = this.component;
        clone.workflow = this.workflow;
        clone.includeComponentLog = this.includeComponentLog;
        clone.includeLifecycleEvents = this.includeLifecycleEvents;
        clone.includeStderr = this.includeStderr;
        clone.includeStdout = this.includeStdout;
        clone.searchTermPattern = this.searchTermPattern;
        return clone;
    }
}

