/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import jodd.mail.MailException;
import jodd.mail.ReceiveMailSession;
import jodd.mail.ReceiveMailSessionProvider;
import jodd.mail.SimpleAuthenticator;

public class ImapServer
implements ReceiveMailSessionProvider {
    protected static final String MAIL_IMAP_PORT = "mail.imap.port";
    protected static final String MAIL_IMAP_HOST = "mail.imap.host";
    protected static final String MAIL_IMAP_PARTIALFETCH = "mail.imap.partialfetch";
    protected static final String PROTOCOL_IMAP = "imap";
    protected static final int DEFAULT_IMAP_PORT = 143;
    protected final String host;
    protected final int port;
    protected final Authenticator authenticator;
    protected final Properties sessionProperties;

    public ImapServer(String host) {
        this(host, 143, null);
    }

    public ImapServer(String host, int port) {
        this(host, port, null);
    }

    public ImapServer(String host, Authenticator authenticator) {
        this(host, 143, authenticator);
    }

    public ImapServer(String host, int port, String username, String password) {
        this(host, port, new SimpleAuthenticator(username, password));
    }

    public ImapServer(String host, int port, Authenticator authenticator) {
        this.host = host;
        this.port = port;
        this.authenticator = authenticator;
        this.sessionProperties = this.createSessionProperties();
    }

    protected Properties createSessionProperties() {
        Properties props = new Properties();
        props.setProperty(MAIL_IMAP_HOST, this.host);
        props.setProperty(MAIL_IMAP_PORT, String.valueOf(this.port));
        props.setProperty(MAIL_IMAP_PARTIALFETCH, "false");
        return props;
    }

    @Override
    public ImapServer setProperty(String name, String value) {
        this.sessionProperties.setProperty(name, value);
        return this;
    }

    @Override
    public ReceiveMailSession createSession() {
        Store store;
        Session session = Session.getInstance((Properties)this.sessionProperties, (Authenticator)this.authenticator);
        try {
            store = this.getStore(session);
        }
        catch (NoSuchProviderException nspex) {
            throw new MailException("Failed to create IMAP session", nspex);
        }
        return new ReceiveMailSession(session, store);
    }

    protected Store getStore(Session session) throws NoSuchProviderException {
        return session.getStore(PROTOCOL_IMAP);
    }

    public String getHost() {
        return this.host;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public int getPort() {
        return this.port;
    }
}

