/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.datamanagement.backend.DataBackend;
import de.rcenvironment.core.datamanagement.backend.MetaDataBackendService;
import de.rcenvironment.core.datamanagement.internal.DataManagementConfiguration;
import de.rcenvironment.core.utils.common.ServiceUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class BackendSupport {
    private static final String CLOSE_BRACKET = ")";
    private static final String OPEN_BRACKET = "(";
    private static final String EQUALS_SIGN = "=";
    private static final Log LOGGER = LogFactory.getLog(BackendSupport.class);
    private static DataManagementConfiguration dmConfig;
    private static BundleContext bundleContext;
    private static ConfigurationService configurationService;
    private static DataBackend dataBackendService;

    protected void activate(BundleContext context) {
        bundleContext = context;
        dmConfig = new DataManagementConfiguration();
    }

    protected void bindConfigurationService(ConfigurationService newConfigurationService) {
        configurationService = newConfigurationService;
    }

    protected void unbindConfigurationService(ConfigurationService oldConfigurationService) {
        configurationService = (ConfigurationService)ServiceUtils.createFailingServiceProxy(ConfigurationService.class);
    }

    protected void bindDataBackendService(DataBackend newDataBackendService) {
        dataBackendService = newDataBackendService;
    }

    public static MetaDataBackendService getMetaDataBackend() {
        String metadataProvider = dmConfig.getMetaDataBackend();
        MetaDataBackendService metaDataBackend = null;
        String filterString = "(de.rcenvironment.core.datamanagement.backend.metadata.provider=" + metadataProvider + CLOSE_BRACKET;
        ServiceReference[] serviceReferences = null;
        try {
            serviceReferences = bundleContext.getServiceReferences(MetaDataBackendService.class.getName(), filterString);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            LOGGER.error((Object)"Failed to get a metadata backend. Invalid protocol filter syntax.");
        }
        if (serviceReferences != null && serviceReferences.length > 0) {
            metaDataBackend = (MetaDataBackendService)bundleContext.getService(serviceReferences[0]);
            if (metaDataBackend == null) {
                throw new IllegalStateException("The configured metadata backend is not available: " + metadataProvider);
            }
        } else {
            throw new IllegalStateException("The configured metadata backend is not available: " + metadataProvider);
        }
        return metaDataBackend;
    }

    public static DataBackend getDataBackend(URI dataURI) {
        String scheme = dataURI.getScheme();
        DataBackend dataBackend = null;
        String filterString = "(de.rcenvironment.core.datamanagement.backend.data.scheme=" + scheme + CLOSE_BRACKET;
        ServiceReference[] serviceReferences = null;
        try {
            serviceReferences = bundleContext.getServiceReferences(DataBackend.class.getName(), filterString);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            LOGGER.error((Object)"Failed to get a cdata backend. Invalid protocol filter syntax.");
        }
        if (serviceReferences != null && serviceReferences.length > 0) {
            dataBackend = (DataBackend)bundleContext.getService(serviceReferences[0]);
            if (dataBackend == null) {
                throw new IllegalStateException("A data backend for this scheme is not available: " + scheme);
            }
        } else {
            throw new IllegalStateException("A data backend for this scheme is not available: " + scheme);
        }
        return dataBackend;
    }

    public static DataBackend getDataBackend() {
        return dataBackendService;
    }
}

