/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authorization.internal;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;

public class AuthorizationAccessGroupImpl
implements AuthorizationAccessGroup {
    private String name;
    private final String idPart;
    private final String fullId;
    private final String displayName;
    private final int sortOrderingCategory;

    public AuthorizationAccessGroupImpl(String name, String idPart, String fullId, String displayName) {
        this.name = name;
        this.idPart = idPart;
        this.fullId = fullId;
        this.displayName = displayName;
        this.sortOrderingCategory = 0;
    }

    public AuthorizationAccessGroupImpl(String name, String idPart, String fullId, String displayName, int sortOrderingCategory) {
        this.name = name;
        this.idPart = idPart;
        this.fullId = fullId;
        this.displayName = displayName;
        this.sortOrderingCategory = sortOrderingCategory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullId() {
        return this.fullId;
    }

    @Override
    public String getIdPart() {
        return this.idPart;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.fullId;
    }

    @Override
    public int compareTo(AuthorizationAccessGroup o) {
        AuthorizationAccessGroupImpl other = (AuthorizationAccessGroupImpl)o;
        int categoryBias = Integer.compare(this.sortOrderingCategory, other.sortOrderingCategory);
        if (categoryBias != 0) {
            return categoryBias;
        }
        return this.displayName.compareTo(o.getDisplayName());
    }

    @Override
    public int compareToIgnoreCase(AuthorizationAccessGroup o) {
        AuthorizationAccessGroupImpl other = (AuthorizationAccessGroupImpl)o;
        int categoryBias = Integer.compare(this.sortOrderingCategory, other.sortOrderingCategory);
        if (categoryBias != 0) {
            return categoryBias;
        }
        return this.displayName.compareToIgnoreCase(o.getDisplayName());
    }

    public int hashCode() {
        return this.fullId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationAccessGroupImpl other = (AuthorizationAccessGroupImpl)obj;
        return this.fullId.equals(other.fullId);
    }
}

