/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap;

import de.rcenvironment.core.configuration.bootstrap.CommandStack;
import de.rcenvironment.core.configuration.bootstrap.ParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class EclipseLaunchParameters {
    private static final String ECLIPSE_COMMAND_SYSTEM_PROPERTY = "eclipse.commands";
    private static final String MESSAGE_CONFLICTING_PARAMETERS = "Invalid combination of command-line parameters: cannot specify the same parameter several times";
    private static final String[] PARAMETER_TOKENS_TO_IGNORE = new String[]{"-launcher", "-name", "-application", "-data", "-configuration", "-dev", "-os", "-ws", "-arch", "-nl", "-startup", "-vm", "-exitdata", "-showsplash", "--launcher.XXMaxPermSize", "--launcher.library", "--launcher.overrideVmargs"};
    private static final String[] FLAG_TOKENS_TO_IGNORE = new String[]{"-consoleLog", "-console", "-clean", "-nosplash", "-noSplash"};
    private static final EclipseLaunchParameters INSTANCE = new EclipseLaunchParameters();
    private List<String> filteredTokens;

    protected EclipseLaunchParameters() {
        this.readParameters();
    }

    public static EclipseLaunchParameters getInstance() {
        return INSTANCE;
    }

    public void readParameters() {
        String commandString = System.getProperty(ECLIPSE_COMMAND_SYSTEM_PROPERTY);
        if (commandString == null) {
            commandString = "";
        }
        String[] tokenArray = commandString.trim().split("\\n");
        ArrayList<String> filteredTokensTemp = new ArrayList<String>();
        List<String> parametersToIgnore = Arrays.asList(PARAMETER_TOKENS_TO_IGNORE);
        List<String> flagsToIgnore = Arrays.asList(FLAG_TOKENS_TO_IGNORE);
        CommandStack tokenStack = new CommandStack(tokenArray);
        while (tokenStack.hasNext()) {
            String next = tokenStack.getNext();
            if (parametersToIgnore.contains(next)) {
                if (!tokenStack.hasNextIsValue()) continue;
                tokenStack.getNext();
                continue;
            }
            if (flagsToIgnore.contains(next)) continue;
            filteredTokensTemp.add(next);
        }
        this.filteredTokens = Collections.unmodifiableList(filteredTokensTemp);
    }

    public String getNamedParameter(String shortKey, String longKey) throws ParameterException {
        boolean lastWasKey = false;
        boolean keyFound = false;
        String resultToken = null;
        for (String token : this.filteredTokens) {
            if (lastWasKey && !token.startsWith("-")) {
                resultToken = token;
            }
            if (shortKey.equals(token) || longKey.equals(token)) {
                if (keyFound) {
                    throw new ParameterException(MESSAGE_CONFLICTING_PARAMETERS);
                }
                lastWasKey = true;
                keyFound = true;
                continue;
            }
            lastWasKey = false;
        }
        return resultToken;
    }

    public boolean containsToken(String key) {
        return this.filteredTokens.contains(key);
    }

    public boolean containsToken(String shortKey, String longKey) {
        return this.filteredTokens.contains(shortKey) || this.filteredTokens.contains(longKey);
    }

    public String[] getFilteredTokensAsArray() {
        return this.filteredTokens.toArray(new String[0]);
    }
}

