/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.incubator;

import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.LogFactory;

public final class DebugSettings {
    protected static final String VERBOSE_LOGGING_PATTERN_SYSTEM_PROPERTY = "rce.verboseLogging";
    protected static final String META_VERBOSE_LOGGING_ID = "meta";
    private static final String DEFAULT_VERBOSE_LOGGING_PATTERN = "";
    private static final DebugSettings INSTANCE = new DebugSettings();
    private final IdFilter sharedVerboseLoggingIdFilter;
    private final Map<String, Boolean> cache = new ConcurrentHashMap<String, Boolean>();
    private final boolean metaVerboseLoggingEnabled;

    protected DebugSettings() {
        String pattern = System.getProperty(VERBOSE_LOGGING_PATTERN_SYSTEM_PROPERTY);
        if (pattern == null) {
            pattern = DEFAULT_VERBOSE_LOGGING_PATTERN;
        }
        this.sharedVerboseLoggingIdFilter = new IdFilter(pattern);
        this.metaVerboseLoggingEnabled = this.getVerboseLoggingEnabledInternal(META_VERBOSE_LOGGING_ID);
    }

    public static boolean getVerboseLoggingEnabled(Class<?> callerClass) {
        return INSTANCE.getVerboseLoggingEnabledInternal(callerClass.getName());
    }

    public static boolean getVerboseLoggingEnabled(String id) {
        return INSTANCE.getVerboseLoggingEnabledInternal(id);
    }

    protected boolean getVerboseLoggingEnabledInternal(Class<?> callerClass) {
        return this.getVerboseLoggingEnabledInternal(callerClass.getName());
    }

    protected boolean getVerboseLoggingEnabledInternal(String id) {
        Boolean cached = this.cache.get(id);
        if (cached != null) {
            return cached;
        }
        boolean enableLogging = this.sharedVerboseLoggingIdFilter.matches(id);
        this.cache.put(id, enableLogging);
        if (enableLogging || this.metaVerboseLoggingEnabled) {
            LogFactory.getLog(DebugSettings.class).debug((Object)StringUtils.format((String)"Set 'verbose logging' flag to %s for id %s", (Object[])new Object[]{enableLogging, id}));
        }
        return enableLogging;
    }

    protected static final class IdFilter {
        private final Pattern regexp;

        public IdFilter(String patternString) {
            if (patternString.isEmpty()) {
                this.regexp = null;
                return;
            }
            String regexpString = "^(" + patternString.replace(".", "\\.").replace("*", ".*").replace(",", "|") + ")$";
            Pattern tempRegexp = null;
            try {
                tempRegexp = Pattern.compile(regexpString);
                LogFactory.getLog(this.getClass()).info((Object)("Using verbose logging configuration value '" + patternString + "', compiled to filter regexp '" + regexpString + "'"));
            }
            catch (PatternSyntaxException e) {
                System.err.println("Error in verbose logging configuration value '" + patternString + "', compiled to filter regexp '" + regexpString + "': " + e.toString());
            }
            this.regexp = tempRegexp;
        }

        public boolean matches(String id) {
            if (this.regexp == null) {
                return false;
            }
            return this.regexp.matcher(id).matches();
        }
    }
}

