/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.authorization;

import de.rcenvironment.core.authorization.api.AuthorizationIdRules;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.common.ClipboardHelper;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Optional;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportGroupKeyDialog
extends Dialog {
    private static final int DEFAULT_TEXTFIELD_WIDTH = 300;
    private static final int VALIDATION_LABEL_HEIGHT_HINT = 55;
    private String keyToImport = "";
    private Text importGroupKeyTextfield;

    protected ImportGroupKeyDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Import Group Key");
    }

    public String getKeyToImport() {
        return this.keyToImport;
    }

    protected void okPressed() {
        this.keyToImport = this.importGroupKeyTextfield.getText();
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout containerLayout = new GridLayout(2, false);
        container.setLayout((Layout)containerLayout);
        Label importGroupKeyLabel = new Label(container, 0);
        importGroupKeyLabel.setText("Group Key to import: ");
        this.importGroupKeyTextfield = new Text(container, 2048);
        GridData importGroupKeyGridData = new GridData(4, 4, true, false);
        importGroupKeyGridData.widthHint = 300;
        this.importGroupKeyTextfield.setLayoutData((Object)importGroupKeyGridData);
        Composite validationMessage = new Composite(container, 0);
        GridData validationMessageGridData = new GridData(4, 4, true, false);
        validationMessageGridData.horizontalSpan = 2;
        validationMessage.setLayoutData((Object)validationMessageGridData);
        validationMessage.setLayout((Layout)new GridLayout(2, false));
        validationMessage.setVisible(false);
        Label validationIconLabel = new Label(validationMessage, 0);
        validationIconLabel.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ERROR_16));
        validationIconLabel.setLayoutData((Object)new GridData(1, 1, false, true));
        Label validationTextLabel = new Label(validationMessage, 64);
        GridData validationLabelGridData = new GridData(4, 0, true, false);
        validationLabelGridData.widthHint = 300;
        validationLabelGridData.heightHint = 55;
        validationTextLabel.setLayoutData((Object)validationLabelGridData);
        this.importGroupKeyTextfield.addModifyListener(event -> {
            String importString = this.importGroupKeyTextfield.getText().trim();
            Optional validationError = AuthorizationIdRules.validateAuthorizationGroupImportString((String)importString);
            if (!importString.isEmpty() && validationError.isPresent()) {
                validationTextLabel.setText(StringUtils.format((String)"%s.", (Object[])new Object[]{((String)validationError.get()).replaceAll("&", "&&")}));
                validationMessage.setVisible(true);
            } else {
                validationTextLabel.setText("");
                validationMessage.setVisible(false);
            }
            this.getButton(0).setEnabled(!importString.isEmpty() && !validationError.isPresent());
        });
        Button pasteFromClipboardButton = new Button(container, 8);
        pasteFromClipboardButton.setText("Paste from Clipboard");
        GridData pasteFromClipboardButtonGridData = new GridData(4, 4, true, false);
        pasteFromClipboardButtonGridData.horizontalSpan = 2;
        pasteFromClipboardButtonGridData.horizontalAlignment = 131072;
        pasteFromClipboardButton.setLayoutData((Object)pasteFromClipboardButtonGridData);
        pasteFromClipboardButton.addSelectionListener((SelectionListener)new PasteFromClipboardSelectionListener());
        return container;
    }

    private final class PasteFromClipboardSelectionListener
    implements SelectionListener {
        private PasteFromClipboardSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            String keyFromClipboard = ClipboardHelper.getContentAsStringOrNull();
            if (keyFromClipboard != null && !keyFromClipboard.isEmpty()) {
                ImportGroupKeyDialog.this.importGroupKeyTextfield.setText(keyFromClipboard.trim());
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }
}

