/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common.configuration;

import de.rcenvironment.core.gui.utils.common.configuration.BooleanPropertyDescriptor;
import de.rcenvironment.core.gui.utils.common.configuration.EnumPropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public final class PropertyDescriptorFactory {
    private static final Map<Class<?>, Class<? extends IPropertyDescriptor>> MAPPING = new HashMap();

    static {
        MAPPING.put(Boolean.class, BooleanPropertyDescriptor.class);
        MAPPING.put(String.class, TextPropertyDescriptor.class);
        MAPPING.put(Number.class, TextPropertyDescriptor.class);
        MAPPING.put(Enum.class, EnumPropertyDescriptor.class);
        MAPPING.put(Color.class, ColorPropertyDescriptor.class);
        MAPPING.put(RGB.class, ColorPropertyDescriptor.class);
    }

    private PropertyDescriptorFactory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IPropertyDescriptor createPropertyDescriptor(Class<?> propertyType, String name, String displayName) {
        block13: {
            Map.Entry<Class<?>, Class<IPropertyDescriptor>> entry;
            Class<?> baseClass;
            Iterator<Map.Entry<Class<?>, Class<IPropertyDescriptor>>> iterator = MAPPING.entrySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                if (String.class.equals(propertyType)) return new TextPropertyDescriptor((Object)name, displayName);
                if (Number.class.isAssignableFrom(propertyType)) {
                    return new TextPropertyDescriptor((Object)name, displayName);
                }
                break block13;
            } while (!(baseClass = (entry = iterator.next()).getKey()).isAssignableFrom(propertyType));
            Class<? extends IPropertyDescriptor> descriptorClass = entry.getValue();
            try {
                try {
                    Constructor<? extends IPropertyDescriptor> constructor = descriptorClass.getConstructor(Class.class, Object.class, String.class);
                    return constructor.newInstance(propertyType, name, displayName);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        Constructor<? extends IPropertyDescriptor> constructor = descriptorClass.getConstructor(Object.class, String.class);
                        return constructor.newInstance(name, displayName);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (Boolean.class.equals(propertyType)) return new BooleanPropertyDescriptor(name, displayName);
        if (Boolean.TYPE.equals(propertyType)) {
            return new BooleanPropertyDescriptor(name, displayName);
        }
        if (!propertyType.isPrimitive()) return null;
        return new TextPropertyDescriptor((Object)name, displayName);
    }
}

