/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.messaging.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.messaging.NetworkRequestHandler;
import de.rcenvironment.core.communication.messaging.internal.InternalMessagingException;
import de.rcenvironment.core.communication.messaging.internal.NetworkRequestUtils;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.protocol.NetworkResponseFactory;
import de.rcenvironment.core.communication.rpc.ServiceCallRequest;
import de.rcenvironment.core.communication.rpc.ServiceCallResult;
import de.rcenvironment.core.communication.rpc.internal.ReliableRPCStreamService;
import de.rcenvironment.core.communication.rpc.spi.RemoteServiceCallHandlerService;
import de.rcenvironment.core.toolkitbridge.api.StaticToolkitHolder;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.statistics.api.CounterCategory;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsFilterLevel;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsTrackerService;
import de.rcenvironment.toolkit.modules.statistics.api.ValueEventCategory;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RPCNetworkRequestHandler
implements NetworkRequestHandler {
    private static final long SLOW_SERVICE_CALL_LOGGING_THRESHOLD_MSEC = 10000L;
    private final RemoteServiceCallHandlerService serviceCallHandler;
    private final CounterCategory methodCallCounter;
    private final ValueEventCategory slowMethodCallCounter;
    private final Log log = LogFactory.getLog(this.getClass());
    private ReliableRPCStreamService reliableRPCStreamService;

    public RPCNetworkRequestHandler(RemoteServiceCallHandlerService serviceCallHandler, ReliableRPCStreamService reliableRPCStreamService) {
        this.serviceCallHandler = Objects.requireNonNull(serviceCallHandler);
        this.reliableRPCStreamService = Objects.requireNonNull(reliableRPCStreamService);
        StatisticsTrackerService statisticsService = (StatisticsTrackerService)StaticToolkitHolder.getServiceWithUnitTestFallback(StatisticsTrackerService.class);
        this.methodCallCounter = statisticsService.getCounterCategory("Remote service calls (received): service methods", StatisticsFilterLevel.RELEASE);
        this.slowMethodCallCounter = statisticsService.getValueEventCategory("Remote service calls (received): slow method calls (more than 10000 msec)", StatisticsFilterLevel.RELEASE);
    }

    @Override
    public NetworkResponse handleRequest(NetworkRequest request, InstanceNodeSessionId lastHopNodeId) throws InternalMessagingException {
        ServiceCallRequest serviceCallRequest = (ServiceCallRequest)NetworkRequestUtils.deserializeWithExceptionHandling(request);
        try {
            if (this.methodCallCounter.isEnabled()) {
                this.methodCallCounter.count(StringUtils.format((String)"%s#%s(...)", (Object[])new Object[]{serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName()}));
            }
            ServiceCallResult scResult = this.handleInternal(serviceCallRequest);
            try {
                return NetworkResponseFactory.generateSuccessResponse(request, scResult);
            }
            catch (SerializationException e) {
                throw new InternalMessagingException("Failed to serialize the result of a call to " + this.formatGenericCallInfo(serviceCallRequest), e);
            }
        }
        catch (RuntimeException e) {
            throw new InternalMessagingException("Caught an unhandled " + e.getClass().getSimpleName() + " while processing a call to " + this.formatGenericCallInfo(serviceCallRequest), e);
        }
    }

    private String formatGenericCallInfo(ServiceCallRequest serviceCallRequest) {
        return String.valueOf(serviceCallRequest.getServiceName()) + "#" + serviceCallRequest.getMethodName() + "; caller=" + serviceCallRequest.getCallerNodeId();
    }

    private ServiceCallResult handleInternal(ServiceCallRequest serviceCallRequest) throws InternalMessagingException {
        long duration;
        long startTime = System.currentTimeMillis();
        String reliableRPCStreamId = serviceCallRequest.getReliableRPCStreamId();
        if (reliableRPCStreamId != null) {
            return this.reliableRPCStreamService.handleIncomingRequest(serviceCallRequest);
        }
        ServiceCallResult scResult = this.serviceCallHandler.dispatchToLocalService(serviceCallRequest);
        if (scResult == null) {
            this.log.warn((Object)("ServiceCallResult result was null immediately after dispatching an RPC request to " + this.formatGenericCallInfo(serviceCallRequest) + " (no exception thrown; null result forwarded for now)"), (Throwable)new RuntimeException());
        }
        if ((duration = System.currentTimeMillis() - startTime) >= 10000L) {
            this.log.debug((Object)StringUtils.format((String)"An incoming service call from %s to %s#%s() took %,d msec to complete", (Object[])new Object[]{serviceCallRequest.getCallerNodeId(), serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName(), duration}));
            this.slowMethodCallCounter.registerEvent(StringUtils.format((String)"%s#%s", (Object[])new Object[]{serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName()}), duration);
        }
        return scResult;
    }
}

