/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene94;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene94.OffHeapVectorValues;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.RandomAccessVectorValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.packed.DirectMonotonicWriter;

public final class Lucene94HnswVectorsWriter
extends KnnVectorsWriter {
    private final SegmentWriteState segmentWriteState;
    private final IndexOutput meta;
    private final IndexOutput vectorData;
    private final IndexOutput vectorIndex;
    private final int M;
    private final int beamWidth;
    private final List<FieldWriter<?>> fields = new ArrayList();
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene94HnswVectorsWriter(SegmentWriteState state, int M, int beamWidth) throws IOException {
        this.M = M;
        this.beamWidth = beamWidth;
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vem");
        String vectorDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vec");
        String indexDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vex");
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.vectorData = state.directory.createOutput(vectorDataFileName, state.context);
            this.vectorIndex = state.directory.createOutput(indexDataFileName, state.context);
            CodecUtil.writeIndexHeader(this.meta, "lucene94HnswVectorsFormatMeta", 1, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorData, "lucene94HnswVectorsFormatData", 1, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorIndex, "lucene94HnswVectorsFormatIndex", 1, state.segmentInfo.getId(), state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        FieldWriter<?> newField = FieldWriter.create(fieldInfo, this.M, this.beamWidth, this.segmentWriteState.infoStream);
        this.fields.add(newField);
        return newField;
    }

    @Override
    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        for (FieldWriter<?> field : this.fields) {
            if (sortMap == null) {
                this.writeField(field, maxDoc);
                continue;
            }
            this.writeSortingField(field, maxDoc, sortMap);
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter(this.meta);
        }
        if (this.vectorData != null) {
            CodecUtil.writeFooter(this.vectorData);
            CodecUtil.writeFooter(this.vectorIndex);
        }
    }

    @Override
    public long ramBytesUsed() {
        long total = 0L;
        for (FieldWriter<?> field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    private void writeField(FieldWriter<?> fieldData, int maxDoc) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        switch (fieldData.fieldInfo.getVectorEncoding()) {
            case BYTE: {
                this.writeByteVectors(fieldData);
                break;
            }
            default: {
                this.writeFloat32Vectors(fieldData);
            }
        }
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        long vectorIndexOffset = this.vectorIndex.getFilePointer();
        OnHeapHnswGraph graph = fieldData.getGraph();
        this.writeGraph(graph);
        long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, vectorDataLength, vectorIndexOffset, vectorIndexLength, fieldData.docsWithField, graph);
    }

    private void writeFloat32Vectors(FieldWriter<?> fieldData) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(fieldData.dim * 4).order(ByteOrder.LITTLE_ENDIAN);
        BytesRef binaryValue = new BytesRef(buffer.array());
        for (Object v : fieldData.vectors) {
            buffer.asFloatBuffer().put((float[])v);
            this.vectorData.writeBytes(binaryValue.bytes, binaryValue.offset, binaryValue.length);
        }
    }

    private void writeByteVectors(FieldWriter<?> fieldData) throws IOException {
        for (Object v : fieldData.vectors) {
            BytesRef vector = (BytesRef)v;
            this.vectorData.writeBytes(vector.bytes, vector.offset, vector.length);
        }
    }

    private void writeSortingField(FieldWriter<?> fieldData, int maxDoc, Sorter.DocMap sortMap) throws IOException {
        long vectorDataOffset;
        int[] docIdOffsets = new int[sortMap.size()];
        int offset = 1;
        DocIdSetIterator iterator = fieldData.docsWithField.iterator();
        int docID = iterator.nextDoc();
        while (docID != Integer.MAX_VALUE) {
            int newDocID = sortMap.oldToNew(docID);
            docIdOffsets[newDocID] = offset++;
            docID = iterator.nextDoc();
        }
        DocsWithFieldSet newDocsWithField = new DocsWithFieldSet();
        int[] ordMap = new int[offset - 1];
        int[] oldOrdMap = new int[offset - 1];
        int ord = 0;
        int doc = 0;
        for (int docIdOffset : docIdOffsets) {
            if (docIdOffset != 0) {
                ordMap[ord] = docIdOffset - 1;
                oldOrdMap[docIdOffset - 1] = ord++;
                newDocsWithField.add(doc);
            }
            ++doc;
        }
        switch (fieldData.fieldInfo.getVectorEncoding()) {
            case BYTE: {
                vectorDataOffset = this.writeSortedByteVectors(fieldData, ordMap);
                break;
            }
            default: {
                vectorDataOffset = this.writeSortedFloat32Vectors(fieldData, ordMap);
            }
        }
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        long vectorIndexOffset = this.vectorIndex.getFilePointer();
        OnHeapHnswGraph graph = fieldData.getGraph();
        HnswGraph mockGraph = this.reconstructAndWriteGraph(graph, ordMap, oldOrdMap);
        long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, vectorDataLength, vectorIndexOffset, vectorIndexLength, newDocsWithField, mockGraph);
    }

    private long writeSortedFloat32Vectors(FieldWriter<?> fieldData, int[] ordMap) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        ByteBuffer buffer = ByteBuffer.allocate(fieldData.dim * 4).order(ByteOrder.LITTLE_ENDIAN);
        BytesRef binaryValue = new BytesRef(buffer.array());
        for (int ordinal : ordMap) {
            float[] vector = (float[])fieldData.vectors.get(ordinal);
            buffer.asFloatBuffer().put(vector);
            this.vectorData.writeBytes(binaryValue.bytes, binaryValue.offset, binaryValue.length);
        }
        return vectorDataOffset;
    }

    private long writeSortedByteVectors(FieldWriter<?> fieldData, int[] ordMap) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        for (int ordinal : ordMap) {
            BytesRef vector = (BytesRef)fieldData.vectors.get(ordinal);
            this.vectorData.writeBytes(vector.bytes, vector.offset, vector.length);
        }
        return vectorDataOffset;
    }

    private HnswGraph reconstructAndWriteGraph(final OnHeapHnswGraph graph, int[] newToOldMap, int[] oldToNewMap) throws IOException {
        if (graph == null) {
            return null;
        }
        final ArrayList<int[]> nodesByLevel = new ArrayList<int[]>(graph.numLevels());
        nodesByLevel.add(null);
        int maxOrd = graph.size();
        int maxConnOnLevel = this.M * 2;
        HnswGraph.NodesIterator nodesOnLevel0 = graph.getNodesOnLevel(0);
        while (nodesOnLevel0.hasNext()) {
            int node = nodesOnLevel0.nextInt();
            NeighborArray neighbors = graph.getNeighbors(0, newToOldMap[node]);
            this.reconstructAndWriteNeigbours(neighbors, oldToNewMap, maxConnOnLevel, maxOrd);
        }
        maxConnOnLevel = this.M;
        for (int level = 1; level < graph.numLevels(); ++level) {
            HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
            int[] newNodes = new int[nodesOnLevel.size()];
            int n = 0;
            while (nodesOnLevel.hasNext()) {
                newNodes[n++] = oldToNewMap[nodesOnLevel.nextInt()];
            }
            Arrays.sort(newNodes);
            nodesByLevel.add(newNodes);
            for (int node : newNodes) {
                NeighborArray neighbors = graph.getNeighbors(level, newToOldMap[node]);
                this.reconstructAndWriteNeigbours(neighbors, oldToNewMap, maxConnOnLevel, maxOrd);
            }
        }
        return new HnswGraph(){

            @Override
            public int nextNeighbor() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            @Override
            public void seek(int level, int target) {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            @Override
            public int size() {
                return graph.size();
            }

            @Override
            public int numLevels() {
                return graph.numLevels();
            }

            @Override
            public int entryNode() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            @Override
            public HnswGraph.NodesIterator getNodesOnLevel(int level) {
                if (level == 0) {
                    return graph.getNodesOnLevel(0);
                }
                return new HnswGraph.NodesIterator((int[])nodesByLevel.get(level), ((int[])nodesByLevel.get(level)).length);
            }
        };
    }

    private void reconstructAndWriteNeigbours(NeighborArray neighbors, int[] oldToNewMap, int maxConnOnLevel, int maxOrd) throws IOException {
        int i;
        int size = neighbors.size();
        this.vectorIndex.writeInt(size);
        int[] nnodes = neighbors.node();
        for (i = 0; i < size; ++i) {
            nnodes[i] = oldToNewMap[nnodes[i]];
        }
        Arrays.sort(nnodes, 0, size);
        for (i = 0; i < size; ++i) {
            int nnode = nnodes[i];
            assert (nnode < maxOrd) : "node too large: " + nnode + ">=" + maxOrd;
            this.vectorIndex.writeInt(nnode);
        }
        for (i = size; i < maxConnOnLevel; ++i) {
            this.vectorIndex.writeInt(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        KnnVectorsWriter.MergedVectorValues vectors = KnnVectorsWriter.MergedVectorValues.mergeVectorValues(fieldInfo, mergeState);
        IndexOutput tempVectorData = this.segmentWriteState.directory.createTempOutput(this.vectorData.getName(), "temp", this.segmentWriteState.context);
        IndexInput vectorDataInput = null;
        boolean success = false;
        try {
            DocsWithFieldSet docsWithField = Lucene94HnswVectorsWriter.writeVectorData(tempVectorData, vectors, fieldInfo.getVectorEncoding().byteSize);
            CodecUtil.writeFooter(tempVectorData);
            IOUtils.close(tempVectorData);
            vectorDataInput = this.segmentWriteState.directory.openInput(tempVectorData.getName(), this.segmentWriteState.context);
            this.vectorData.copyBytes(vectorDataInput, vectorDataInput.length() - (long)CodecUtil.footerLength());
            CodecUtil.retrieveChecksum(vectorDataInput);
            long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
            long vectorIndexOffset = this.vectorIndex.getFilePointer();
            int byteSize = ((VectorValues)vectors).dimension() * fieldInfo.getVectorEncoding().byteSize;
            OffHeapVectorValues.DenseOffHeapVectorValues offHeapVectors = new OffHeapVectorValues.DenseOffHeapVectorValues(((VectorValues)vectors).dimension(), docsWithField.cardinality(), vectorDataInput, byteSize);
            OnHeapHnswGraph graph = null;
            if (offHeapVectors.size() != 0) {
                HnswGraphBuilder<?> hnswGraphBuilder = HnswGraphBuilder.create(offHeapVectors, fieldInfo.getVectorEncoding(), fieldInfo.getVectorSimilarityFunction(), this.M, this.beamWidth, HnswGraphBuilder.randSeed);
                hnswGraphBuilder.setInfoStream(this.segmentWriteState.infoStream);
                graph = hnswGraphBuilder.build(offHeapVectors.copy());
                this.writeGraph(graph);
            }
            long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
            this.writeMeta(fieldInfo, this.segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, vectorIndexOffset, vectorIndexLength, docsWithField, graph);
            success = true;
        }
        catch (Throwable throwable) {
            IOUtils.close(vectorDataInput);
            if (success) {
                this.segmentWriteState.directory.deleteFile(tempVectorData.getName());
            } else {
                IOUtils.closeWhileHandlingException(tempVectorData);
                IOUtils.deleteFilesIgnoringExceptions(this.segmentWriteState.directory, tempVectorData.getName());
            }
            throw throwable;
        }
        IOUtils.close(vectorDataInput);
        if (success) {
            this.segmentWriteState.directory.deleteFile(tempVectorData.getName());
        } else {
            IOUtils.closeWhileHandlingException(tempVectorData);
            IOUtils.deleteFilesIgnoringExceptions(this.segmentWriteState.directory, tempVectorData.getName());
        }
    }

    private void writeGraph(OnHeapHnswGraph graph) throws IOException {
        if (graph == null) {
            return;
        }
        int countOnLevel0 = graph.size();
        for (int level = 0; level < graph.numLevels(); ++level) {
            int maxConnOnLevel = level == 0 ? this.M * 2 : this.M;
            HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
            while (nodesOnLevel.hasNext()) {
                int i;
                int node = nodesOnLevel.nextInt();
                NeighborArray neighbors = graph.getNeighbors(level, node);
                int size = neighbors.size();
                this.vectorIndex.writeInt(size);
                int[] nnodes = neighbors.node();
                Arrays.sort(nnodes, 0, size);
                for (i = 0; i < size; ++i) {
                    int nnode = nnodes[i];
                    assert (nnode < countOnLevel0) : "node too large: " + nnode + ">=" + countOnLevel0;
                    this.vectorIndex.writeInt(nnode);
                }
                for (i = size; i < maxConnOnLevel; ++i) {
                    this.vectorIndex.writeInt(0);
                }
            }
        }
    }

    private void writeMeta(FieldInfo field, int maxDoc, long vectorDataOffset, long vectorDataLength, long vectorIndexOffset, long vectorIndexLength, DocsWithFieldSet docsWithField, HnswGraph graph) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVLong(vectorDataOffset);
        this.meta.writeVLong(vectorDataLength);
        this.meta.writeVLong(vectorIndexOffset);
        this.meta.writeVLong(vectorIndexLength);
        this.meta.writeInt(field.getVectorDimension());
        int count = docsWithField.cardinality();
        this.meta.writeInt(count);
        if (count == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else if (count == maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else {
            long offset = this.vectorData.getFilePointer();
            this.meta.writeLong(offset);
            short jumpTableEntryCount = IndexedDISI.writeBitSet(docsWithField.iterator(), this.vectorData, (byte)9);
            this.meta.writeLong(this.vectorData.getFilePointer() - offset);
            this.meta.writeShort(jumpTableEntryCount);
            this.meta.writeByte((byte)9);
            long start = this.vectorData.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter ordToDocWriter = DirectMonotonicWriter.getInstance(this.meta, this.vectorData, count, 16);
            DocIdSetIterator iterator = docsWithField.iterator();
            int doc = iterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                ordToDocWriter.add(doc);
                doc = iterator.nextDoc();
            }
            ordToDocWriter.finish();
            this.meta.writeLong(this.vectorData.getFilePointer() - start);
        }
        this.meta.writeInt(this.M);
        if (graph == null) {
            this.meta.writeInt(0);
        } else {
            this.meta.writeInt(graph.numLevels());
            for (int level = 0; level < graph.numLevels(); ++level) {
                HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
                this.meta.writeInt(nodesOnLevel.size());
                if (level <= 0) continue;
                while (nodesOnLevel.hasNext()) {
                    int node = nodesOnLevel.nextInt();
                    this.meta.writeInt(node);
                }
            }
        }
    }

    private static DocsWithFieldSet writeVectorData(IndexOutput output, VectorValues vectors, int scalarSize) throws IOException {
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        int docV = vectors.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            BytesRef binaryValue = vectors.binaryValue();
            assert (binaryValue.length == vectors.dimension() * scalarSize);
            output.writeBytes(binaryValue.bytes, binaryValue.offset, binaryValue.length);
            docsWithField.add(docV);
            docV = vectors.nextDoc();
        }
        return docsWithField;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.meta, this.vectorData, this.vectorIndex);
    }

    private static class RAVectorValues<T>
    implements RandomAccessVectorValues {
        private final List<T> vectors;
        private final int dim;

        RAVectorValues(List<T> vectors, int dim) {
            this.vectors = vectors;
            this.dim = dim;
        }

        @Override
        public int size() {
            return this.vectors.size();
        }

        @Override
        public int dimension() {
            return this.dim;
        }

        @Override
        public float[] vectorValue(int targetOrd) throws IOException {
            return (float[])this.vectors.get(targetOrd);
        }

        @Override
        public BytesRef binaryValue(int targetOrd) throws IOException {
            return (BytesRef)this.vectors.get(targetOrd);
        }

        @Override
        public RandomAccessVectorValues copy() throws IOException {
            return this;
        }
    }

    private static abstract class FieldWriter<T>
    extends KnnFieldVectorsWriter<T> {
        private final FieldInfo fieldInfo;
        private final int dim;
        private final DocsWithFieldSet docsWithField;
        private final List<T> vectors;
        private final RAVectorValues<T> raVectorValues;
        private final HnswGraphBuilder<T> hnswGraphBuilder;
        private int lastDocID = -1;
        private int node = 0;

        static FieldWriter<?> create(FieldInfo fieldInfo, int M, int beamWidth, InfoStream infoStream) throws IOException {
            final int dim = fieldInfo.getVectorDimension();
            switch (fieldInfo.getVectorEncoding()) {
                case BYTE: {
                    return new FieldWriter<BytesRef>(fieldInfo, M, beamWidth, infoStream){

                        @Override
                        public BytesRef copyValue(BytesRef value) {
                            return new BytesRef(ArrayUtil.copyOfSubArray(value.bytes, value.offset, value.offset + dim));
                        }
                    };
                }
            }
            return new FieldWriter<float[]>(fieldInfo, M, beamWidth, infoStream){

                @Override
                public float[] copyValue(float[] value) {
                    return ArrayUtil.copyOfSubArray(value, 0, dim);
                }
            };
        }

        FieldWriter(FieldInfo fieldInfo, int M, int beamWidth, InfoStream infoStream) throws IOException {
            this.fieldInfo = fieldInfo;
            this.dim = fieldInfo.getVectorDimension();
            this.docsWithField = new DocsWithFieldSet();
            this.vectors = new ArrayList<T>();
            this.raVectorValues = new RAVectorValues<T>(this.vectors, this.dim);
            this.hnswGraphBuilder = HnswGraphBuilder.create(this.raVectorValues, fieldInfo.getVectorEncoding(), fieldInfo.getVectorSimilarityFunction(), M, beamWidth, HnswGraphBuilder.randSeed);
            this.hnswGraphBuilder.setInfoStream(infoStream);
        }

        @Override
        public void addValue(int docID, Object value) throws IOException {
            if (docID == this.lastDocID) {
                throw new IllegalArgumentException("VectorValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
            }
            Object vectorValue = value;
            assert (docID > this.lastDocID);
            this.docsWithField.add(docID);
            this.vectors.add(this.copyValue(vectorValue));
            if (this.node > 0) {
                this.hnswGraphBuilder.addGraphNode(this.node, vectorValue);
            }
            ++this.node;
            this.lastDocID = docID;
        }

        OnHeapHnswGraph getGraph() {
            if (this.vectors.size() > 0) {
                return this.hnswGraphBuilder.getGraph();
            }
            return null;
        }

        @Override
        public long ramBytesUsed() {
            if (this.vectors.size() == 0) {
                return 0L;
            }
            long vectorSize = this.vectors.size();
            return this.docsWithField.ramBytesUsed() + vectorSize * (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + vectorSize * (long)this.fieldInfo.getVectorDimension() * (long)this.fieldInfo.getVectorEncoding().byteSize + this.hnswGraphBuilder.getGraph().ramBytesUsed();
        }
    }
}

