/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1GlyphFactory;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.TextState;
import org.jpedal.objects.raw.MCObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.Decoder;
import org.jpedal.parser.LayerDecoder;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Rectangle;

public class TextDecoder
extends BaseDecoder
implements Decoder {
    public static boolean showInvisibleText = false;
    private Map lines = new HashMap(1000);
    private PdfFont currentFontData;
    private int fontSize = 0;
    private boolean endsWithSpace = false;
    private int currentRotation = 0;
    private PdfData pdfData;
    boolean markedContentExtracted = false;
    private Vector_Rectangle textAreas = new Vector_Rectangle();
    private Vector_Int textDirections = new Vector_Int();
    private TextState currentTextState;
    private boolean isPrinting = false;
    private static final double radiansToDegrees = 57.29577951308232;
    private float unRotatedY = -1.0f;
    private boolean textExtracted = true;
    private boolean renderText = false;
    private boolean textColorExtracted = false;
    private boolean highlightCoords = true;
    private boolean multipleTJs = false;
    private int moveCommand = 0;
    private boolean ttHintingRequired = false;
    private double rotationAsRadians = 0.0;
    private int textLength = 0;
    private static final String[] hex = new String[]{"&#0;", "&#1;", "&#2;", "&#3;", "&#4;", "&#5;", "&#6;", "&#7;", "&#8;", "&#9;", "&#10;", "&#11;", "&#12;", "&#13;", "&#14;", "&#15;", "&#16;", "&#17;", "&#18;", "&#19;", "&#20;", "&#21;", "&#22;", "&#23;", "&#24;", "&#25;", "&#26;", "&#27;", "&#28;", "&#29;", "&#30;", "&#31;"};
    private static final float THOUSAND = 1000.0f;
    private float charSpacing = 0.0f;
    private GlyphFactory factory = new T1GlyphFactory();
    private boolean returnText = false;
    private static final int[] multiply8 = new int[]{0, 3, 6, 9, 12, 15};
    private static final int[] multiply16 = new int[]{0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40};
    private static final int NONE = 0;
    private static final int RIGHT = 1;
    float x1;
    float y1;
    float x2;
    float y2;
    boolean isXMLExtraction = true;
    LayerDecoder layerDecoder;

    public TextDecoder(PdfData pdfData, boolean bl, LayerDecoder layerDecoder) {
        this.pdfData = pdfData;
        this.isXMLExtraction = bl;
        this.layerDecoder = layerDecoder;
    }

    public TextDecoder(LayerDecoder layerDecoder) {
        this.layerDecoder = layerDecoder;
        this.markedContentExtracted = true;
    }

    TextDecoder() {
    }

    private void calcCoordinates(float f, float[][] fArray, boolean bl, float f2, int n, float f3) {
        float[][] fArray2 = new float[3][3];
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(fArray[i], 0, fArray2[i], 0, 3);
        }
        this.x1 = f;
        this.x2 = fArray2[2][0] - this.charSpacing * fArray2[0][0];
        if (bl) {
            if (fArray2[1][0] < 0.0f) {
                this.x1 = f + fArray2[1][0] - this.charSpacing * fArray2[0][0];
                this.x2 = fArray2[2][0];
            } else if (fArray2[1][0] > 0.0f) {
                this.x1 = f;
                this.x2 = fArray2[2][0];
            }
        } else if (fArray2[1][0] > 0.0f) {
            this.x1 = fArray2[2][0];
            this.x2 = f + fArray2[1][0] - this.charSpacing * fArray2[0][0];
        } else if (fArray2[1][0] < 0.0f) {
            this.x2 = fArray2[2][0];
            this.x1 = f + fArray2[1][0] - this.charSpacing * fArray2[0][0];
        }
        if (!this.highlightCoords) {
            if (bl) {
                float f4 = 1.0f;
                if (this.currentFontData.getFontType() == 1228944679) {
                    f4 = f2 / (float)n;
                }
                if (fArray2[0][1] != 0.0f) {
                    this.y1 = fArray2[2][1] - fArray2[0][1] + (fArray2[0][1] + fArray2[1][1]) * f4;
                    this.y2 = f3;
                } else {
                    this.y1 = f3 + fArray2[1][1] * f4;
                    this.y2 = fArray2[2][1];
                }
            } else if (fArray2[0][1] <= 0.0f) {
                this.y2 = fArray2[2][1];
                this.y1 = f3;
            } else if (fArray2[0][1] > 0.0f) {
                this.y1 = fArray2[2][1];
                this.y2 = f3;
            }
        }
    }

    public void setFont(PdfFont pdfFont) {
        this.currentFontData = pdfFont;
    }

    public void setTextState(TextState textState) {
        this.currentTextState = textState;
    }

    public int processToken(TextState textState, int n, int n2, int n3) {
        this.currentTextState = textState;
        switch (n) {
            case 0x424443: {
                PdfObject pdfObject = TextDecoder.BDC(n2, n3, this.parser.getStream(), this.parser.generateOpAsString(0, false), this.layerDecoder, this.gs, this.currentPdfFile, this.current, this.markedContentExtracted);
                break;
            }
            case 4345155: {
                this.layerDecoder.BMC();
                break;
            }
            case 16980: {
                textState.resetTm();
                break;
            }
            case 4541763: {
                this.layerDecoder.EMC(this.current, this.gs);
                break;
            }
            case 17748: {
                this.current.resetOnColorspaceChange();
                break;
            }
            case 17488: {
                break;
            }
            case 19792: {
                break;
            }
            case 21606: {
                textState.TF(this.parser.parseFloat(0), this.parser.generateOpAsString(1, true));
                break;
            }
            case 21603: {
                textState.setCharacterSpacing(this.parser.parseFloat(0));
                break;
            }
            case 21572: {
                this.TD(false, this.parser.parseFloat(1), this.parser.parseFloat(0), textState);
                break;
            }
            case 21604: {
                this.TD(true, this.parser.parseFloat(1), this.parser.parseFloat(0), textState);
                break;
            }
            case 21610: {
                this.TJ(this.parser.getStream(), n2, n3);
                break;
            }
            case 21578: {
                this.TJ(this.parser.getStream(), n2, n3);
                break;
            }
            case 39: {
                this.TSTAR();
                this.TJ(this.parser.getStream(), n2, n3);
                break;
            }
            case 34: {
                this.double_quote(this.parser.getStream(), n2, n3, this.parser.parseFloat(1), this.parser.parseFloat(2));
                break;
            }
            case 21613: {
                textState.Tm[0][0] = this.parser.parseFloat(5);
                textState.Tm[0][1] = this.parser.parseFloat(4);
                textState.Tm[0][2] = 0.0f;
                textState.Tm[1][0] = this.parser.parseFloat(3);
                textState.Tm[1][1] = this.parser.parseFloat(2);
                textState.Tm[1][2] = 0.0f;
                textState.Tm[2][0] = this.parser.parseFloat(1);
                textState.Tm[2][1] = this.parser.parseFloat(0);
                textState.Tm[2][2] = 1.0f;
                textState.TmNoRotation[0][0] = textState.Tm[0][0];
                textState.TmNoRotation[0][1] = textState.Tm[0][1];
                textState.TmNoRotation[0][2] = 0.0f;
                textState.TmNoRotation[1][0] = textState.Tm[1][0];
                textState.TmNoRotation[1][1] = textState.Tm[1][1];
                textState.TmNoRotation[1][2] = 0.0f;
                textState.TmNoRotation[2][0] = textState.Tm[2][0];
                textState.TmNoRotation[2][1] = textState.Tm[2][1];
                textState.TmNoRotation[2][2] = 1.0f;
                this.TM();
                break;
            }
            case 21546: {
                this.TSTAR();
                break;
            }
            case 21618: {
                this.TR(this.parser.parseInt(0), this.gs);
                break;
            }
            case 21619: {
                textState.setTextRise(this.parser.parseFloat(0));
                break;
            }
            case 21623: {
                textState.setWordSpacing(this.parser.parseFloat(0));
                break;
            }
            case 21626: {
                textState.setHorizontalScaling(this.parser.parseFloat(0) / 100.0f);
                break;
            }
            case 21580: {
                textState.setLeading(this.parser.parseFloat(0));
            }
        }
        return n3;
    }

    private static PdfObject BDC(int n, int n2, byte[] byArray, String string, LayerDecoder layerDecoder, GraphicsState graphicsState, PdfObjectReader pdfObjectReader, DynamicVectorRenderer dynamicVectorRenderer, boolean bl) {
        MCObject mCObject = new MCObject(string);
        mCObject.setID(1184787);
        int n3 = n;
        if (n < 1) {
            n = 1;
        }
        boolean bl2 = true;
        while (n < byArray.length && byArray[n] != 60 && byArray[n - 1] != 60) {
            if (byArray[++n] != 66 || byArray[n + 1] != 68 || byArray[n + 2] != 67) continue;
            bl2 = false;
            break;
        }
        if (bl2 && (bl || layerDecoder.getPdfLayerList() != null && layerDecoder.isLayerVisible())) {
            ObjectDecoder objectDecoder = new ObjectDecoder(pdfObjectReader.getObjectReader());
            objectDecoder.setEndPt(n2);
            objectDecoder.readDictionaryAsObject(mCObject, n + 1, byArray);
        }
        layerDecoder.BDC(mCObject, graphicsState, dynamicVectorRenderer, n2, byArray, bl2, n3);
        return mCObject;
    }

    private void double_quote(byte[] byArray, int n, int n2, float f, float f2) {
        this.currentTextState.setCharacterSpacing(f);
        this.currentTextState.setWordSpacing(f2);
        this.TSTAR();
        this.TJ(byArray, n, n2);
    }

    private void TD(boolean bl, float f, float f2, TextState textState) {
        this.relativeMove(f, f2, textState);
        if (!bl) {
            float f3 = -f2;
            textState.setLeading(f3);
        }
        this.reset();
    }

    private void TM() {
        boolean bl = false;
        if (bl) {
            float[][] fArray = this.currentTextState.Tm;
            if (fArray[1][0] == 0.0f && fArray[0][1] == 0.0f) {
                this.currentRotation = 0;
                this.unRotatedY = -1.0f;
            } else if (fArray[0][1] == 0.0f || fArray[1][0] == 0.0f) {
                this.currentRotation = 0;
                this.unRotatedY = -1.0f;
            } else {
                this.rotationAsRadians = -Math.asin(fArray[1][0] / fArray[0][0]);
                int n = (int)(this.rotationAsRadians * 57.29577951308232);
                if (n == 0) {
                    this.currentRotation = 0;
                    this.unRotatedY = -1.0f;
                } else {
                    this.currentRotation = n;
                    this.convertToUnrotated(fArray);
                }
            }
        }
        this.currentTextState.setTMAtLineStart();
        this.currentTextState.setTMAtLineStartNoRotation();
        this.reset();
        this.moveCommand = 1;
    }

    private void TJ(byte[] byArray, int n, int n2) {
        if (this.formLevel != 1 || this.gs.CTM[0][0] == 0.0f || this.gs.CTM[0][0] == this.gs.CTM[0][1] || this.gs.CTM[0][0] == 1.0f || this.currentTextState.Tm[0][0] != 1.0f || !(this.gs.CTM[1][1] < 1.0f) || !(this.gs.CTM[1][1] > 0.92f) && this.gs.CTM[0][1] == 0.0f || !(this.currentTextState.Tm[2][1] < 0.0f)) {
            if (this.renderText && this.gs.getTextRenderType() != 4) {
                this.gs.setStrokeColor(this.gs.strokeColorSpace.getColor());
                this.gs.setNonstrokeColor(this.gs.nonstrokeColorSpace.getColor());
            }
            StringBuffer stringBuffer = this.processTextArray(byArray, n, n2, this.multiplyer);
            int n3 = this.fontSize;
            if (n3 == 0) {
                n3 = (int)this.currentTextState.getTfs();
            }
            if (n3 < 0) {
                n3 = -n3;
            }
            if (stringBuffer != null && this.isPageContent) {
                String string = null;
                if (this.textColorExtracted) {
                    string = (this.gs.getTextRenderType() & 2) == 2 ? this.gs.nonstrokeColorSpace.getXMLColorToken() : this.gs.strokeColorSpace.getXMLColorToken();
                }
                this.storeExtractedText(string, stringBuffer, n3, this.currentFontData.getFontName());
            }
        }
        this.moveCommand = -1;
    }

    private void TR(int n, GraphicsState graphicsState) {
        if (n == 0) {
            n = 2;
        } else if (n == 1) {
            n = 1;
        } else if (n == 2) {
            n = 3;
        } else if (n == 3) {
            n = 4;
            if (showInvisibleText) {
                n = 2;
            }
        } else if (n == 7) {
            n = 7;
        }
        graphicsState.setTextRenderType(n);
        if (this.renderPage && !this.renderDirectly) {
            this.current.drawTR(n);
        }
    }

    private void TSTAR() {
        this.relativeMove(0.0f, -this.currentTextState.getLeading(), this.currentTextState);
        this.moveCommand = 0;
        this.reset();
    }

    private void convertToUnrotated(float[][] fArray) {
        if (fArray[0][1] == 0.0f || fArray[1][0] == 0.0f) {
            return;
        }
        this.rotationAsRadians = -Math.asin(fArray[1][0] / fArray[0][0]);
        float[][] fArray2 = new float[3][3];
        fArray2[0][0] = (float)Math.cos(-this.rotationAsRadians);
        fArray2[0][1] = (float)Math.sin(-this.rotationAsRadians);
        fArray2[0][2] = 0.0f;
        fArray2[1][0] = (float)(-Math.sin(-this.rotationAsRadians));
        fArray2[1][1] = (float)Math.cos(-this.rotationAsRadians);
        fArray2[1][2] = 0.0f;
        fArray2[2][0] = 0.0f;
        fArray2[2][1] = 0.0f;
        fArray2[2][2] = 1.0f;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!((double)fArray2[j][i] > 0.99 & fArray2[j][i] < 1.0f)) continue;
                fArray2[j][i] = 1.0f;
            }
        }
        float[][] fArray3 = new float[3][3];
        fArray3[0][0] = fArray[2][0];
        fArray3[1][1] = fArray[2][1];
        fArray3[2][2] = 1.0f;
        fArray3 = Matrix.multiply(fArray2, fArray3);
        float[][] fArray4 = Matrix.multiply(fArray2, fArray);
        float f = fArray3[1][0];
        float f2 = fArray3[1][1] - f;
        float f3 = this.currentTextState.Tm[2][1];
        Integer n = new Integer((int)((double)f2 + 0.5));
        Float f4 = (Float)this.lines.get(n);
        if (f4 == null) {
            f4 = (Float)this.lines.get(new Integer((int)(f2 + 1.0f)));
        }
        if (f4 == null) {
            this.lines.put(n, new Float(this.currentTextState.Tm[2][1]));
        } else {
            f3 = f4.floatValue();
        }
        fArray4[2][1] = f3;
        this.currentTextState.TmNoRotation = fArray4;
        if (this.unRotatedY == -1.0f) {
            this.unRotatedY = this.currentTextState.TmNoRotation[2][1];
        }
        this.currentTextState.TmNoRotation[0][1] = 0.0f;
        this.currentTextState.TmNoRotation[1][0] = 0.0f;
    }

    private void relativeMove(float f, float f2, TextState textState) {
        float[][] fArray = new float[3][3];
        float f3 = textState.Tm[2][0];
        textState.Tm = textState.getTMAtLineStart();
        fArray[0][0] = 1.0f;
        fArray[0][1] = 0.0f;
        fArray[0][2] = 0.0f;
        fArray[1][0] = 0.0f;
        fArray[1][1] = 1.0f;
        fArray[1][2] = 0.0f;
        fArray[2][0] = f;
        fArray[2][1] = f2;
        fArray[2][2] = 1.0f;
        textState.Tm = Matrix.multiply(fArray, textState.Tm);
        float f4 = f3 - textState.Tm[2][0];
        if (!this.endsWithSpace && f2 == 0.0f && f > 2.0f && f < 10.0f && this.multipleTJs && f3 > textState.Tm[2][0] && f4 > 2.0f && (double)f4 < 4.5 && textState.Tm[0][0] == textState.Tm[1][1] && textState.Tm[0][0] > 10.0f && textState.Tm[0][0] < 12.0f) {
            textState.Tm[2][0] = f3 + 0.2f;
        }
        textState.setTMAtLineStart();
        if (this.currentRotation != 0) {
            float[][] fArray2 = new float[3][3];
            textState.TmNoRotation = textState.getTMAtLineStartNoRotation();
            fArray2[0][0] = 1.0f;
            fArray2[0][1] = 0.0f;
            fArray2[0][2] = 0.0f;
            fArray2[1][0] = 0.0f;
            fArray2[1][1] = 1.0f;
            fArray2[1][2] = 0.0f;
            fArray2[2][0] = f;
            fArray2[2][1] = f2;
            fArray2[2][2] = 1.0f;
            textState.TmNoRotation = Matrix.multiply(fArray2, textState.TmNoRotation);
            float f5 = f;
            float f6 = f2;
            if (f5 < 0.0f) {
                f5 = -f;
            }
            if (f6 < 0.0f) {
                f6 = -f2;
            }
            if (f5 > textState.Tm[0][0] && f6 > textState.Tm[1][1]) {
                this.convertToUnrotated(textState.Tm);
            }
            textState.setTMAtLineStartNoRotation();
        }
        this.moveCommand = 2;
    }

    private StringBuffer processTextArray(byte[] byArray, int n, int n2, float f) {
        float f2;
        float f3;
        float f4;
        int n3;
        boolean bl;
        float f5;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = this.currentFontData.getDiffMapping(9) != null;
        boolean bl6 = this.currentFontData.getDiffMapping(10) != null;
        boolean bl7 = this.currentFontData.getDiffMapping(13) != null;
        int n4 = 0;
        int n5 = byArray.length;
        while (byArray[n] == 91 || byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
            if (byArray[n] == 91) {
                bl3 = true;
            }
            ++n;
        }
        this.textLength = 0;
        int n6 = this.gs.getTextRenderType();
        boolean bl8 = false;
        float[][] fArray = new float[3][3];
        float[][] fArray2 = new float[3][3];
        float[][] fArray3 = new float[3][3];
        float[][] fArray4 = new float[3][3];
        int n7 = 32;
        int n8 = 32;
        int n9 = 32;
        int n10 = 120;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        String string = "";
        float f10 = f5 = this.currentTextState.getTfs();
        if (f5 < 0.0f) {
            f5 = -f5;
        }
        int n11 = this.currentFontData.getFontType();
        float f11 = this.currentFontData.getCurrentFontSpaceWidth();
        String string2 = "";
        StringBuffer stringBuffer = null;
        if (this.textExtracted) {
            stringBuffer = new StringBuffer(50);
        }
        boolean bl9 = this.currentFontData.isCIDFont();
        boolean bl10 = this.currentFontData.isFontVertical();
        boolean bl11 = false;
        int n12 = 2;
        if (bl9) {
            n12 = 4;
        }
        float[][] fArray5 = Matrix.multiply(this.currentTextState.Tm, this.gs.CTM);
        if (this.currentRotation != 0) {
            fArray = Matrix.multiply(this.currentTextState.TmNoRotation, this.gs.CTM);
        }
        if (f10 < 0.0f) {
            fArray5[2][0] = fArray5[2][0] - fArray5[0][0] / 2.0f;
            fArray5[2][1] = fArray5[2][1] - fArray5[1][1] / 2.0f;
            if (this.currentRotation != 0) {
                fArray[2][0] = fArray[2][0] - fArray[0][0] / 2.0f;
                fArray[2][1] = fArray5[2][1] - fArray[1][1] / 2.0f;
            }
        }
        this.charSpacing = this.currentTextState.getCharacterSpacing() / f5;
        float f12 = this.currentTextState.getWordSpacing() / f5;
        if (this.multipleTJs) {
            fArray5[2][0] = this.currentTextState.Tm[2][0];
            fArray5[2][1] = this.currentTextState.Tm[2][1];
            if (this.currentRotation != 0) {
                fArray[2][0] = this.currentTextState.TmNoRotation[2][0];
                fArray[2][1] = this.currentTextState.TmNoRotation[2][1];
            }
        }
        fArray2[0][0] = f10 * this.currentTextState.getHorizontalScaling();
        fArray2[1][1] = f10;
        fArray2[2][1] = this.currentTextState.getTextRise();
        fArray2[2][2] = 1.0f;
        fArray5 = Matrix.multiply(fArray2, fArray5);
        if (this.currentRotation != 0) {
            fArray = Matrix.multiply(fArray2, fArray);
        }
        if (bl3 && byArray[n] != 60 && byArray[n] != 40 && byArray[n] != 93) {
            float f13 = 0.0f;
            while (byArray[n] != 40 && byArray[n] != 60 && byArray[n] != 93) {
                StringBuffer stringBuffer2 = new StringBuffer(10);
                while (byArray[n] != 60 && byArray[n] != 40 && byArray[n] != 93 && byArray[n] != 32) {
                    stringBuffer2.append((char)byArray[n]);
                    ++n;
                }
                f13 += Float.parseFloat(stringBuffer2.toString());
                while (byArray[n] == 32) {
                    ++n;
                }
            }
            if (fArray5[0][0] == 0.0f && fArray5[1][1] == 0.0f && fArray5[0][1] > 0.0f && fArray5[1][0] < 0.0f) {
                f13 = fArray5[0][1] * f13 / 1000.0f;
                fArray5[2][1] = fArray5[2][1] - f13;
                if (this.currentRotation != 0) {
                    fArray[2][1] = fArray[2][1] - f13;
                }
            } else {
                f13 = fArray5[0][0] * f13 / 1000.0f;
                fArray5[2][0] = fArray5[2][0] - f13;
                if (this.currentRotation != 0) {
                    fArray[2][0] = fArray[2][0] - f13;
                }
            }
        }
        this.multipleTJs = true;
        if (fArray5[1][1] != 0.0f) {
            bl = true;
            n3 = 0;
            this.fontSize = fArray5[1][1] < 0.0f ? (int)(fArray5[1][1] - 0.5f) : (int)(fArray5[1][1] + 0.5f);
            if (this.fontSize == 0) {
                this.fontSize = fArray5[0][1] < 0.0f ? (int)(fArray5[0][1] - 0.5f) : (int)(fArray5[0][1] + 0.5f);
            }
            f4 = fArray5[0][0];
            if (fArray5[0][0] == 0.0f && fArray5[0][1] > 0.0f && fArray5[1][0] < 0.0f && fArray5[1][1] > 0.0f) {
                n3 = 3;
            }
        } else {
            bl = false;
            this.fontSize = fArray5[1][0] < 0.0f ? (int)(fArray5[1][0] - 0.5f) : (int)(fArray5[1][0] + 0.5f);
            if (this.fontSize == 0) {
                this.fontSize = fArray5[0][0] < 0.0f ? (int)(fArray5[0][0] - 0.5f) : (int)(fArray5[0][0] + 0.5f);
            }
            if (this.fontSize < 0) {
                this.fontSize = -this.fontSize;
                n3 = 3;
            } else {
                n3 = 2;
            }
            f4 = fArray5[0][1];
        }
        this.currentTextState.writingMode = n3;
        if (this.fontSize == 0) {
            this.fontSize = 1;
        }
        Font font = null;
        if (this.isPrinting && this.textPrint == 3 && StandardFonts.isStandardFont(this.currentFontData.getFontName(), true)) {
            font = this.currentFontData.getJavaFontX(this.fontSize);
        } else if (this.currentFontData.isFontEmbedded && !this.currentFontData.isFontSubstituted()) {
            font = null;
        } else if ((PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts || this.textPrint != 0) && this.isPrinting) {
            font = this.currentFontData.getJavaFontX(this.fontSize);
        }
        if (this.currentRotation == 0) {
            f3 = fArray5[2][0];
            f2 = fArray5[2][1];
        } else {
            f3 = fArray[2][0];
            f2 = fArray[2][1];
        }
        if (fArray5[1][0] < 0.0f && fArray5[0][1] > 0.0f && fArray5[1][1] == 0.0f && fArray5[0][0] == 0.0f) {
            bl11 = true;
        }
        float f14 = this.fontSize;
        if (n11 == 1228944679 && this.fontSize > 10) {
            f14 = 10.0f;
        }
        if (bl9) {
            f14 = fArray5[1][1];
        }
        int n13 = 0;
        boolean bl12 = true;
        for (int i = n; i < n2; ++i) {
            int n14;
            boolean bl13;
            int n15;
            int n16;
            int n17;
            while (true) {
                n8 = n8 == 92 && n7 == 92 ? 120 : n7;
                n17 = byArray[i];
                if (n17 < 0) {
                    n17 = 256 + n17;
                }
                if ((n7 = (int)((char)n17)) == 92 && (byArray[i + 1] == 13 || byArray[i + 1] == 10)) {
                    if ((n17 = byArray[++i]) < 0) {
                        n17 = 256 + n17;
                    }
                    n7 = (char)n17;
                }
                if (n7 != 10 && n7 != 13) break;
                ++i;
            }
            if (bl8) {
                if (n8 != 92 && (n7 == 40 || n7 == 41)) {
                    if (n7 == 40) {
                        ++n13;
                    } else if (n7 == 41) {
                        if (n13 <= 0) {
                            bl8 = false;
                        } else {
                            --n13;
                        }
                    }
                } else if (n9 == 60 && n7 == 62) {
                    bl8 = false;
                }
            }
            if (bl8) {
                block210: {
                    float f15;
                    int n18;
                    n10 = n7;
                    if (n9 == 60) {
                        int n19 = 0;
                        n16 = 0;
                        for (n15 = 1; n15 < n12; ++n15) {
                            n18 = byArray[i + n15];
                            if (n18 == 62) {
                                n15 = 4;
                                n12 = 2;
                                continue;
                            }
                            if (n18 == 10 || n18 == 13) {
                                ++i;
                                --n15;
                                continue;
                            }
                            ++n16;
                        }
                        bl13 = false;
                        for (n14 = 0; n14 < n16 + 1; ++n14) {
                            n15 = byArray[i + n16 - n14];
                            if (n15 >= 65 && n15 <= 70) {
                                n15 -= 55;
                            } else if (n15 >= 97 && n15 <= 102) {
                                n15 -= 87;
                            } else {
                                if (n15 < 48 || n15 > 57) continue;
                                n15 -= 48;
                            }
                            n19 += n15 << multiply16[bl13];
                            bl13 += 1;
                        }
                        n17 = n19;
                        i = i + n12 - 1;
                        n7 = (char)n17;
                        string = this.currentFontData.getGlyphValue(n17);
                        if (this.textExtracted) {
                            string2 = this.currentFontData.getUnicodeValue(string, n17);
                        }
                    } else if (bl9 && this.currentFontData.isDoubleByte()) {
                        int n20;
                        if (n7 == 92) {
                            while (true) {
                                if ((n17 = byArray[i]) < 0) {
                                    n17 = 256 + n17;
                                }
                                if (n17 < 0) {
                                    n17 = 256 + n17;
                                }
                                n7 = (char)n17;
                                if (n17 == 92) {
                                    if ((n7 = (int)((char)(n17 = byArray[++i]))) == 110) {
                                        n17 = 10;
                                    } else if (n7 == 98) {
                                        n17 = 8;
                                    } else if (n7 == 116) {
                                        n17 = 9;
                                    } else if (n7 == 114) {
                                        n17 = 13;
                                    } else if (n7 == 102) {
                                        n17 = 12;
                                    } else if (n5 > i + 2 && Character.isDigit((char)byArray[i])) {
                                        int n21 = 1;
                                        if (Character.isDigit((char)byArray[i + 1])) {
                                            ++n21;
                                            if (Character.isDigit((char)byArray[i + 2])) {
                                                ++n21;
                                            }
                                        }
                                        n17 = TextDecoder.readEscapeValue(i, n21, 8, byArray);
                                        i = i + n21 - 1;
                                    }
                                }
                                if (n7 != 10 && n7 != 13) break;
                                ++i;
                            }
                        }
                        if ((n20 = byArray[++i]) < 0) {
                            n20 = 256 + n20;
                        }
                        if (n20 == 92) {
                            if ((n7 = (int)((char)(n20 = byArray[++i]))) == 110) {
                                n20 = 10;
                            } else if (n7 == 98) {
                                n20 = 8;
                            } else if (n7 == 116) {
                                n20 = 9;
                            } else if (n7 == 114) {
                                n20 = 13;
                            } else if (n7 == 102) {
                                n20 = 12;
                            } else if (n5 > i + 2 && Character.isDigit((char)byArray[i])) {
                                n16 = 1;
                                if (Character.isDigit((char)byArray[i + 1])) {
                                    ++n16;
                                    if (Character.isDigit((char)byArray[i + 2])) {
                                        ++n16;
                                    }
                                }
                                n20 = TextDecoder.readEscapeValue(i, n16, 8, byArray);
                                i = i + n16 - 1;
                            }
                        }
                        n17 = n17 * 256 + n20;
                        n7 = (char)n17;
                        string = String.valueOf((char)n7);
                        string2 = this.currentFontData.getUnicodeValue(string, n17);
                        if (n7 == 92) {
                            n7 = 120;
                        }
                    } else if (n7 == 92) {
                        String string3;
                        n8 = n7;
                        if (n5 > ++i + 2 && Character.isDigit((char)byArray[i])) {
                            int n22 = 1;
                            if (Character.isDigit((char)byArray[i + 1])) {
                                ++n22;
                                if (Character.isDigit((char)byArray[i + 2])) {
                                    ++n22;
                                }
                            }
                            n17 = TextDecoder.readEscapeValue(i, n22, 8, byArray);
                            i = i + n22 - 1;
                            if (n17 > 255) {
                                n17 -= 256;
                            }
                            string = this.currentFontData.getGlyphValue(n17);
                            if (this.textExtracted) {
                                string2 = this.currentFontData.getUnicodeValue(string, n17);
                            }
                            if ((n7 = (int)((char)n17)) == 92) {
                                n7 = 120;
                            }
                        } else {
                            n17 = byArray[i];
                            n7 = (char)n17;
                            if (n7 == 117) {
                                n17 = TextDecoder.readEscapeValue(i + 1, 4, 16, byArray);
                                i += 4;
                                string = this.currentFontData.getGlyphValue(n17);
                                if (this.textExtracted) {
                                    string2 = this.currentFontData.getUnicodeValue(string, n17);
                                }
                            } else {
                                if (n7 == 110) {
                                    n17 = 10;
                                    n7 = 10;
                                } else if (n7 == 98) {
                                    n17 = 8;
                                    n7 = 8;
                                } else if (n7 == 116) {
                                    n17 = 9;
                                    n7 = 9;
                                } else if (n7 == 114) {
                                    n17 = 13;
                                    n7 = 13;
                                } else if (n7 == 102) {
                                    n17 = 12;
                                    n7 = 12;
                                }
                                string = this.currentFontData.getGlyphValue(n17);
                                if (this.textExtracted) {
                                    string2 = this.currentFontData.getUnicodeValue(string, n17);
                                }
                                if (string.length() > 0) {
                                    n7 = string.charAt(0);
                                }
                            }
                        }
                        if (this.current.getType() == 3 && this.currentFontData.getFontType() == 1228944677 && (string3 = this.currentFontData.getMappedChar(n17, true)) != null && string3.length() == 1 && string3.toLowerCase().equals(string2.toLowerCase())) {
                            string2 = string = string3;
                        }
                    } else if (bl9) {
                        string = String.valueOf((char)n7);
                        if (this.textExtracted) {
                            string2 = this.currentFontData.getUnicodeValue(string, n17);
                        }
                    } else {
                        String string4;
                        string = this.currentFontData.getGlyphValue(n17);
                        if (n17 == 32 && !string.equals(" ")) {
                            n10 = 90;
                        }
                        if (this.textExtracted) {
                            string2 = this.currentFontData.getUnicodeValue(string, n17);
                        }
                        if (this.current.getType() == 3 && this.currentFontData.getFontType() == 1228944677 && (string4 = this.currentFontData.getMappedChar(n17, true)) != null && string4.length() == 1 && string4.toLowerCase().equals(string2.toLowerCase())) {
                            string2 = string = string4;
                        }
                    }
                    if (n17 == 9 && !bl5 && this.currentFontData.isFontSubstituted()) {
                        n17 = 32;
                        string = " ";
                        string2 = " ";
                    }
                    fArray2[0][0] = 1.0f;
                    fArray2[0][1] = 0.0f;
                    fArray2[0][2] = 0.0f;
                    fArray2[1][0] = 0.0f;
                    fArray2[1][1] = 1.0f;
                    fArray2[1][2] = 0.0f;
                    if (bl10) {
                        fArray2[2][1] = -(f8 + f9);
                        fArray2[2][0] = 0.0f;
                    } else {
                        fArray2[2][0] = f8 + f9;
                        fArray2[2][1] = 0.0f;
                    }
                    fArray2[2][2] = 1.0f;
                    fArray5 = Matrix.multiply(fArray2, fArray5);
                    if (this.currentRotation != 0) {
                        fArray = Matrix.multiply(fArray2, fArray);
                    }
                    if (n7 == 32 && n8 != 32) {
                        fArray3 = fArray5;
                        if (this.currentRotation != 0) {
                            fArray4 = fArray;
                        }
                    }
                    f9 = 0.0f;
                    PdfJavaGlyphs pdfJavaGlyphs = this.currentFontData.getGlyphData();
                    if (this.currentFontData.isCIDFont() && pdfJavaGlyphs.is1C() && !pdfJavaGlyphs.isIdentity() && (n16 = pdfJavaGlyphs.getCMAPValue(n17)) > 0) {
                        n17 = n16;
                    }
                    n16 = n17;
                    if (!pdfJavaGlyphs.isCorrupted()) {
                        if (this.currentFontData.isCIDFont() && !pdfJavaGlyphs.isIdentity()) {
                            n18 = pdfJavaGlyphs.getConvertedGlyph(n17);
                            if (n18 != -1) {
                                n16 = n18;
                            }
                        } else if (this.currentFontData.getFontType() != 1228944679 && (n18 = this.currentFontData.getDiffChar(n17)) > 0) {
                            n17 = n18;
                        }
                    }
                    f8 = this.currentFontData.getWidth(n16);
                    if (this.current.getType() == 3) {
                        this.currentFontData.setCurrentWidth(f8);
                    }
                    if (f12 < 0.0f && n17 == 32 && this.current.getType() == 3 && (double)(f15 = Math.abs(f12 + f8)) < 0.01) {
                        string2 = "";
                    }
                    if (this.renderText && n6 != 4) {
                        if (this.isPrinting && font != null && (this.textPrint == 3 || this.textPrint == 2 || PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts && (!this.currentFontData.isFontEmbedded || this.currentFontData.isFontSubstituted()))) {
                            if (n6 == 7) {
                                boolean bl14 = PdfDecoder.isRunningOnMac || StandardFonts.isStandardFont(this.currentFontData.getBaseFontName(), false);
                                Area area = pdfJavaGlyphs.getStandardGlyph(fArray5, n17, string, f8, bl14);
                                if (area != null) {
                                    this.gs.addClip(area);
                                }
                                this.current.drawClip(this.gs, null, true);
                            }
                            if (string != null && !string.startsWith("&#")) {
                                if (this.current.getType() == 3) {
                                    this.current.drawEmbeddedText(fArray5, this.fontSize, null, null, 1, this.gs, null, string, this.currentFontData);
                                } else {
                                    this.current.drawText(fArray5, string, this.gs, fArray5[2][0], -fArray5[2][1], font);
                                }
                            }
                        } else if (!((this.textPrint != 1 || font == null) && this.currentFontData.isFontEmbedded && this.currentFontData.isFontSubstituted() && (n17 == 9 && !bl5 || n17 == 10 && !bl6 || n17 == 13 && !bl7) || (this.textPrint != 1 || font == null) && this.currentFontData.isFontSubstituted() && f8 == 0.0f && string.charAt(0) == '\r')) {
                            if ((this.textPrint != 1 || font == null) && this.currentFontData.isFontEmbedded) {
                                String string5 = "notdef";
                                try {
                                    if (!this.currentFontData.isCIDFont()) {
                                        string5 = this.currentFontData.getMappedChar(n17, false);
                                    }
                                    PdfGlyph pdfGlyph = pdfJavaGlyphs.getEmbeddedGlyph(this.factory, string5, fArray5, n17, string, f8, this.currentFontData.getEmbeddedChar(n17));
                                    if (n11 == 1228944679) {
                                        if (pdfGlyph != null && pdfGlyph.getmaxWidth() == 0.0f) {
                                            pdfGlyph = null;
                                        } else if (pdfGlyph != null && pdfGlyph.ignoreColors()) {
                                            pdfGlyph.lockColors(this.gs.getNonstrokeColor(), this.gs.getNonstrokeColor());
                                        }
                                    }
                                    if (pdfGlyph != null) {
                                        float f16;
                                        if (pdfGlyph != null && n11 == 1228944677) {
                                            pdfGlyph.setWidth(f8 * 1000.0f);
                                        }
                                        Object object = new float[][]{{fArray5[0][0], fArray5[0][1], 0.0f}, {fArray5[1][0], fArray5[1][1], 0.0f}, {fArray5[2][0], fArray5[2][1], 1.0f}};
                                        float[][] fArrayArray = new float[][]{{(float)this.currentFontData.FontMatrix[0], (float)this.currentFontData.FontMatrix[1], 0.0f}, {(float)this.currentFontData.FontMatrix[2], (float)this.currentFontData.FontMatrix[3], 0.0f}, {0.0f, 0.0f, 1.0f}};
                                        object = Matrix.multiply(object, fArrayArray);
                                        object[2][0] = fArray5[2][0];
                                        object[2][1] = fArray5[2][1];
                                        if (object[1][0] < 0.0f && object[0][1] < 0.0f) {
                                            object[1][0] = -object[1][0];
                                            object[0][1] = -object[0][1];
                                        }
                                        if (n11 == 1228944679) {
                                            float f17 = 0.0f;
                                            if (object[1][1] != 0.0f) {
                                                f17 = (float)this.fontSize * object[1][1];
                                            } else if (object[0][0] != 0.0f) {
                                                f17 = (float)this.fontSize * object[0][0];
                                            } else if (object[1][0] != 0.0f) {
                                                f17 = (float)this.fontSize * object[1][0];
                                            }
                                            if (f17 < 0.0f) {
                                                f17 = -f17;
                                            }
                                            if (f17 > f14) {
                                                f14 = f17;
                                            }
                                        }
                                        AffineTransform affineTransform = new AffineTransform(object[0][0], object[0][1], object[1][0], object[1][1], object[2][0], object[2][1]);
                                        int n23 = 5;
                                        if (n11 == 6) {
                                            n23 = 5;
                                            f16 = 1000.0f / pdfGlyph.getmaxWidth();
                                            affineTransform.scale(f8 * f16, 1.0);
                                        } else if (n11 == 1217103210 || n11 == -1684566724 || this.currentFontData.isFontSubstituted() && n11 != 1228944677) {
                                            n23 = 4;
                                        } else if (n11 == 1228944679) {
                                            n23 = 6;
                                        }
                                        if (this.generateGlyphOnRender) {
                                            n23 = -n23;
                                        }
                                        if (n6 == 7 && pdfGlyph.getShape() != null) {
                                            Area area = (Area)pdfGlyph.getShape().clone();
                                            area.transform(affineTransform);
                                            if (area.getBounds().getWidth() > 0.0 && area.getBounds().getHeight() > 0.0) {
                                                this.gs.addClip(area);
                                                this.current.drawClip(this.gs, null, false);
                                            }
                                        }
                                        f16 = this.gs.getLineWidth();
                                        float f18 = 0.0f;
                                        if (f > 0.0f) {
                                            f18 = 1.0f / f;
                                        }
                                        this.gs.setLineWidth(f18);
                                        if (bl11) {
                                            this.current.drawEmbeddedText(fArray5, -this.fontSize, pdfGlyph, null, n23, this.gs, affineTransform, string2, this.currentFontData);
                                        } else {
                                            this.current.drawEmbeddedText(fArray5, this.fontSize, pdfGlyph, null, n23, this.gs, affineTransform, string2, this.currentFontData);
                                        }
                                        this.gs.setLineWidth(f16);
                                        break block210;
                                    }
                                    string = " ";
                                    string2 = " ";
                                }
                                catch (Exception exception) {
                                    this.errorTracker.addPageFailureMessage("Exception " + exception + " on embedded font renderer");
                                }
                            } else if (string.length() > 0 && !string.startsWith("&#")) {
                                bl4 = this.renderTextWithJavaFonts(bl4, n6, this.fontSize, n17, f8, string, string2, bl11, pdfJavaGlyphs, fArray5);
                            }
                        }
                    }
                }
                f8 += this.charSpacing;
                if (n7 == 32) {
                    f8 += f12;
                }
                float f19 = f6 + this.charSpacing - f7;
                String string6 = "";
                if (f19 > 0.0f && f7 > 0.0f) {
                    string6 = PdfFont.getSpaces(f19, f11, PdfStreamDecoder.currentThreshold);
                }
                ++this.textLength;
                f7 = f6 += f8;
                if (this.textExtracted) {
                    bl2 = TextDecoder.writeOutText(bl2, bl, fArray, fArray5, f4, f8, string2, stringBuffer, string6, this.isXMLExtraction, this.currentRotation);
                }
            } else if (n7 == 40 || n7 == 60) {
                bl8 = true;
                n9 = n7;
            } else if (n7 == 41 || n7 == 62 && n9 == 60 || !bl8 && (n7 == 45 || n7 >= 48 && n7 <= 57)) {
                float f20 = 0.0f;
                ++i;
                while (byArray[i] == 32 || byArray[i] == 13 || byArray[i] == 10) {
                    ++i;
                }
                char c = (char)byArray[i];
                if (c == '(' || c == '<') {
                    --i;
                } else if (c != '\'' && c != '\"' && c != '(' && c != ']' && c != '<') {
                    n16 = 0;
                    int n24 = i;
                    n15 = 0;
                    bl13 = false;
                    n14 = 0;
                    while (n15 == 0) {
                        n7 = c;
                        if (n7 != 10 && n7 != 13) {
                            ++n16;
                        }
                        if ((c = (char)byArray[i + 1]) == ' ') {
                            bl13 = true;
                        }
                        if (c == ']') {
                            n14 = 1;
                        }
                        if (c == '(' || c == '<' || c == ']' || c == '\n') break;
                        if (c != '-' && c != '.' && c != ' ' && (c < '0' || c > '9')) {
                            n15 = 1;
                        }
                        ++i;
                    }
                    if (n15 != 0) {
                        i = n24;
                    } else {
                        f20 = TextDecoder.getLeading(byArray, f20, n16, n24, bl13);
                    }
                    if (n14 != 0 && f20 == -f6) {
                        f9 -= f20;
                    }
                }
                f6 += f20;
                f9 += f20;
            }
            if (!this.textExtracted) continue;
            bl12 = this.setExtractedText(n4, fArray5, f4, f8, string, bl12);
        }
        fArray2[0][0] = 1.0f;
        fArray2[0][1] = 0.0f;
        fArray2[0][2] = 0.0f;
        fArray2[1][0] = 0.0f;
        fArray2[1][1] = 1.0f;
        fArray2[1][2] = 0.0f;
        fArray2[2][0] = f9 < 0.0f ? f8 : f8 + f9;
        fArray2[2][1] = 0.0f;
        fArray2[2][2] = 1.0f;
        fArray5 = Matrix.multiply(fArray2, fArray5);
        this.currentTextState.Tm[2][0] = fArray5[2][0];
        this.currentTextState.Tm[2][1] = fArray5[2][1] - this.currentTextState.getTextRise();
        if (this.currentRotation != 0) {
            fArray = Matrix.multiply(fArray2, fArray);
            this.currentTextState.TmNoRotation[2][0] = fArray[2][0];
            this.currentTextState.TmNoRotation[2][1] = fArray[2][1];
        }
        boolean bl15 = this.endsWithSpace = n10 == 32;
        if (this.textExtracted) {
            if (n10 == 32) {
                fArray5 = fArray3;
                if (this.currentRotation != 0) {
                    fArray = fArray4;
                }
            }
            if (this.currentRotation == 0) {
                this.calcCoordinates(f3, fArray5, bl, f14, this.fontSize, f2);
            } else {
                this.calcCoordinates(f3, fArray, bl, f14, this.fontSize, f2);
            }
            if (stringBuffer.length() == 0 || !bl2) {
                stringBuffer = null;
            }
            return stringBuffer;
        }
        return null;
    }

    private boolean renderTextWithJavaFonts(boolean bl, int n, int n2, int n3, float f, String string, String string2, boolean bl2, PdfJavaGlyphs pdfJavaGlyphs, float[][] fArray) {
        Area area;
        boolean bl3;
        AffineTransform affineTransform = null;
        boolean bl4 = bl3 = PdfDecoder.isRunningOnMac || StandardFonts.isStandardFont(this.currentFontData.getBaseFontName(), false);
        if (pdfJavaGlyphs.lastTrm[0][0] != fArray[0][0] || pdfJavaGlyphs.lastTrm[1][0] != fArray[1][0] || pdfJavaGlyphs.lastTrm[0][1] != fArray[0][1] || pdfJavaGlyphs.lastTrm[1][1] != fArray[1][1]) {
            pdfJavaGlyphs.lastTrm = fArray;
            pdfJavaGlyphs.flush();
        }
        Area area2 = pdfJavaGlyphs.getCachedShape(n3);
        affineTransform = pdfJavaGlyphs.getCachedTransform(n3);
        if (area2 == null) {
            double d = -1.0;
            double d2 = 1.0;
            double d3 = 0.0;
            double d4 = 0.0;
            if (fArray[1][0] < 0.0f && fArray[0][1] >= 0.0f || fArray[0][1] < 0.0f && fArray[1][0] >= 0.0f) {
                d2 = 1.0;
                d = -1.0;
            }
            if (bl3) {
                area2 = pdfJavaGlyphs.getGlyph(n3, string, f);
                if (area2 != null && n3 == 146 && pdfJavaGlyphs.isArialInstalledLocally) {
                    d4 = -(area2.getBounds().height - area2.getBounds().y);
                }
            } else {
                String string3 = string;
                if (pdfJavaGlyphs.remapFont && !pdfJavaGlyphs.getUnscaledFont().canDisplay(string3.charAt(0))) {
                    string3 = String.valueOf((char)(n3 + 61440));
                }
                GlyphVector glyphVector = null;
                if (!pdfJavaGlyphs.isCIDFont || pdfJavaGlyphs.isFontInstalled) {
                    glyphVector = pdfJavaGlyphs.getUnscaledFont().createGlyphVector(PdfJavaGlyphs.frc, string3);
                }
                if (glyphVector != null) {
                    double d5;
                    double d6;
                    area2 = new Area(glyphVector.getOutline());
                    double d7 = glyphVector.getOutline().getBounds2D().getX();
                    d3 = 0.0;
                    if (d7 < 0.0) {
                        d7 = -d7;
                        d3 = d7 * 2.0;
                        d3 = fArray[0][0] > fArray[0][1] ? (d3 *= (double)fArray[0][0]) : (d3 *= (double)fArray[0][1]);
                    }
                    if ((d6 = (double)f / (d5 = glyphVector.getVisualBounds().getWidth() + d7 * 2.0)) < 1.0) {
                        d2 *= d6;
                    }
                    if (d3 > 0.0) {
                        d3 *= d2;
                    }
                }
            }
            affineTransform = new AffineTransform(d2 * (double)fArray[0][0], d2 * (double)fArray[0][1], d * (double)fArray[1][0], d * (double)fArray[1][1], d3, d4);
            pdfJavaGlyphs.setCachedShape(n3, area2, affineTransform);
        }
        if (area2 != null && n == 7 && area2.getBounds().width > 0) {
            Area area3 = (Area)area2.clone();
            area3.transform(affineTransform);
            if (this.renderDirectly) {
                AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(fArray[2][0], fArray[2][1]);
                area3.transform(affineTransform2);
            }
            this.gs.addClip(area3);
            this.current.drawClip(this.gs, null, false);
            if (this.renderDirectly) {
                area2 = null;
            }
        }
        if ((area = area2) != null) {
            if (this.renderDirectly) {
                this.current.drawEmbeddedText(fArray, n2, null, area, 1, this.gs, affineTransform, string2, this.currentFontData);
            } else if (bl2) {
                this.current.drawEmbeddedText(fArray, -n2, null, area, 1, this.gs, null, string2, this.currentFontData);
            } else {
                this.current.drawEmbeddedText(fArray, n2, null, area, 1, this.gs, null, string2, this.currentFontData);
            }
        }
        return bl;
    }

    private static boolean writeOutText(boolean bl, boolean bl2, float[][] fArray, float[][] fArray2, float f, float f2, String string, StringBuffer stringBuffer, String string2, boolean bl3, int n) {
        if (string.length() > 0) {
            if (PdfDecoder.embedWidthData) {
                float f3 = fArray2[2][0];
                float f4 = fArray2[2][1];
                if (n != 0) {
                    f3 = fArray[2][0];
                    f4 = fArray[2][1];
                }
                stringBuffer.append(string2);
                if (bl2) {
                    stringBuffer.append(PdfData.marker);
                    stringBuffer.append(f3);
                    stringBuffer.append(PdfData.marker);
                } else {
                    stringBuffer.append(PdfData.marker);
                    stringBuffer.append(f4);
                    stringBuffer.append(PdfData.marker);
                }
                stringBuffer.append(f2 * f);
                stringBuffer.append(PdfData.marker);
            } else {
                stringBuffer.append(string2);
            }
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                bl = true;
                if (c == '\t') {
                    c = ' ';
                }
                if (c == '<' && bl3) {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (c == '>' && bl3) {
                    stringBuffer.append("&gt;");
                    continue;
                }
                if (c == '\ufb02') {
                    stringBuffer.append("fl");
                    continue;
                }
                if (c > '\u001f') {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(hex[c]);
            }
        } else {
            stringBuffer.append(string2);
        }
        return bl;
    }

    public Object getObjectValue(int n) {
        switch (n) {
            case -21: {
                return this.textAreas;
            }
            case 22: {
                return this.textDirections;
            }
        }
        return null;
    }

    private static String getString(int n, int n2, byte[] byArray) {
        while (byArray[n2] == 32 || byArray[n2] == 13 || byArray[n2] == 10) {
            --n2;
        }
        int n3 = n2 - n + 1;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (i <= 0 || byArray[n + i] != 32 && byArray[n + i] != 13 && byArray[n + i] != 10 || byArray[n + i - 1] != 32 && byArray[n + i - 1] != 13 && byArray[n + i - 1] != 10) continue;
            ++n4;
        }
        char[] cArray = new char[n3 - n4];
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            if (i > 0 && (byArray[n + i] == 32 || byArray[n + i] == 13 || byArray[n + i] == 10) && (byArray[n + i - 1] == 32 || byArray[n + i - 1] == 13 || byArray[n + i - 1] == 10)) continue;
            cArray[n5] = byArray[n + i] == 10 || byArray[n + i] == 13 ? 32 : (char)byArray[n + i];
            ++n5;
        }
        String string = String.copyValueOf(cArray);
        return string;
    }

    private static float getLeading(byte[] byArray, float f, int n, int n2, boolean bl) {
        if (bl) {
            int n3 = n2;
            while (byArray[n3] == 10 || byArray[n3] == 9 || byArray[n3] == 32 || byArray[n3] == 13) {
                ++n3;
            }
            String string = TextDecoder.getString(n3, n3 + n - 1, byArray);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            f = 0.0f;
            while (stringTokenizer.hasMoreTokens()) {
                f += Float.parseFloat(stringTokenizer.nextToken());
            }
            f = -f / 1000.0f;
        } else if (n > 0) {
            int n4 = n2;
            while (byArray[n4] == 10 || byArray[n4] == 9 || byArray[n4] == 32 || byArray[n4] == 13) {
                ++n4;
            }
            f = -NumberUtils.parseFloat(n4, n4 + n, byArray) / 1000.0f;
        }
        return f;
    }

    private boolean setExtractedText(int n, float[][] fArray, float f, float f2, String string, boolean bl) {
        if (string.length() > 0 && !string.equals(" ")) {
            float f3;
            float f4 = (int)fArray[2][0];
            if (n == 1) {
                f4 -= fArray[1][0];
            }
            float f5 = (int)fArray[2][1];
            float f6 = f2 * f;
            float f7 = fArray[1][1];
            if (f7 == 0.0f) {
                f7 = fArray[0][1];
            }
            if (this.currentFontData.getFontType() == 1228944679 && f7 != 0.0f && (int)f7 == 0 && this.currentFontData.FontMatrix[3] == -1.0) {
                f7 *= this.currentFontData.FontBBox[3] - this.currentFontData.FontBBox[1];
                f7 = -f7;
            }
            f7 = (int)f7;
            if (f6 < 0.0f) {
                f6 = -f6;
                f4 -= f6;
            }
            if (f7 < 0.0f) {
                f7 = -f7;
                f5 -= f7;
            }
            Rectangle rectangle = this.currentFontData.getBoundingBox();
            if (rectangle.y < 0) {
                rectangle.height -= rectangle.y;
                rectangle.y = 0;
            }
            if ((f3 = (float)rectangle.y) == 0.0f) {
                f3 = 100.0f;
            }
            if (f3 < 0.0f) {
                f3 = -f3;
            }
            float f8 = 1000.0f + f3;
            f8 = 1000.0f / f8;
            switch (this.currentTextState.writingMode) {
                case 0: {
                    float f9 = f7 / f8;
                    f5 -= f9 - f7;
                    f7 = f9;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    float f10 = f6 / f8;
                    f4 -= f10 - f6;
                    f6 = f10;
                    break;
                }
                case 3: {
                    float f11 = f6 / f8;
                    f4 -= f11;
                    f6 = f11;
                }
            }
            f4 -= 1.0f;
            f6 += 2.0f;
            if (this.highlightCoords) {
                if (bl) {
                    this.y2 = f5;
                    this.y1 = f5 + f7;
                    bl = false;
                }
                if (f5 < this.y2) {
                    this.y2 = f5;
                }
                if (f5 + f7 > this.y1) {
                    this.y1 = f5 + f7;
                }
            }
            if (this.renderText) {
                this.textAreas.addElement(new Rectangle((int)f4, (int)f5, (int)f6, (int)f7));
                this.textDirections.addElement(this.currentTextState.writingMode);
            }
        }
        return bl;
    }

    private static int readEscapeValue(int n, int n2, int n3, byte[] byArray) {
        int n4 = 0;
        if (n3 == 8) {
            int n5 = 0;
            for (int i = 1; i < n2 + 1; ++i) {
                int n6 = byArray[n + n2 - i];
                if (n6 < 48 || n6 > 55) continue;
                n4 += (n6 -= 48) << multiply8[n5];
                ++n5;
            }
        } else if (n3 == 16) {
            int n7 = 0;
            for (int i = 1; i < n2 + 1; ++i) {
                int n8 = byArray[n + n2 - i];
                if (n8 >= 65 && n8 <= 70) {
                    n8 -= 55;
                } else if (n8 >= 97 && n8 <= 102) {
                    n8 -= 87;
                } else {
                    if (n8 < 48 || n8 > 57) continue;
                    n8 -= 48;
                }
                n4 += n8 << multiply16[n7];
                ++n7;
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer(10);
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append((char)byArray[n + i]);
            }
            n4 = Integer.parseInt(stringBuffer.toString(), n3);
        }
        return n4;
    }

    void storeExtractedText(String string, StringBuffer stringBuffer, int n, String string2) {
        if (this.textExtracted) {
            this.pdfData.addRawTextElement(this.charSpacing * 1000.0f, this.currentTextState.writingMode, Fonts.createFontToken(string2, n), this.currentFontData.getCurrentFontSpaceWidth(), n, this.x1, this.y1, this.x2, this.y2, this.moveCommand, stringBuffer, this.textLength, string, this.isXMLExtraction);
        }
    }

    public boolean isTTHintingRequired() {
        return this.ttHintingRequired;
    }

    public void reset() {
        this.multipleTJs = false;
    }

    public void setReturnText(boolean bl) {
        this.returnText = bl;
    }

    public void setParameters(boolean bl, boolean bl2, int n, int n2, boolean bl3) {
        super.setParameters(bl, bl2, n, n2);
        this.isPrinting = bl3;
        this.textExtracted = (n2 & 1) == 1;
        this.renderText = bl2 && (n & 1) == 1;
        this.textColorExtracted = (n2 & 0x40) == 64;
    }

    public void setBooleanValue(int n, boolean bl) {
        switch (n) {
            case 21: {
                this.generateGlyphOnRender = bl;
                break;
            }
            default: {
                super.setBooleanValue(n, bl);
            }
        }
    }

    public void setIntValue(int n, int n2) {
        switch (n) {
            case 20: {
                this.textPrint = n2;
                break;
            }
            default: {
                super.setIntValue(n, n2);
            }
        }
    }
}

