/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.integration.cpacs;

import de.rcenvironment.core.component.integration.cpacs.CpacsIntegrationHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.gui.workflow.integration.IntegrationHistoryDataItemSubtreeBuilder;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class CpacsIntegrationHistoryDataItemSubtreeBuilder
extends IntegrationHistoryDataItemSubtreeBuilder {
    private static final String STRING_TOOLINPUT = "Tool Input: %s";
    private static final String STRING_TOOLOUTPUT = "Tool Output: %s";
    private static final String STRING_DEFAULT_TOOLINPUT_FILENAME = "toolInput.xml";
    private static final String STRING_DEFAULT_TOOLOUTPUT_FILENAME = "toolOutput.xml";
    private static final String STRING_WITHOUT_TOOLSPECIFIC_FILENAME = "without_toolspec.xml";
    private static final String STRING_WITH_VARIABLES_FILENAME = "with_dyn_inputs.xml";
    private DMBrowserNode intermediateInputsNode;

    public String[] getSupportedHistoryDataItemIdentifier() {
        return new String[]{String.valueOf("de.rcenvironment.integration.cpacs.".replace(".", "\\.")) + ".*"};
    }

    public Serializable deserializeHistoryDataItem(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        return (Serializable)ois.readObject();
    }

    public void buildInitialHistoryDataItemSubtree(Serializable historyDataItem, DMBrowserNode parent) {
        super.buildInitialHistoryDataItemSubtree(historyDataItem, parent);
        ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        TypedDatumSerializer serializer = ((TypedDatumService)registryAccess.getService(TypedDatumService.class)).getSerializer();
        if (historyDataItem instanceof String) {
            CpacsIntegrationHistoryDataItem historyData;
            try {
                historyData = CpacsIntegrationHistoryDataItem.fromString((String)((String)((Object)historyDataItem)), (TypedDatumSerializer)serializer, (String)"");
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            if (historyData.getCpacsWithVariablesFileReference() != null || historyData.getToolInputWithoutToolspecificFileReference() != null) {
                this.intermediateInputsNode = DMBrowserNode.addNewChildNode((String)"Intermediate Inputs", (DMBrowserNodeType)DMBrowserNodeType.IntermediateInputsFolder, (DMBrowserNode)parent);
                if (historyData.getCpacsWithVariablesFileReference() != null) {
                    DMBrowserNode cpacsWithVariablesNode = DMBrowserNode.addNewLeafNode((String)StringUtils.format((String)"XML w/ dyn. inputs: %s", (Object[])new Object[]{STRING_WITH_VARIABLES_FILENAME}), (DMBrowserNodeType)DMBrowserNodeType.DMFileResource, (DMBrowserNode)this.intermediateInputsNode);
                    cpacsWithVariablesNode.setAssociatedFilename(STRING_WITH_VARIABLES_FILENAME);
                    cpacsWithVariablesNode.setDataReferenceId(historyData.getCpacsWithVariablesFileReference());
                }
                if (historyData.getToolInputWithoutToolspecificFileReference() != null) {
                    DMBrowserNode toolInputWithoutToolSpecificNode = DMBrowserNode.addNewLeafNode((String)StringUtils.format((String)"Tool Input w/o static tool specifics: %s", (Object[])new Object[]{STRING_WITHOUT_TOOLSPECIFIC_FILENAME}), (DMBrowserNodeType)DMBrowserNodeType.DMFileResource, (DMBrowserNode)this.intermediateInputsNode);
                    toolInputWithoutToolSpecificNode.setAssociatedFilename(STRING_WITHOUT_TOOLSPECIFIC_FILENAME);
                    toolInputWithoutToolSpecificNode.setDataReferenceId(historyData.getToolInputWithoutToolspecificFileReference());
                }
            }
            if (historyData.getToolInputFileReference() != null || historyData.getToolOutputFileReference() != null) {
                DMBrowserNode toolFilesNode = DMBrowserNode.addNewChildNode((String)"Tool Input/Output", (DMBrowserNodeType)DMBrowserNodeType.ToolInputOutputFolder, (DMBrowserNode)parent);
                if (historyData.getToolInputFileReference() != null) {
                    String toolInputFileName = historyData.getToolInputFilename();
                    if (toolInputFileName == null) {
                        toolInputFileName = STRING_DEFAULT_TOOLINPUT_FILENAME;
                    }
                    DMBrowserNode toolInputNode = DMBrowserNode.addNewLeafNode((String)StringUtils.format((String)STRING_TOOLINPUT, (Object[])new Object[]{toolInputFileName}), (DMBrowserNodeType)DMBrowserNodeType.DMFileResource, (DMBrowserNode)toolFilesNode);
                    toolInputNode.setAssociatedFilename(toolInputFileName);
                    toolInputNode.setDataReferenceId(historyData.getToolInputFileReference());
                }
                if (historyData.getToolOutputFileReference() != null) {
                    String toolOutputFileName = historyData.getToolOutputFilename();
                    if (toolOutputFileName == null) {
                        toolOutputFileName = STRING_DEFAULT_TOOLOUTPUT_FILENAME;
                    }
                    DMBrowserNode toolOutputNode = DMBrowserNode.addNewLeafNode((String)StringUtils.format((String)STRING_TOOLOUTPUT, (Object[])new Object[]{toolOutputFileName}), (DMBrowserNodeType)DMBrowserNodeType.DMFileResource, (DMBrowserNode)toolFilesNode);
                    toolOutputNode.setAssociatedFilename(toolOutputFileName);
                    toolOutputNode.setDataReferenceId(historyData.getToolOutputFileReference());
                }
            }
        }
    }
}

