/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.session.internal;

import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.BooleanParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandModifierInfo;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.IntegerParameter;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.ParsedBooleanParameter;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedIntegerParameter;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.command.spi.StringParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.communication.sshconnection.SshConnectionContext;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionService;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionSetup;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class SshUplinkConnectionSetupCommandPlugin
implements CommandPlugin {
    private static final String CONNECTION_WITH_ID = "connection with id ";
    private static final String CMD_SSH_UPLINK = "uplink";
    private static final String DESC = " list\" to get the id)";
    private static final StringParameter ID_PARAMETER = new StringParameter(null, "id", "id of the uplink");
    private static final StringParameter DISPLAY_NAME_PRAMETER = new StringParameter(null, "display name", "display name");
    private static final StringParameter HOST_IP_PARAMETER = new StringParameter(null, "host", "host ip adress");
    private static final IntegerParameter PORT_PARAMETER = new IntegerParameter(Integer.valueOf(0), "port", "port for the ssh connection");
    private static final StringParameter USERNAME_PARAMETER = new StringParameter(null, "username", "username");
    private static final StringParameter KEYFILE_LOCATION_PARAMETER = new StringParameter(null, "key file location", "location of the keyfile");
    private static final StringParameter CLIENT_ID_PARAMETER = new StringParameter(null, "client id", "id of the client");
    private static final BooleanParameter IS_GATEWAY_PARAMETER = new BooleanParameter(Boolean.valueOf(false), "is gateway", "controls the isGateway property of the uplink");
    @Reference
    private SshUplinkConnectionService sshConnectionService;

    private void performAdd(final CommandContext context) {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter displayNameParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        ParsedStringParameter hostIpParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(1);
        ParsedIntegerParameter portParameter = (ParsedIntegerParameter)modifiers.getPositionalCommandParameter(2);
        ParsedStringParameter usernameParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(3);
        ParsedStringParameter keyfileLocationParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(4);
        ParsedStringParameter clientIdParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(5);
        ParsedBooleanParameter isGatewayParameter = (ParsedBooleanParameter)modifiers.getPositionalCommandParameter(6);
        String connectionName = displayNameParameter.getResult();
        String host = hostIpParameter.getResult();
        int port = portParameter.getResult();
        String username = usernameParameter.getResult();
        String keyfileLocation = keyfileLocationParameter.getResult();
        boolean isGateway = isGatewayParameter.getResult();
        String clientId = clientIdParameter.getResult();
        final SshConnectionContext contextUplinkSSH = new SshConnectionContext(null, connectionName, clientId, host, port, username, keyfileLocation, false, false, false, isGateway);
        if (this.sshConnectionService.sshUplinkConnectionAlreadyExists(contextUplinkSSH)) {
            context.println((Object)StringUtils.format((String)"Connection setup to host '%s:%d' already exists.", (Object[])new Object[]{contextUplinkSSH.getDestinationHost(), contextUplinkSSH.getPort()}));
            return;
        }
        ConcurrencyUtils.getAsyncTaskService().execute("Create new Uplink Connection.", new Runnable(){

            @Override
            public void run() {
                String id = SshUplinkConnectionSetupCommandPlugin.this.sshConnectionService.addSshUplinkConnection(contextUplinkSSH);
                context.println((Object)("Added Uplink connection setup, created id " + id));
            }
        });
    }

    private void performList(CommandContext context) {
        Collection<SshUplinkConnectionSetup> setups = this.sshConnectionService.getAllSshConnectionSetups();
        for (SshUplinkConnectionSetup setup : setups) {
            context.println((Object)StringUtils.format((String)"%s: %s:%s username: %s, keyfile: %s clientId: %s isGateway: %s (id: %s) CONNECTED: %s", (Object[])new Object[]{setup.getDisplayName(), setup.getHost(), setup.getPort(), setup.getUsername(), setup.getKeyfileLocation(), setup.getQualifier(), setup.isGateway(), setup.getId(), setup.isConnected()}));
        }
    }

    private void performStart(final CommandContext context) {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter connectionIdParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        final String connectionId = connectionIdParameter.getResult();
        ConcurrencyUtils.getAsyncTaskService().execute("Start SSH Connection.", new Runnable(){

            @Override
            public void run() {
                if (SshUplinkConnectionSetupCommandPlugin.this.sshConnectionService.getConnectionSetup(connectionId) == null) {
                    context.println((Object)(SshUplinkConnectionSetupCommandPlugin.CONNECTION_WITH_ID + connectionId + " does not exist."));
                } else if (SshUplinkConnectionSetupCommandPlugin.this.sshConnectionService.getConnectionSetup(connectionId).isConnected()) {
                    context.println((Object)(SshUplinkConnectionSetupCommandPlugin.CONNECTION_WITH_ID + connectionId + "is already connected."));
                } else {
                    SshUplinkConnectionSetupCommandPlugin.this.sshConnectionService.connectSession(connectionId);
                }
            }
        });
    }

    private void performStop(final CommandContext context) {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter connectionIdParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        final String connectionId = connectionIdParameter.getResult();
        ConcurrencyUtils.getAsyncTaskService().execute("Start SSH Connection.", new Runnable(){

            @Override
            public void run() {
                if (SshUplinkConnectionSetupCommandPlugin.this.sshConnectionService.getConnectionSetup(connectionId) != null) {
                    SshUplinkConnectionSetupCommandPlugin.this.sshConnectionService.disconnectSession(connectionId);
                } else {
                    context.println((Object)(SshUplinkConnectionSetupCommandPlugin.CONNECTION_WITH_ID + connectionId + " does not exist."));
                }
            }
        });
    }

    public MainCommandDescription[] getCommands() {
        MainCommandDescription commands = new MainCommandDescription(CMD_SSH_UPLINK, "manage uplink connections", "short form for \"uplink list\"", this::performList, new SubCommandDescription[]{new SubCommandDescription("add", "add a new uplink connection", this::performAdd, new CommandModifierInfo(new AbstractCommandParameter[]{DISPLAY_NAME_PRAMETER, HOST_IP_PARAMETER, PORT_PARAMETER, USERNAME_PARAMETER, KEYFILE_LOCATION_PARAMETER, CLIENT_ID_PARAMETER, IS_GATEWAY_PARAMETER})), new SubCommandDescription("list", "lists all uplink connections, including ids and connection states", this::performList), new SubCommandDescription("start", "starts/connects an uplink connection (use \" uplink list\" to get the id)", this::performStart, new CommandModifierInfo(new AbstractCommandParameter[]{ID_PARAMETER})), new SubCommandDescription("stop", "stops/disconnects an uplink connection (use \" uplink list\" to get the id)", this::performStop, new CommandModifierInfo(new AbstractCommandParameter[]{ID_PARAMETER}))});
        return new MainCommandDescription[]{commands};
    }
}

