/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap;

import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;

public final class BundleTracker
implements BundleListener {
    private final Log log = LogFactory.getLog(BundleTracker.class);

    private BundleTracker() {
    }

    public static void install() {
        BundleContext context = FrameworkUtil.getBundle(BundleTracker.class).getBundleContext();
        context.addBundleListener((BundleListener)new BundleTracker());
        Log tempLog = LogFactory.getLog(BundleTracker.class);
        tempLog.debug((Object)"Bundles in state ACTIVE (already STARTED) at BundleTracker initialization:");
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getState() == 32) {
                tempLog.debug((Object)("  " + b));
            }
            ++n2;
        }
    }

    public void bundleChanged(BundleEvent event) {
        String eventDescription;
        switch (event.getType()) {
            case 1: {
                eventDescription = "INSTALLED";
                break;
            }
            case 32: {
                eventDescription = "RESOLVED";
                break;
            }
            case 128: {
                eventDescription = "STARTING";
                break;
            }
            case 2: {
                eventDescription = "STARTED";
                break;
            }
            case 256: {
                eventDescription = "STOPPING";
                break;
            }
            case 4: {
                eventDescription = "STOPPED";
                break;
            }
            case 16: {
                eventDescription = "UNINSTALLED";
                break;
            }
            case 8: {
                eventDescription = "UPDATED";
                break;
            }
            case 64: {
                eventDescription = "UNRESOLVED";
                break;
            }
            default: {
                eventDescription = "[other event: " + event.getType() + "]";
            }
        }
        String message = StringUtils.format((String)"%s: %s", (Object[])new Object[]{eventDescription, event.getBundle()});
        if (event.getBundle() != event.getOrigin()) {
            message = String.valueOf(message) + ", origin=" + event.getOrigin();
        }
        this.log.debug((Object)message);
    }
}

