/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.introspection.setup;

import de.rcenvironment.toolkit.core.api.ImmutableServiceRegistry;
import de.rcenvironment.toolkit.core.spi.module.AbstractZeroConfigurationToolkitModule;
import de.rcenvironment.toolkit.core.spi.module.ObjectGraph;
import de.rcenvironment.toolkit.core.spi.module.ShutdownHookReceiver;
import de.rcenvironment.toolkit.core.spi.module.ToolkitModule;
import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionRegistry;
import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionService;
import de.rcenvironment.toolkit.modules.introspection.internal.StatusCollectionServiceImpl;
import de.rcenvironment.toolkit.utils.text.MultiLineOutput;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntrospectionModule
extends AbstractZeroConfigurationToolkitModule {
    public void registerMembers(ObjectGraph objectGraph) {
        objectGraph.registerServiceClass(StatusCollectionServiceImpl.class);
    }

    public void suggestMissingModuleDependencies(ObjectGraph objectGraph, Set<Class<? extends ToolkitModule<?>>> modulesToLoad) {
        if (objectGraph.isMissingService(StatusCollectionRegistry.class)) {
            modulesToLoad.add(IntrospectionModule.class);
        }
    }

    public void registerShutdownHooks(ImmutableServiceRegistry serviceRegistry, ShutdownHookReceiver shutdownHookReceiver) {
        final StatusCollectionService statusCollectionService = (StatusCollectionService)serviceRegistry.getService(StatusCollectionService.class);
        shutdownHookReceiver.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                Log log = LogFactory.getLog(this.getClass());
                log.debug((Object)statusCollectionService.getCollectedDefaultStateInformation().asMultilineString("Final state information:", "  ", "\n", null));
                MultiLineOutput unfinishedOperationsReport = statusCollectionService.getCollectedUnfinishedOperationsInformation();
                if (unfinishedOperationsReport.hasContent()) {
                    log.debug((Object)unfinishedOperationsReport.asMultilineString("Known unfinished operations on shutdown:", "  ", "\n", null));
                } else {
                    log.debug((Object)"Known unfinished operations on shutdown: <none>");
                }
            }
        });
    }
}

