/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.embedded.ssh.api.SshAccount;
import de.rcenvironment.core.embedded.ssh.api.TemporarySshAccount;
import de.rcenvironment.core.embedded.ssh.api.TemporarySshAccountControl;
import de.rcenvironment.core.embedded.ssh.internal.IncomingSessionTracker;
import de.rcenvironment.core.embedded.ssh.internal.SshAccountImpl;
import de.rcenvironment.core.embedded.ssh.internal.SshAccountRole;
import de.rcenvironment.core.embedded.ssh.internal.SshConfiguration;
import de.rcenvironment.core.embedded.ssh.internal.TemporarySshAccountImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.mindrot.jbcrypt.BCrypt;

public class SshAuthenticationManager
implements PasswordAuthenticator,
TemporarySshAccountControl,
PublickeyAuthenticator {
    private static final String REFUSAL_REASON_UNDEFINED = "<undefined>";
    private static final String REFUSAL_REASON_EMPTY_LOGIN_NAME = "empty login name";
    private static final String REFUSAL_REASON_INVALID_ACCOUNT = "invalid account";
    private static final String REFUSAL_REASON_EMPTY_PASSWORD = "empty password";
    private static final String REFUSAL_REASON_WRONG_PASSWORD = "wrong password";
    private static final String REFUSAL_REASON_NO_MATCHING_KEY = "no matching key";
    private static final String EVENT_LOG_VALUE_AUTH_METHOD_PASSWORD = "password";
    private static final String EVENT_LOG_VALUE_AUTH_METHOD_PUBLIC_KEY = "publickey";
    private final SshConfiguration configuration;
    private final IncomingSessionTracker<Session> sessionTracker;
    private final int numAllowedLoginAttempts;
    private List<TemporarySshAccount> temporaryAccounts;
    private final Log log = LogFactory.getLog(this.getClass());

    public SshAuthenticationManager(SshConfiguration configuration, IncomingSessionTracker<Session> sessionTracker, int numAllowedLoginAttempts) {
        this.configuration = configuration;
        this.sessionTracker = sessionTracker;
        this.numAllowedLoginAttempts = numAllowedLoginAttempts;
    }

    public boolean authenticate(String loginName, String passwordParam, ServerSession session) {
        boolean success = false;
        String refusalReason = REFUSAL_REASON_UNDEFINED;
        if (passwordParam == null || passwordParam.isEmpty()) {
            refusalReason = REFUSAL_REASON_EMPTY_PASSWORD;
        } else if (loginName == null || loginName.isEmpty()) {
            refusalReason = REFUSAL_REASON_EMPTY_LOGIN_NAME;
        } else if (loginName.startsWith("t_")) {
            refusalReason = "unsupported temp user";
        } else {
            SshAccount account = this.configuration.getAccountByName(loginName, false);
            if (account != null) {
                if (this.checkPassword(account, passwordParam)) {
                    success = true;
                } else {
                    refusalReason = REFUSAL_REASON_WRONG_PASSWORD;
                }
            } else {
                refusalReason = REFUSAL_REASON_INVALID_ACCOUNT;
            }
        }
        this.registerAuthResult(session, loginName, EVENT_LOG_VALUE_AUTH_METHOD_PASSWORD, success, refusalReason);
        if (!success && session != null && this.sessionTracker != null) {
            this.closeConnectionIfAuthAttemptsExceeded(session);
        }
        return success;
    }

    public boolean authenticate(String loginName, PublicKey key, ServerSession session) {
        boolean success = false;
        String refusalReason = REFUSAL_REASON_UNDEFINED;
        if (loginName == null || loginName.isEmpty()) {
            refusalReason = REFUSAL_REASON_EMPTY_LOGIN_NAME;
        } else {
            SshAccount account = this.configuration.getAccountByName(loginName, false);
            if (account != null) {
                PublicKey knownKey = account.getPublicKeyObj();
                if (knownKey != null) {
                    success = Arrays.equals(key.getEncoded(), knownKey.getEncoded());
                }
                if (!success) {
                    refusalReason = REFUSAL_REASON_NO_MATCHING_KEY;
                }
            } else {
                refusalReason = REFUSAL_REASON_INVALID_ACCOUNT;
            }
        }
        if (session != null) {
            this.registerAuthResult(session, loginName, EVENT_LOG_VALUE_AUTH_METHOD_PUBLIC_KEY, success, refusalReason);
        } else if (!RuntimeDetection.isTestEnvironment()) {
            throw new IllegalStateException("SSH session is null while apparently not in a test context");
        }
        if (!success && session != null && this.sessionTracker != null) {
            this.closeConnectionIfAuthAttemptsExceeded(session);
        }
        return success;
    }

    private void registerAuthResult(ServerSession session, String loginName, String method, boolean success, String refusalReason) {
        if (session == null || this.sessionTracker == null) {
            if (!RuntimeDetection.isTestEnvironment()) {
                throw new IllegalStateException("SSH session or session tracker null (" + session + "/" + this.sessionTracker + ") while apparently outside of a test context");
            }
            return;
        }
        try {
            if (success) {
                this.sessionTracker.forSession((Session)session).registerAuthenticationSuccess(loginName, method);
            } else {
                this.sessionTracker.forSession((Session)session).registerAuthenticationFailure(loginName, method, refusalReason);
            }
        }
        catch (OperationFailureException e) {
            this.log.warn((Object)("Failed to log authentication result (success=" + success + "): " + e.getMessage()));
        }
    }

    private void closeConnectionIfAuthAttemptsExceeded(ServerSession session) {
        int authenticationFailureCount;
        String logId = session.toString();
        try {
            authenticationFailureCount = this.sessionTracker.forSession((Session)session).getAuthenticationFailureCount();
        }
        catch (OperationFailureException operationFailureException) {
            this.log.warn((Object)("Failed to query incoming SSH session " + logId + " for its login failure count; this is possible, but unusual in normal operation"));
            return;
        }
        if (authenticationFailureCount >= this.numAllowedLoginAttempts) {
            this.log.debug((Object)("Closing incoming SSH connection " + logId + " after " + authenticationFailureCount + " failed authentication attempts"));
            try {
                session.close();
            }
            catch (IOException e) {
                this.log.error((Object)"Failed to close", (Throwable)e);
            }
        }
    }

    public boolean isAllowedToExecuteConsoleCommand(String username, String command) {
        boolean isAllowed = false;
        SshAccountRole userRole = this.getRoleForUser(username);
        try {
            if (userRole != null) {
                boolean commandIsOnWhitelist = command.matches(userRole.getAllowedCommandRegEx());
                boolean commandIsOnBlacklist = command.matches(userRole.getDisallowedCommandRegEx());
                if (commandIsOnWhitelist && !commandIsOnBlacklist) {
                    isAllowed = true;
                }
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.log.error((Object)("Could not verify if user " + username + " is allowed to execute command " + command + ". Probable cause: The allowed commands pattern is invalid."));
        }
        return isAllowed;
    }

    public boolean isAllowedToUseScpDestination(String username, String destination) {
        boolean isAllowed = false;
        TemporarySshAccount tempUser = this.getTemporaryAccountByName(username);
        if (tempUser != null) {
            isAllowed = destination != null && destination.startsWith(tempUser.getVirtualScpRootPath()) && !destination.contains("../") && !destination.contains("..\\");
        }
        return isAllowed;
    }

    public boolean isAllowedToOpenShell(String username) {
        return this.getRoleForUser(username).isAllowedToOpenShell();
    }

    public boolean isAllowedToUseUplink(String username) {
        return this.getRoleForUser(username).isAllowedToUseUplink();
    }

    @Deprecated
    public boolean isTemporaryAccountName(String username) {
        return this.getTemporaryAccountByName(username) != null;
    }

    private SshAccountRole getRoleForUser(String userName) {
        SshAccount user = this.configuration.getAccountByName(userName, true);
        SshAccountRole role = null;
        if (user != null) {
            role = this.configuration.getRoleByName(user.getRole());
        }
        return role;
    }

    public SshAccount getAccountByLoginName(String loginName, boolean allowDisabled) {
        return this.configuration.getAccountByName(loginName, allowDisabled);
    }

    public SortedMap<String, SshAccount> getStaticAccountsByLoginName() {
        TreeMap<String, SshAccount> result = new TreeMap<String, SshAccount>();
        for (SshAccountImpl a : this.configuration.getStaticAccounts()) {
            result.put(a.getLoginName(), a);
        }
        return result;
    }

    @Deprecated
    public TemporarySshAccount getTemporaryAccountByName(String name) {
        TemporarySshAccount result = null;
        if (this.temporaryAccounts != null) {
            for (TemporarySshAccount tempUser : this.temporaryAccounts) {
                if (!tempUser.getLoginName().equals(name)) continue;
                result = tempUser;
            }
        }
        return result;
    }

    @Deprecated
    public List<TemporarySshAccount> getTemporaryAccounts() {
        return this.temporaryAccounts;
    }

    @Deprecated
    public void setTemporaryAccounts(List<TemporarySshAccount> tempUsers) {
        this.temporaryAccounts = tempUsers;
    }

    @Override
    @Deprecated
    public TemporarySshAccount createTemporarySshAccount() {
        if (this.temporaryAccounts == null) {
            this.temporaryAccounts = new CopyOnWriteArrayList<TemporarySshAccount>();
        }
        TemporarySshAccountImpl tempAccount = new TemporarySshAccountImpl();
        String randomAccountNamePart = RandomStringUtils.randomAlphanumeric((int)6);
        String username = "t_" + randomAccountNamePart;
        tempAccount.setLoginName(username);
        tempAccount.setPassword(RandomStringUtils.randomAlphanumeric((int)6));
        tempAccount.setVirtualScpRootPath("/temp/" + username);
        try {
            tempAccount.setLocalScpRootPath(TempFileServiceAccess.getInstance().createManagedTempDir("temp-scp-" + randomAccountNamePart));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary SCP directory", e);
        }
        this.log.debug((Object)StringUtils.format((String)"Created temporary SCP account '%s' with virtual SCP path '%s' mapped to local path '%s'", (Object[])new Object[]{tempAccount.getLoginName(), tempAccount.getVirtualScpRootPath(), tempAccount.getLocalScpRootPath().getAbsolutePath()}));
        this.temporaryAccounts.add(tempAccount);
        return tempAccount;
    }

    @Override
    @Deprecated
    public void discardTemporarySshAccount(String name) {
        int i = 0;
        while (i < this.temporaryAccounts.size()) {
            TemporarySshAccount tempUser = this.temporaryAccounts.get(i);
            if (tempUser.getLoginName().equals(name)) {
                this.temporaryAccounts.remove(i);
            }
            ++i;
        }
    }

    private boolean checkPassword(SshAccount account, String password) {
        if (account.getPasswordHash() != null) {
            boolean result = BCrypt.checkpw((String)password, (String)account.getPasswordHash());
            this.log.debug((Object)StringUtils.format((String)"Used password hash to check login attempt for user \"%s\" - accepted = %s", (Object[])new Object[]{account.getLoginName(), result}));
            return result;
        }
        if (account.getPassword() != null) {
            boolean result = account.getPassword().equals(password);
            this.log.warn((Object)StringUtils.format((String)"Used clear-text password to check login attempt for user \"%s\" - accepted = %s", (Object[])new Object[]{account.getLoginName(), result}));
            return result;
        }
        this.log.error((Object)("Consistency error: SSH login attempt with a password for user \"" + account.getLoginName() + "\", but the local account has neither a clear-text nor a hashed password"));
        return false;
    }
}

