/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.common;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeId;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.common.NodeIdentifierContextHolder;
import java.util.Objects;
import org.apache.commons.logging.LogFactory;

public final class NodeIdentifierUtils {
    private NodeIdentifierUtils() {
    }

    public static InstanceNodeId parseInstanceNodeIdString(String input) throws IdentifierException {
        return NodeIdentifierUtils.getNodeIdentifierServiceForCurrentThread().parseInstanceNodeIdString(input);
    }

    public static InstanceNodeId parseInstanceNodeIdStringWithExceptionWrapping(String input) {
        try {
            return NodeIdentifierUtils.parseInstanceNodeIdString(input);
        }
        catch (IdentifierException e) {
            throw NodeIdentifierUtils.wrapIdentifierException(e);
        }
    }

    public static InstanceNodeSessionId parseInstanceNodeSessionIdString(String input) throws IdentifierException {
        return NodeIdentifierUtils.getNodeIdentifierServiceForCurrentThread().parseInstanceNodeSessionIdString(input);
    }

    public static InstanceNodeSessionId parseInstanceNodeSessionIdStringWithExceptionWrapping(String input) {
        try {
            return NodeIdentifierUtils.parseInstanceNodeSessionIdString(input);
        }
        catch (IdentifierException e) {
            throw NodeIdentifierUtils.wrapIdentifierException(e);
        }
    }

    public static LogicalNodeId parseLogicalNodeIdString(String input) throws IdentifierException {
        return NodeIdentifierUtils.getNodeIdentifierServiceForCurrentThread().parseLogicalNodeIdString(input);
    }

    public static LogicalNodeId parseLogicalNodeIdStringWithExceptionWrapping(String input) {
        try {
            return NodeIdentifierUtils.parseLogicalNodeIdString(input);
        }
        catch (IdentifierException e) {
            throw NodeIdentifierUtils.wrapIdentifierException(e);
        }
    }

    public static LogicalNodeId parseArbitraryIdStringToLogicalNodeId(String input) throws IdentifierException {
        Objects.requireNonNull(input, "Cannot parse 'null' string to a node identifier");
        int length = input.length();
        if (length == 32) {
            return NodeIdentifierUtils.parseInstanceNodeIdString(input).convertToDefaultLogicalNodeId();
        }
        if (length == 44) {
            return NodeIdentifierUtils.parseInstanceNodeSessionIdString(input).convertToDefaultLogicalNodeId();
        }
        int pos = input.lastIndexOf(":");
        if (pos == 32) {
            return NodeIdentifierUtils.parseLogicalNodeIdString(input);
        }
        if (pos < 0) {
            throw new IdentifierException("Unexpected state while trying to parse arbitrary id string '" + input + "'");
        }
        return NodeIdentifierUtils.parseLogicalNodeSessionIdString(input).convertToLogicalNodeId();
    }

    public static LogicalNodeId parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping(String input) {
        try {
            return NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeId(input);
        }
        catch (IdentifierException e) {
            throw NodeIdentifierUtils.wrapIdentifierException(e);
        }
    }

    public static LogicalNodeSessionId parseLogicalNodeSessionIdString(String input) throws IdentifierException {
        return NodeIdentifierUtils.getNodeIdentifierServiceForCurrentThread().parseLogicalNodeSessionIdString(input);
    }

    public static RuntimeException wrapIdentifierException(IdentifierException e) {
        LogFactory.getLog(NodeIdentifierUtils.class).error((Object)"Wrapping IdentifierException for backwards compatibility", (Throwable)e);
        return new RuntimeException("Wrapping identifier exception for backwards compatibility", e);
    }

    private static NodeIdentifierService getNodeIdentifierServiceForCurrentThread() {
        return NodeIdentifierContextHolder.getDeserializationServiceForCurrentThread();
    }
}

