/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.testutils;

import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.testutils.ThroughputLimiter;
import java.util.Random;
import org.apache.commons.logging.LogFactory;

public class SimpleThroughputLimiter
implements ThroughputLimiter {
    private static final int MSEC_TO_SEC_FACTOR = 1000;
    private static final float FALLBACK_VALUE_THROUGHPUT_STATISTICS = -1.0f;
    private static final int MAX_INCREMENT_AND_COUNTER = 0x3FFFFFFE;
    private final int waitEveryNBytes;
    private final int waitDurationMsec;
    private int trafficCounter;
    private long statsCreationTimestamp;
    private long statsTotalBytes;
    private int statsNumInterrupts;
    private String verboseLoggingPrefix;

    public SimpleThroughputLimiter(int waitEveryNBytes, int waitDurationMsec) {
        if (waitEveryNBytes <= 0 || waitEveryNBytes > 0x3FFFFFFE || waitDurationMsec <= 0) {
            throw new IllegalArgumentException();
        }
        this.waitEveryNBytes = waitEveryNBytes;
        this.waitDurationMsec = waitDurationMsec;
        this.trafficCounter = new Random().nextInt(waitEveryNBytes);
        this.statsCreationTimestamp = System.currentTimeMillis();
    }

    @Override
    public synchronized void beforeTraffic(int numBytes) {
        if (numBytes == 0) {
            return;
        }
        if (numBytes <= 0 || numBytes > 0x3FFFFFFE) {
            throw new IllegalArgumentException(Integer.toString(numBytes));
        }
        this.statsTotalBytes += (long)numBytes;
        this.trafficCounter += numBytes;
        while (this.trafficCounter > this.waitEveryNBytes) {
            this.trafficCounter -= this.waitEveryNBytes;
            try {
                if (this.verboseLoggingPrefix != null) {
                    LogFactory.getLog(this.getClass()).debug((Object)StringUtils.format("%sThrottling connection for %d msec after a total of %d bytes of traffic (last delta: %d bytes)", this.verboseLoggingPrefix, this.waitDurationMsec, this.statsTotalBytes, numBytes));
                }
                Thread.sleep(this.waitDurationMsec);
                ++this.statsNumInterrupts;
            }
            catch (InterruptedException interruptedException) {
                LogFactory.getLog(this.getClass()).debug((Object)"Interrupted while waiting for throughput limiting");
            }
        }
    }

    @Override
    public synchronized String getStatisticsLine() {
        long lifetimeMsec = System.currentTimeMillis() - this.statsCreationTimestamp;
        float averageThroughput = -1.0f;
        if (lifetimeMsec > 0L) {
            averageThroughput = (float)this.statsTotalBytes / (float)lifetimeMsec * 1000.0f;
        }
        return StringUtils.format("Total traffic: %d bytes, waited for %d times (%d msec total), average throughput since creation: %f bytes/sec", this.statsTotalBytes, this.statsNumInterrupts, this.statsNumInterrupts * this.waitDurationMsec, Float.valueOf(averageThroughput));
    }

    public void enableVerboseLogging(String logPrefix) {
        this.verboseLoggingPrefix = logPrefix;
    }
}

