/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import de.rcenvironment.core.utils.common.InvalidFilenameException;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public final class CrossPlatformFilenameUtils {
    public static final String[] FORBIDDEN_WINDOWS_FILENAMES = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    public static final char[] FORBIDDEN_CHARACTERS = new char[]{'/', '\\', ':', '\"', '*', '?', '<', '>', '|'};
    private static final String[] WINDOWS_FORBIDDEN_FILENAME_PATTERNS = new String[]{"\\x00-\\x1F", "\\x7F", "\\t", "\\n", "\\f", "\\r"};
    private static final String[] FORBIDDEN_REGEX = new String[]{".*\\.+$"};
    private static final int MAXIMUM_FILENAME_LENGTH = 240;
    private static final String FORWARD_SLASH = "/";
    private static Pattern forbiddenCharacterPattern;
    private static Pattern forbiddenFilenamePattern;
    private static Pattern nfsFilePattern;

    static {
        String regExp = "[".concat(new String(FORBIDDEN_CHARACTERS));
        regExp = regExp.concat(org.apache.commons.lang3.StringUtils.join((Object[])WINDOWS_FORBIDDEN_FILENAME_PATTERNS));
        regExp = regExp.concat("]");
        forbiddenCharacterPattern = Pattern.compile(regExp);
        regExp = String.valueOf(FORBIDDEN_WINDOWS_FILENAMES[0]) + "(\\..*)?";
        int i = 1;
        while (i < FORBIDDEN_WINDOWS_FILENAMES.length) {
            regExp = regExp.concat("|" + FORBIDDEN_WINDOWS_FILENAMES[i] + "(\\..*)?");
            ++i;
        }
        String[] stringArray = FORBIDDEN_REGEX;
        int n = FORBIDDEN_REGEX.length;
        int n2 = 0;
        while (n2 < n) {
            String current = stringArray[n2];
            regExp = regExp.concat("|" + current);
            ++n2;
        }
        forbiddenFilenamePattern = Pattern.compile(regExp);
        regExp = "^\\.nfs.+$";
        nfsFilePattern = Pattern.compile(regExp);
    }

    private CrossPlatformFilenameUtils() {
    }

    public static boolean isFilenameValid(String filename) {
        if (filename.length() == 0 || filename.length() > 240) {
            return false;
        }
        return !forbiddenCharacterPattern.matcher(filename).find() && !forbiddenFilenamePattern.matcher(filename).matches();
    }

    public static void throwExceptionIfFilenameNotValid(String filename) throws InvalidFilenameException {
        if (!CrossPlatformFilenameUtils.isFilenameValid(filename)) {
            throw new InvalidFilenameException(filename);
        }
    }

    public static void throwIOExceptionIfFilenameNotValid(String filename) throws IOException {
        if (!CrossPlatformFilenameUtils.isFilenameValid(filename)) {
            throw new IOException(StringUtils.format("The filename %s is not valid on all supported platforms.", filename));
        }
    }

    public static boolean isPathValid(String path) {
        path = FilenameUtils.separatorsToUnix((String)path);
        path = path.replaceAll("(^[a-zA-Z]{1}[:]{1})", "");
        String[] stringArray = path.split(FORWARD_SLASH);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pathSegment = stringArray[n2];
            if (!pathSegment.isEmpty() && !CrossPlatformFilenameUtils.isFilenameValid(pathSegment)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNFSFile(String filename) {
        return nfsFilePattern.matcher(filename).matches();
    }
}

