/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.navigator.CommonViewer;

public class OpenFolderAsProjectAction
extends Action {
    private final IFolder folder;
    private final CommonViewer viewer;

    public OpenFolderAsProjectAction(IFolder folder, CommonViewer viewer) {
        super(WorkbenchNavigatorMessages.OpenProjectAction_OpenExistingProject);
        this.folder = folder;
        this.viewer = viewer;
        this.setDescription(WorkbenchNavigatorMessages.OpenProjectAction_OpenExistingProject_desc);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT"));
    }

    public void run() {
        Job job = Job.create((String)NLS.bind((String)WorkbenchNavigatorMessages.OpenProjectAction_opening, (Object)this.folder.getName()), monitor -> {
            IProject parentProject = this.folder.getProject();
            HashSet<IWorkingSet> parentWorkingSets = new HashSet<IWorkingSet>();
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            IWorkingSet[] iWorkingSetArray = workingSetManager.getWorkingSets();
            int n = iWorkingSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet workingSet = iWorkingSetArray[n2];
                IAdaptable[] iAdaptableArray = workingSet.getElements();
                int n3 = iAdaptableArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable element = iAdaptableArray[n4];
                    if (parentProject.equals(Adapters.adapt((Object)element, IProject.class))) {
                        parentWorkingSets.add(workingSet);
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
            try {
                IProjectDescription desc = ResourcesPlugin.getWorkspace().loadProjectDescription(this.folder.getLocation().append(".project"));
                desc.setLocation(this.folder.getLocation());
                CreateProjectOperation operation = new CreateProjectOperation(desc, desc.getName());
                IStatus status = OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)operation, null, null);
                if (status.isOK()) {
                    IProject newProject = (IProject)operation.getAffectedObjects()[0];
                    workingSetManager.addToWorkingSets((IAdaptable)newProject, parentWorkingSets.toArray(new IWorkingSet[parentWorkingSets.size()]));
                    this.viewer.getTree().getDisplay().asyncExec(() -> {
                        this.viewer.refresh((Object)this.folder.getParent());
                        this.viewer.setSelection((ISelection)new StructuredSelection((Object)newProject));
                    });
                    return Status.OK_STATUS;
                }
                return status;
            }
            catch (ExecutionException ex) {
                return Status.error((String)ex.getMessage(), (Throwable)ex);
            }
            catch (CoreException ex) {
                return ex.getStatus();
            }
        });
        job.setPriority(10);
        job.schedule();
    }
}

