/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.datamanagement.browser.spi;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.datamanagement.commons.DataReference;
import de.rcenvironment.core.datamanagement.commons.MetaData;
import de.rcenvironment.core.datamanagement.commons.MetaDataSet;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.MatrixTD;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.gui.datamanagement.browser.Activator;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Image;

public final class DMBrowserNode {
    private static final AtomicLong TEMP_FILE_SEQUENCE_NUMBER = new AtomicLong(0L);
    private static final List<DMBrowserNode> IMMUTABLE_NO_CHILDREN_LIST = Collections.unmodifiableList(new ArrayList(0));
    private String title;
    private String toolTip;
    private String name;
    private String workflowID;
    private MetaDataSet metaData;
    private DMBrowserNode parent;
    private DMBrowserNodeType type;
    private List<DMBrowserNode> children = null;
    private final Object lockForChildrenAccess = new Object();
    private DataReference dataReference = null;
    private String dataReferenceId = null;
    private String fileContent = null;
    private String fileName = null;
    private String fileReferencePath = null;
    private String associatedFilename = null;
    private String workflowHostName = null;
    private LogicalNodeId workflowHostID = null;
    private Image icon = null;
    private boolean builtForDeletionPurpose = false;
    private Boolean enabled;
    private String cachedPath;
    private DirectoryReferenceTD dirRefTD = null;

    public DMBrowserNode(String title) {
        this.title = title;
        this.enabled = true;
    }

    public DMBrowserNode(String title, DMBrowserNode parent) {
        this.title = title;
        this.enabled = true;
        this.setParent(parent);
    }

    public static DMBrowserNode addNewChildNode(String title, DMBrowserNodeType type, DMBrowserNode parent) {
        DMBrowserNode result = new DMBrowserNode(title, parent);
        result.setBuiltForDeletionPurpose(parent.isBuiltForDeletionPurpose());
        result.setType(type);
        parent.addChild(result);
        return result;
    }

    public static DMBrowserNode addNewLeafNode(String title, DMBrowserNodeType type, DMBrowserNode parent) {
        DMBrowserNode result = new DMBrowserNode(title, parent);
        result.setBuiltForDeletionPurpose(parent.isBuiltForDeletionPurpose());
        result.setType(type);
        result.markAsLeaf();
        parent.addChild(result);
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        if (this.cachedPath != null) {
            return this.cachedPath;
        }
        StringBuilder builder = new StringBuilder();
        DMBrowserNode parentNode = this.getParent();
        if (parentNode != null) {
            builder.append(parentNode.getPath());
        }
        builder.append('/');
        if (this.type != null) {
            switch (this.type) {
                case HistoryRoot: {
                    break;
                }
                case Workflow: {
                    builder.append("workflow:");
                    builder.append(this.workflowID);
                    builder.append("_");
                    builder.append(this.getNodeIdentifier().getInstanceNodeIdString());
                    break;
                }
                default: {
                    builder.append(this.getTitle());
                    break;
                }
            }
        } else {
            builder.append(this.getTitle());
        }
        this.cachedPath = builder.toString();
        return this.cachedPath;
    }

    public DMBrowserNode getParent() {
        return this.parent;
    }

    public DMBrowserNodeType getType() {
        return this.type;
    }

    public void setType(DMBrowserNodeType type) {
        this.type = type;
    }

    public String toString() {
        return this.getTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsLeaf() {
        Object object = this.lockForChildrenAccess;
        synchronized (object) {
            this.children = IMMUTABLE_NO_CHILDREN_LIST;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isLeafNode() {
        Object object = this.lockForChildrenAccess;
        synchronized (object) {
            return this.areChildrenKnown() && this.children.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areChildrenKnown() {
        Object object = this.lockForChildrenAccess;
        synchronized (object) {
            return this.children != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(DMBrowserNode child) {
        Object object = this.lockForChildrenAccess;
        synchronized (object) {
            this.ensureChildListCreated();
            if (this.children == IMMUTABLE_NO_CHILDREN_LIST) {
                throw new IllegalStateException("Parent node for addChild was marked as a leaf before");
            }
            this.children.add(child);
            child.setParent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DMBrowserNode> getChildren() {
        Object object = this.lockForChildrenAccess;
        synchronized (object) {
            this.ensureChildListCreated();
            return Collections.unmodifiableList(this.children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(DMBrowserNode child) {
        Object object = this.lockForChildrenAccess;
        synchronized (object) {
            if (this.children != null && this.children.remove(child)) {
                child.setParent(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChildren() {
        Object object = this.lockForChildrenAccess;
        synchronized (object) {
            this.children = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMBrowserNode[] getChildrenAsArray() {
        Object object = this.lockForChildrenAccess;
        synchronized (object) {
            this.ensureChildListCreated();
            return this.children.toArray(new DMBrowserNode[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortChildren(Comparator<DMBrowserNode> comparator) {
        Object object = this.lockForChildrenAccess;
        synchronized (object) {
            this.ensureChildListCreated();
            Collections.sort(this.children, comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumChildren() {
        Object object = this.lockForChildrenAccess;
        synchronized (object) {
            block4: {
                if (this.children != null) break block4;
                return 0;
            }
            return this.children.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureChildListCreated() {
        Object object = this.lockForChildrenAccess;
        synchronized (object) {
            if (this.children == null) {
                this.children = new ArrayList<DMBrowserNode>();
            }
        }
    }

    public void setMetaData(MetaDataSet mds) {
        this.metaData = mds;
    }

    public MetaDataSet getMetaData() {
        return this.metaData;
    }

    public void setDataReference(DataReference dataReference) {
        this.dataReference = dataReference;
    }

    public DataReference getDataReference() {
        return this.dataReference;
    }

    public void setDirectoryReferenceTD(DirectoryReferenceTD directoryReferenceTD) {
        this.dirRefTD = directoryReferenceTD;
    }

    public DirectoryReferenceTD getDirectoryReferenceTD() {
        return this.dirRefTD;
    }

    @Deprecated
    public void setParent(DMBrowserNode parent) {
        if (this.parent == parent) {
            return;
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = parent;
        this.cachedPath = null;
    }

    public String getDataReferenceId() {
        return this.dataReferenceId;
    }

    public void setDataReferenceId(String dataReferenceId) {
        this.dataReferenceId = dataReferenceId;
    }

    public String getFileReferencePath() {
        if (this.fileReferencePath != null && !new File(this.fileReferencePath).exists()) {
            this.fileReferencePath = null;
        }
        if (this.fileReferencePath == null && this.fileContent != null) {
            this.writeTempFileForFileContent(this.fileName, this.fileContent);
        }
        return this.fileReferencePath;
    }

    private File createTempFileForFileContent(String filename) {
        File tempDir = new File(Activator.getInstance().getBundleSpecificTempDir(), String.valueOf(TEMP_FILE_SEQUENCE_NUMBER.incrementAndGet()));
        tempDir.mkdir();
        File endpointTempDir = new File(tempDir, "endpoints");
        endpointTempDir.mkdir();
        return new File(endpointTempDir, filename);
    }

    private void writeTempFileForFileContent(String filename, String text) {
        File tempFile = null;
        try {
            tempFile = this.createTempFileForFileContent(filename.trim());
            if (!tempFile.exists()) {
                FileUtils.write((File)tempFile, (CharSequence)text);
            }
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)"Failed to create temporary file for node content", (Throwable)e);
            return;
        }
        this.setAssociatedFilename(filename);
        this.setFileReferencePath(tempFile.getAbsolutePath());
    }

    public void setFileReferencePath(String fileReferencePath) {
        this.fileReferencePath = fileReferencePath;
    }

    public String getAssociatedFilename() {
        return this.associatedFilename;
    }

    public void setAssociatedFilename(String associatedFilename) {
        this.associatedFilename = associatedFilename;
    }

    public String getWorkflowHostName() {
        return this.workflowHostName;
    }

    public void setWorkflowHostName(String workflowHostName) {
        this.workflowHostName = workflowHostName;
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public void setWorkflowID(String workflowID) {
        this.workflowID = workflowID;
    }

    public String getWorkflowID() {
        return this.workflowID;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DMBrowserNode)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.getPath().equals(((DMBrowserNode)obj).getPath());
    }

    public DMBrowserNode getNodeWithTypeWorkflow() {
        if (this.getType() == DMBrowserNodeType.Workflow) {
            return this;
        }
        if (this.getParent() != null) {
            return this.getParent().getNodeWithTypeWorkflow();
        }
        return null;
    }

    public ResolvableNodeId getNodeIdentifier() {
        String instanceNodeIdentifier;
        if (this.dataReference != null && this.dataReference.getStorageNodeId() != null) {
            return this.dataReference.getStorageNodeId();
        }
        if (this.metaData != null && (instanceNodeIdentifier = this.metaData.getValue(new MetaData("rce.common.node_id", true, true))) != null) {
            return NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)instanceNodeIdentifier);
        }
        return null;
    }

    public void setBuiltForDeletionPurpose(boolean builtForDeletionPurpose) {
        this.builtForDeletionPurpose = builtForDeletionPurpose;
    }

    public boolean isBuiltForDeletionPurpose() {
        return this.builtForDeletionPurpose;
    }

    public LogicalNodeId getWorkflowControllerNode() {
        return this.workflowHostID;
    }

    public void setWorkflowControllerNode(LogicalNodeId logicalNodeId) {
        this.workflowHostID = logicalNodeId;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areAllChildrenDisabled() {
        Object object = this.lockForChildrenAccess;
        synchronized (object) {
            if (this.children != null) {
                boolean disabled = this.children.size() > 0;
                for (DMBrowserNode bn : this.children) {
                    disabled &= !bn.isEnabled();
                }
                return disabled;
            }
            return false;
        }
    }

    public void setFileContentAndName(String fContent, String fName) {
        this.fileContent = fContent;
        this.fileName = fName;
    }

    public void setSmallTableTDAndFileName(SmallTableTD table, String fName) {
        this.fileName = fName;
        this.writeTempFileForMatrixTD(fName, (TypedDatum)table);
    }

    public void setMatrixTDAndFileName(MatrixTD matrix, String fName) {
        this.fileName = fName;
        this.writeTempFileForMatrixTD(fName, (TypedDatum)matrix);
    }

    public void setVectorTDAndFileName(VectorTD vector, String fName) {
        this.fileName = fName;
        this.writeTempFileForMatrixTD(fName, (TypedDatum)vector);
    }

    private void writeTempFileForMatrixTD(String filename, TypedDatum tableMatrixOrVector) {
        this.setAssociatedFilename(filename);
        File tempFile = null;
        try {
            tempFile = this.createTempFileForFileContent(filename);
            if (tempFile != null && !tempFile.exists()) {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileWriter writer = new FileWriter(tempFile.getAbsoluteFile(), true);){
                    int[] rowAndColumnCount = this.getRowAndColumnCount(tableMatrixOrVector);
                    int row = 0;
                    while (row < rowAndColumnCount[0]) {
                        int column = 0;
                        while (column < rowAndColumnCount[1]) {
                            TypedDatum entry = this.getEntry(row, column, tableMatrixOrVector);
                            if (entry != null) {
                                writer.append(this.getEntry(row, column, tableMatrixOrVector).toString());
                            } else {
                                writer.append(" ");
                            }
                            if (rowAndColumnCount[1] - column > 1) {
                                writer.append(", ");
                            }
                            ++column;
                        }
                        writer.append("\r\n");
                        ++row;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (tempFile != null) {
                this.setFileReferencePath(tempFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)"Failed to create temporary file for node content", (Throwable)e);
            return;
        }
    }

    private int[] getRowAndColumnCount(TypedDatum tableMatrixOrVector) {
        if (tableMatrixOrVector instanceof SmallTableTD) {
            return this.getRowAndColumnCount((SmallTableTD)tableMatrixOrVector);
        }
        if (tableMatrixOrVector instanceof MatrixTD) {
            return this.getRowAndColumnCount((MatrixTD)tableMatrixOrVector);
        }
        if (tableMatrixOrVector instanceof VectorTD) {
            return this.getRowAndColumnCount((VectorTD)tableMatrixOrVector);
        }
        return new int[2];
    }

    private int[] getRowAndColumnCount(SmallTableTD table) {
        return new int[]{table.getRowCount(), table.getColumnCount()};
    }

    private int[] getRowAndColumnCount(MatrixTD matrix) {
        return new int[]{matrix.getRowDimension(), matrix.getColumnDimension()};
    }

    private int[] getRowAndColumnCount(VectorTD vector) {
        int[] nArray = new int[2];
        nArray[1] = vector.getRowDimension();
        return nArray;
    }

    private TypedDatum getEntry(int rowIndex, int columnIndex, TypedDatum tableMatrixOrVector) {
        if (tableMatrixOrVector instanceof SmallTableTD) {
            return this.getEntry(rowIndex, columnIndex, (SmallTableTD)tableMatrixOrVector);
        }
        if (tableMatrixOrVector instanceof MatrixTD) {
            return this.getEntry(rowIndex, columnIndex, (MatrixTD)tableMatrixOrVector);
        }
        if (tableMatrixOrVector instanceof VectorTD) {
            return this.getEntry(rowIndex, columnIndex, (VectorTD)tableMatrixOrVector);
        }
        return null;
    }

    private TypedDatum getEntry(int rowIndex, int columnIndex, SmallTableTD table) {
        return table.getTypedDatumOfCell(rowIndex, columnIndex);
    }

    private TypedDatum getEntry(int rowIndex, int columnIndex, MatrixTD matrix) {
        return matrix.getFloatTDOfElement(rowIndex, columnIndex);
    }

    private TypedDatum getEntry(int rowIndex, int columnIndex, VectorTD vector) {
        return vector.getFloatTDOfElement(rowIndex);
    }
}

