/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.scripting.internal;

import de.rcenvironment.core.scripting.ScriptingService;
import de.rcenvironment.core.scripting.ScriptingUtils;
import de.rcenvironment.core.scripting.python.PythonScriptEngineFactory;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.python.jsr223.PyScriptEngineFactory;

public class ScriptingServiceImpl
implements ScriptingService {
    private final ScriptEngineManager engineManager = new ScriptEngineManager();

    public ScriptingServiceImpl() {
        if (!this.supportsScriptLanguage(ScriptLanguage.Jython)) {
            ScriptingUtils.setJVMPropertiesForJython270Support();
            this.engineManager.registerEngineName(ScriptLanguage.Jython.getName(), (ScriptEngineFactory)new PyScriptEngineFactory());
        }
        if (!this.supportsScriptLanguage(ScriptLanguage.Python)) {
            this.engineManager.registerEngineName(ScriptLanguage.Python.getName(), new PythonScriptEngineFactory());
        }
        if (!this.supportsScriptLanguage(ScriptLanguage.PythonExp)) {
            this.engineManager.registerEngineName(ScriptLanguage.PythonExp.getName(), new PythonScriptEngineFactory());
        }
    }

    @Override
    public boolean supportsScriptLanguage(ScriptLanguage language) {
        String name = language.getName();
        boolean result = this.supportsScriptLanguageByName(name);
        return result;
    }

    @Override
    public ScriptEngine createScriptEngine(ScriptLanguage language) throws ScriptLanguage.NoEngineException {
        assert (this.supportsScriptLanguage(language));
        String name = language.getName();
        try {
            ScriptEngine result = this.engineManager.getEngineByName(name);
            return result;
        }
        catch (ScriptLanguage.NoEngineException e) {
            throw new ScriptLanguage.NoEngineException(language, (Throwable)e);
        }
    }

    protected boolean supportsScriptLanguageByName(String name) {
        ScriptEngine engine = this.engineManager.getEngineByName(name);
        boolean result = engine != null;
        return result;
    }

    protected boolean supportsScriptLanguageExtension(String extension) {
        ScriptEngine engine = this.engineManager.getEngineByExtension(extension);
        boolean result = engine != null;
        return result;
    }

    protected ScriptEngine createScriptEngineByExtension(String extension) {
        assert (ScriptLanguage.getByExtension((String)extension) != null);
        assert (this.supportsScriptLanguageExtension(extension));
        ScriptEngine result = this.engineManager.getEngineByExtension(extension);
        if (result == null) {
            ScriptLanguage language = ScriptLanguage.getByExtension((String)extension);
            throw new ScriptLanguage.NoEngineException(language);
        }
        return result;
    }

    protected ScriptEngine createScriptEngineByName(String name) {
        assert (ScriptLanguage.getByName((String)name) != null);
        assert (this.supportsScriptLanguageByName(name));
        ScriptEngine result = this.engineManager.getEngineByName(name);
        if (result == null) {
            ScriptLanguage language = ScriptLanguage.getByName((String)name);
            throw new ScriptLanguage.NoEngineException(language);
        }
        return result;
    }
}

