/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.easymock.Mock;
import org.easymock.MockType;
import org.easymock.TestSubject;
import org.easymock.internal.Injection;
import org.easymock.internal.InjectionPlan;
import org.easymock.internal.InjectionTarget;

public class Injector {
    public static void injectMocks(Object host) {
        InjectionPlan injectionPlan = new InjectionPlan();
        for (Class<?> hostClass = host.getClass(); hostClass != Object.class; hostClass = hostClass.getSuperclass()) {
            Injector.createMocksForAnnotations(hostClass, host, injectionPlan);
        }
        for (Field f : injectionPlan.getTestSubjectFields()) {
            Object testSubject;
            f.setAccessible(true);
            try {
                testSubject = f.get(host);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            if (testSubject == null) {
                testSubject = Injector.instantiateTestSubject(f);
                try {
                    f.setAccessible(true);
                    f.set(host, testSubject);
                }
                catch (ReflectiveOperationException e) {
                    throw new AssertionError("Failed to assign the created TestSubject to  " + f.getName(), e);
                }
            }
            for (Class<?> testSubjectClass = testSubject.getClass(); testSubjectClass != Object.class; testSubjectClass = testSubjectClass.getSuperclass()) {
                Injector.injectMocksOnClass(testSubjectClass, testSubject, injectionPlan);
            }
        }
        for (Injection injection : injectionPlan.getQualifiedInjections()) {
            if (!injection.isMatched()) {
                throw new AssertionError((Object)String.format("Unsatisfied qualifier: '%s'", injection.getAnnotation().fieldName()));
            }
        }
    }

    static <T> T instantiateTestSubject(Field f) {
        Object testSubject;
        Constructor<?> defaultConstructor;
        Class<?> type = f.getType();
        if (type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
            throw new AssertionError((Object)("TestSubject is an inner class. You need to instantiate '" + f.getName() + "' manually"));
        }
        try {
            defaultConstructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("TestSubject is null and has no default constructor. You need to instantiate '" + f.getName() + "' manually"));
        }
        defaultConstructor.setAccessible(true);
        try {
            testSubject = defaultConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError("TestSubject is null and default constructor fails on invocation. You need to instantiate '" + f.getName() + "' manually", e);
        }
        return (T)testSubject;
    }

    private static void createMocksForAnnotations(Class<?> hostClass, Object host, InjectionPlan injectionPlan) {
        Field[] fields;
        for (Field f : fields = hostClass.getDeclaredFields()) {
            TestSubject ima = f.getAnnotation(TestSubject.class);
            if (ima != null) {
                injectionPlan.addTestSubjectField(f);
                continue;
            }
            Mock annotation = f.getAnnotation(Mock.class);
            if (annotation == null) continue;
            Class<?> type = f.getType();
            String name = annotation.name();
            name = name.length() == 0 ? null : name;
            MockType mockType = Injector.mockTypeFromAnnotation(annotation);
            Object mock = host instanceof EasyMockSupport ? ((EasyMockSupport)host).createMock(name, mockType, type) : EasyMock.createMock(name, mockType, type);
            f.setAccessible(true);
            try {
                f.set(host, mock);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            injectionPlan.addInjection(new Injection(mock, annotation));
        }
    }

    private static MockType mockTypeFromAnnotation(Mock annotation) {
        MockType valueMockType = annotation.value();
        MockType mockType = annotation.type();
        if (valueMockType != MockType.DEFAULT && mockType != MockType.DEFAULT) {
            throw new AssertionError((Object)"@Mock.value() and @Mock.type() are aliases, you can't specify both at the same time");
        }
        if (valueMockType != MockType.DEFAULT) {
            mockType = valueMockType;
        }
        return mockType;
    }

    private static void injectMocksOnClass(Class<?> clazz, Object obj, InjectionPlan injectionPlan) {
        List<Field> fields = Injector.injectByName(clazz, obj, injectionPlan.getQualifiedInjections());
        Injector.injectByType(obj, fields, injectionPlan.getUnqualifiedInjections());
    }

    private static List<Field> injectByName(Class<?> clazz, Object obj, List<Injection> qualifiedInjections) {
        List<Field> fields = Injector.fieldsOf(clazz);
        for (Injection injection : qualifiedInjections) {
            Field f = Injector.getFieldByName(clazz, injection.getQualifier());
            InjectionTarget target = Injector.injectionTargetWithField(f);
            if (target == null || !target.accepts(injection)) continue;
            target.inject(obj, injection);
            fields.remove(target.getTargetField());
        }
        return fields;
    }

    private static void injectByType(Object obj, List<Field> fields, List<Injection> injections) {
        for (Field f : fields) {
            Injection toAssign;
            InjectionTarget target = Injector.injectionTargetWithField(f);
            if (target == null || (toAssign = Injector.findUniqueAssignable(injections, target)) == null) continue;
            target.inject(obj, toAssign);
        }
    }

    private static List<Field> fieldsOf(Class<?> clazz) {
        return new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
    }

    private static Field getFieldByName(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            return null;
        }
    }

    private static InjectionTarget injectionTargetWithField(Field f) {
        if (Injector.shouldNotAssignTo(f)) {
            return null;
        }
        return new InjectionTarget(f);
    }

    private static boolean shouldNotAssignTo(Field f) {
        return f == null || (f.getModifiers() & 0x18) != 0;
    }

    private static Injection findUniqueAssignable(List<Injection> injections, InjectionTarget target) {
        Injection toAssign = null;
        for (Injection injection : injections) {
            if (!target.accepts(injection)) continue;
            if (toAssign != null) {
                throw new AssertionError((Object)String.format("At least two mocks can be assigned to '%s': %s and %s", target.getTargetField(), toAssign.getMock(), injection.getMock()));
            }
            toAssign = injection;
        }
        return toAssign;
    }
}

