/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.internal;

import de.rcenvironment.core.component.integration.IntegrationContext;
import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.configuration.CommandLineArguments;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class ToolIntegrationContextRegistryImpl
implements ToolIntegrationContextRegistry {
    private static final long DISCOVERY_WAIT_TIME_MSEC = 1000L;
    private final BlockingDeque<Optional<IntegrationContext>> initializationQueue = new LinkedBlockingDeque<Optional<IntegrationContext>>();
    private final Map<String, IntegrationContext> contextsById = new HashMap<String, IntegrationContext>();
    private final Map<String, IntegrationContext> contextsByType = new HashMap<String, IntegrationContext>();
    private final AsyncTaskService asyncTaskService = ConcurrencyUtils.getAsyncTaskService();
    private boolean completionTimerStarted;
    private final Log log = LogFactory.getLog(this.getClass());

    @Activate
    protected void activate() {
        if (CommandLineArguments.isDoNotStartComponentsRequested()) {
            this.enqueueTerminationSignal();
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeToolIntegrationContext")
    protected synchronized void addToolIntegrationContext(IntegrationContext newContext) {
        String contextId = newContext.getContextId();
        String lowerCaseType = newContext.getContextTypeString().toLowerCase();
        if (this.contextsById.containsKey(contextId)) {
            return;
        }
        this.contextsById.put(contextId, newContext);
        this.contextsByType.put(lowerCaseType, newContext);
        this.log.debug((Object)("Registered integration context for id " + contextId + " and lowercase type " + lowerCaseType));
        this.initializationQueue.add(Optional.of(newContext));
        if (!this.completionTimerStarted) {
            this.asyncTaskService.scheduleAfterDelay(new Runnable(){

                @Override
                @TaskDescription(value="Signal end of ToolIntegrationContext discovery")
                public void run() {
                    ToolIntegrationContextRegistryImpl.this.log.debug((Object)"Sending initialization termination signal");
                    ToolIntegrationContextRegistryImpl.this.enqueueTerminationSignal();
                }
            }, 1000L);
            this.completionTimerStarted = true;
        }
    }

    protected synchronized void removeToolIntegrationContext(IntegrationContext oldContext) {
        String contextId = oldContext.getContextId();
        String lowerCaseType = oldContext.getContextTypeString().toLowerCase();
        this.contextsById.remove(contextId);
        this.contextsByType.remove(lowerCaseType);
    }

    @Override
    public IntegrationContext fetchNextUninitializedToolIntegrationContext() {
        try {
            Optional<IntegrationContext> element = this.initializationQueue.take();
            if (element.isPresent()) {
                return element.get();
            }
            return null;
        }
        catch (InterruptedException interruptedException) {
            this.log.debug((Object)("Interrupted while waiting for the next " + IntegrationContext.class.getSimpleName() + " to initialize"));
            return null;
        }
    }

    @Override
    public synchronized Collection<IntegrationContext> getAllIntegrationContexts() {
        return this.contextsById.values();
    }

    @Override
    public synchronized IntegrationContext getToolIntegrationContextById(String contextId) {
        IntegrationContext result = this.contextsById.get(contextId);
        if (result == null) {
            this.log.warn((Object)("Returning integration context 'null' for requested id '" + contextId + "'"));
        }
        return result;
    }

    @Override
    public synchronized IntegrationContext getToolIntegrationContextByType(String type) {
        IntegrationContext result = this.contextsByType.get(type.toLowerCase());
        if (result == null) {
            this.log.warn((Object)("Returning integration context 'null' for requested type '" + type + "'"));
        }
        return result;
    }

    @Override
    public synchronized boolean hasTIContextMatchingPrefix(String toolId) {
        for (IntegrationContext context : this.contextsById.values()) {
            if (!toolId.startsWith(context.getPrefixForComponentId())) continue;
            return true;
        }
        return false;
    }

    private void enqueueTerminationSignal() {
        this.initializationQueue.add(Optional.empty());
    }
}

