/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.DefaultInstanceValidator;
import de.rcenvironment.core.utils.common.StringUtils;

public class UsingActualConfigurationValuesValidator
extends DefaultInstanceValidator {
    private ConfigurationService configurationService;

    public InstanceValidationResult validate() {
        if (this.configurationService.isUsingDefaultConfigurationValues()) {
            String errorMessage1 = StringUtils.format((String)"Failed to load configuration file: %s \nMost likely, it has syntax errors. Check the log for details.", (Object[])new Object[]{this.configurationService.getProfileConfigurationFile().getAbsoluteFile()});
            String errorMessage2 = "Default configuration values will be applied.";
            return InstanceValidationResultFactory.createResultForFailureWhichAllowsToProceed((String)"Configuration values", (String)(String.valueOf(errorMessage1) + " " + errorMessage2), (String)(String.valueOf(errorMessage1) + "\n\n" + errorMessage2));
        }
        return InstanceValidationResultFactory.createResultForPassed((String)"Configuration values");
    }

    protected void bindConfigurationService(ConfigurationService newService) {
        this.configurationService = newService;
    }
}

