/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.execution;

import de.rcenvironment.components.excel.common.ChannelValue;
import de.rcenvironment.components.excel.common.ExcelAddress;
import de.rcenvironment.components.excel.common.ExcelComponentHistoryDataItem;
import de.rcenvironment.components.excel.common.ExcelUtils;
import de.rcenvironment.components.excel.execution.ExcelRCEComponent;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.model.api.LocalExecutionOnly;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.DataTypeException;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.BooleanTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.IntegerTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@LocalExecutionOnly
public class ExcelComponent
extends ExcelRCEComponent {
    private static final String EXCEPTION_MSG_CANNOT_DETERMINE_VALUE = "No value at Excel cell(s), cannot determine value(s)";
    private static final String EXCEPTION_MSG_WRONGTYPE_2 = " while value is of type ";
    private static final String EXCEPTION_MSG_WRONGTYPE_1 = "Output type is ";
    private static final int MAXIMUM_FILENAME_OLE_ACCEPTS = 20;
    private static final Log LOG = LogFactory.getLog(ExcelComponent.class);
    private long iteration = 0L;
    private ExcelComponentHistoryDataItem historyDataItem;
    private TempFileService tempFileUtils = TempFileServiceAccess.getInstance();

    @Override
    public void start() throws ComponentException {
        super.start();
        this.initializeNewHistoryDataItem();
    }

    @Override
    protected void executingOneStep() throws ComponentException {
        this.initializeNewHistoryDataItem();
        File excelWorkingFile = null;
        try {
            ++this.iteration;
            File originExcelFile = null;
            try {
                originExcelFile = ExcelUtils.getAbsoluteFile((String)this.componentContext.getConfigurationValue("xlFilename"));
                if (originExcelFile == null) {
                    throw new ComponentException("No Excel file given");
                }
                excelWorkingFile = this.tempFileUtils.createTempFileWithFixedFilename(originExcelFile.getName());
                FileUtils.copyFile((File)originExcelFile, (File)excelWorkingFile, (boolean)true);
                String fileName = excelWorkingFile.getName();
                if (fileName.length() > 20) {
                    String newFileName = fileName.substring(fileName.length() - 20, fileName.length());
                    File dest = new File(String.valueOf(excelWorkingFile.getParent()) + File.separator + newFileName);
                    boolean renamed = excelWorkingFile.renameTo(dest);
                    if (renamed) {
                        excelWorkingFile = dest;
                    } else {
                        this.componentLog.componentError("Failed to shorten file name. It's possible that VBA Codes did not execute. Component will continue to try.");
                    }
                }
            }
            catch (IOException e) {
                throw new ComponentException("Failed to copy origin Excel file to temporary directory (required for the Excel component to work)", (Throwable)e);
            }
            this.excelService.runMacro(excelWorkingFile, this.componentContext.getConfigurationValue("preMacro"));
            if (!this.componentContext.getInputs().isEmpty()) {
                this.processingInputChannels(excelWorkingFile);
            }
            this.excelService.runMacro(excelWorkingFile, this.componentContext.getConfigurationValue("runMacro"));
            this.processingOutputChannels(excelWorkingFile);
            this.excelService.runMacro(excelWorkingFile, this.componentContext.getConfigurationValue("postMacro"));
        }
        catch (Throwable throwable) {
            this.storeHistoryDataItem();
            if (excelWorkingFile != null) {
                try {
                    this.tempFileUtils.disposeManagedTempDirOrFile(excelWorkingFile);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed to delete temporary Excel file", (Throwable)e);
                }
            }
            throw throwable;
        }
        this.storeHistoryDataItem();
        if (excelWorkingFile != null) {
            try {
                this.tempFileUtils.disposeManagedTempDirOrFile(excelWorkingFile);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to delete temporary Excel file", (Throwable)e);
            }
        }
    }

    private void processingOutputChannels(File excelFile) throws ComponentException {
        for (String outputName : this.componentContext.getOutputs()) {
            boolean expand = Boolean.valueOf(this.componentContext.getOutputMetaDataValue(outputName, "expanding"));
            String address = this.componentContext.getOutputMetaDataValue(outputName, "address");
            ExcelAddress addr = new ExcelAddress(excelFile, address);
            SmallTableTD value = this.excelService.getValueOfCells(excelFile, addr);
            switch (this.componentContext.getOutputDataType(outputName)) {
                case ShortText: {
                    ShortTextTD text;
                    TypedDatum td = value.getTypedDatumOfCell(0, 0);
                    if (td != null && td instanceof ShortTextTD) {
                        text = (ShortTextTD)td;
                        this.componentContext.writeOutput(outputName, (TypedDatum)text);
                        break;
                    }
                    if (td != null) {
                        this.componentLog.componentInfo(StringUtils.format((String)"Trying to convert '%s' (value of cell in Excel) to %s (data type of output '%s')...", (Object[])new Object[]{td, DataType.ShortText.getDisplayName(), outputName}));
                        try {
                            text = (ShortTextTD)this.typedDatumConverter.castOrConvertUnsafe(td, ShortTextTD.class);
                            this.componentLog.componentInfo(StringUtils.format((String)"Sucessfully converted '%s' to ShortText", (Object[])new Object[]{td}));
                            this.componentContext.writeOutput(outputName, (TypedDatum)text);
                            break;
                        }
                        catch (DataTypeException e) {
                            throw new ComponentException(EXCEPTION_MSG_WRONGTYPE_1 + DataType.ShortText.getDisplayName() + EXCEPTION_MSG_WRONGTYPE_2 + td.getDataType().getDisplayName(), (Throwable)e);
                        }
                    }
                    throw new ComponentException(EXCEPTION_MSG_CANNOT_DETERMINE_VALUE);
                }
                case Float: {
                    FloatTD number;
                    TypedDatum td = value.getTypedDatumOfCell(0, 0);
                    if (td != null && td instanceof FloatTD) {
                        number = (FloatTD)td;
                        this.componentContext.writeOutput(outputName, (TypedDatum)number);
                        break;
                    }
                    if (td != null) {
                        this.componentLog.componentInfo(StringUtils.format((String)"Trying to convert '%s' (value of cell in Excel) to %s (data type of output '%s')...", (Object[])new Object[]{td, DataType.Float.getDisplayName(), outputName}));
                        try {
                            number = (FloatTD)this.typedDatumConverter.castOrConvert(td, FloatTD.class);
                            this.componentLog.componentInfo(StringUtils.format((String)"Sucessfully converted '%s' to Float", (Object[])new Object[]{td}));
                            this.componentContext.writeOutput(outputName, (TypedDatum)number);
                            break;
                        }
                        catch (DataTypeException e) {
                            throw new ComponentException(EXCEPTION_MSG_WRONGTYPE_1 + DataType.Float.getDisplayName() + EXCEPTION_MSG_WRONGTYPE_2 + td.getDataType().getDisplayName(), (Throwable)e);
                        }
                    }
                    throw new ComponentException(EXCEPTION_MSG_CANNOT_DETERMINE_VALUE);
                }
                case Integer: {
                    FloatTD number;
                    TypedDatum td = value.getTypedDatumOfCell(0, 0);
                    if (td != null && td instanceof IntegerTD) {
                        number = (IntegerTD)td;
                        this.componentContext.writeOutput(outputName, (TypedDatum)number);
                        break;
                    }
                    if (td != null) {
                        this.componentLog.componentInfo(StringUtils.format((String)"Trying to convert '%s' (value of cell in Excel) to %s (data type of output '%s')...", (Object[])new Object[]{td, DataType.Integer.getDisplayName(), outputName}));
                        try {
                            number = (IntegerTD)this.typedDatumConverter.castOrConvert(td, IntegerTD.class);
                            this.componentLog.componentInfo(StringUtils.format((String)"Sucessfully converted '%s' to Integer", (Object[])new Object[]{td}));
                            this.componentContext.writeOutput(outputName, (TypedDatum)number);
                            break;
                        }
                        catch (DataTypeException e) {
                            throw new ComponentException(EXCEPTION_MSG_WRONGTYPE_1 + DataType.Integer.getDisplayName() + EXCEPTION_MSG_WRONGTYPE_2 + td.getDataType().getDisplayName(), (Throwable)e);
                        }
                    }
                    throw new ComponentException(EXCEPTION_MSG_CANNOT_DETERMINE_VALUE);
                }
                case Boolean: {
                    BooleanTD b;
                    TypedDatum td = value.getTypedDatumOfCell(0, 0);
                    if (td != null && td instanceof BooleanTD) {
                        b = (BooleanTD)td;
                        this.componentContext.writeOutput(outputName, (TypedDatum)b);
                        break;
                    }
                    if (td != null) {
                        this.componentLog.componentInfo(StringUtils.format((String)"Trying to convert '%s' (value of cell in Excel) to %s (data type of output '%s')...", (Object[])new Object[]{td, DataType.Boolean.getDisplayName(), outputName}));
                        try {
                            b = (BooleanTD)this.typedDatumConverter.castOrConvert(td, BooleanTD.class);
                            this.componentLog.componentInfo(StringUtils.format((String)"Sucessfully converted '%s' to Integer", (Object[])new Object[]{td}));
                            this.componentContext.writeOutput(outputName, (TypedDatum)b);
                            break;
                        }
                        catch (DataTypeException e) {
                            throw new ComponentException(EXCEPTION_MSG_WRONGTYPE_1 + DataType.Boolean.getDisplayName() + EXCEPTION_MSG_WRONGTYPE_2 + td.getDataType().getDisplayName(), (Throwable)e);
                        }
                    }
                    throw new ComponentException(EXCEPTION_MSG_CANNOT_DETERMINE_VALUE);
                }
                case SmallTable: {
                    boolean pruning = Boolean.valueOf(this.componentContext.getOutputMetaDataValue(outputName, "pruning"));
                    if (pruning) {
                        int latestRowIndex = ExcelUtils.getRowIndexLastCellFilled((TypedDatum[][])value.toArray());
                        int latestColumnIndex = value.getColumnCount();
                        value = value.getSubTable(0, 0, latestRowIndex + 1, latestColumnIndex);
                    }
                    if (value != null) {
                        this.componentContext.writeOutput(outputName, (TypedDatum)value);
                        break;
                    }
                    throw new ComponentException(EXCEPTION_MSG_CANNOT_DETERMINE_VALUE);
                }
                default: {
                    throw new ComponentException("Output type not supported: " + this.componentContext.getOutputDataType(outputName).getDisplayName());
                }
            }
            File originExcelFile = ExcelUtils.getAbsoluteFile((String)this.componentContext.getConfigurationValue("xlFilename"));
            ChannelValue dataval = new ChannelValue(originExcelFile, addr, outputName, false, expand, this.iteration);
            dataval.setValues(value);
            dataval.setPreMacro(this.componentContext.getConfigurationValue("preMacro"));
            dataval.setRunMacro(this.componentContext.getConfigurationValue("runMacro"));
            dataval.setPostMacro(this.componentContext.getConfigurationValue("postMacro"));
            this.notificationService.send(String.valueOf(this.componentContext.getExecutionIdentifier()) + ":rce.component.excel", (Serializable)dataval);
        }
    }

    private void processingInputChannels(File excelFile) throws ComponentException {
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            TypedDatum input = this.componentContext.readInput(inputName);
            String address = this.componentContext.getInputMetaDataValue(inputName, "address");
            ExcelAddress addr = new ExcelAddress(excelFile, address);
            boolean expand = Boolean.valueOf(this.componentContext.getInputMetaDataValue(inputName, "expanding"));
            SmallTableTD value = null;
            switch (this.componentContext.getInputDataType(inputName)) {
                case ShortText: {
                    value = this.typedDatumFactory.createSmallTable(1, 1);
                    value.setTypedDatumForCell(input, 0, 0);
                    this.excelService.setValues(excelFile, addr, value);
                    break;
                }
                case Float: {
                    value = this.typedDatumFactory.createSmallTable(1, 1);
                    value.setTypedDatumForCell(input, 0, 0);
                    this.excelService.setValues(excelFile, addr, value);
                    break;
                }
                case Integer: {
                    value = this.typedDatumFactory.createSmallTable(1, 1);
                    value.setTypedDatumForCell(input, 0, 0);
                    this.excelService.setValues(excelFile, addr, value);
                    break;
                }
                case Boolean: {
                    value = this.typedDatumFactory.createSmallTable(1, 1);
                    value.setTypedDatumForCell(input, 0, 0);
                    this.excelService.setValues(excelFile, addr, value);
                    break;
                }
                case SmallTable: {
                    value = (SmallTableTD)input;
                    if (expand) {
                        addr = ExcelAddress.getExcelAddressForTableRange((File)excelFile, (ExcelAddress)addr, (int)value.getRowCount(), (int)value.getColumnCount());
                    }
                    this.excelService.setValues(excelFile, addr, value);
                    break;
                }
            }
            File originExcelFile = ExcelUtils.getAbsoluteFile((String)this.componentContext.getConfigurationValue("xlFilename"));
            ChannelValue dataval = new ChannelValue(originExcelFile, addr, inputName, true, expand, this.iteration);
            dataval.setValues(value);
            dataval.setPreMacro(this.componentContext.getConfigurationValue("preMacro"));
            dataval.setRunMacro(this.componentContext.getConfigurationValue("runMacro"));
            dataval.setPostMacro(this.componentContext.getConfigurationValue("postMacro"));
            this.notificationService.send(String.valueOf(this.componentContext.getExecutionIdentifier()) + ":rce.component.excel", (Serializable)dataval);
        }
    }

    private void initializeNewHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.historyDataItem = new ExcelComponentHistoryDataItem();
            this.historyDataItem.setExcelFilePath(ExcelUtils.getAbsoluteFile((String)this.componentContext.getConfigurationValue("xlFilename")).getAbsolutePath());
        }
    }

    private void storeHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyDataItem);
        }
    }
}

