/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration.handlers;

import de.rcenvironment.core.gui.integration.workflowintegration.WorkflowIntegrationController;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.WorkflowIntegrationEditorInput;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.FileNotFoundException;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditWorkflowIntegrationHandler
extends AbstractHandler {
    private static final Log LOG = LogFactory.getLog(EditWorkflowIntegrationHandler.class);
    private String integrationName;

    public EditWorkflowIntegrationHandler(String integrationName) {
        this.integrationName = integrationName;
    }

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        WorkflowIntegrationController workflowIntegrationController;
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("de.rcenvironment.rce.gui.workflowintegration.Editor");
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        try {
            workflowIntegrationController = new WorkflowIntegrationController(this.integrationName);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)StringUtils.format((String)"The Workflow Integration Editor cannot be displayed. The following file does not exist: \"%s\" ", (Object[])new Object[]{e.getMessage()}));
            return null;
        }
        workflowIntegrationController.setEditMode(true);
        try {
            WorkflowIntegrationEditorInput input = new WorkflowIntegrationEditorInput(workflowIntegrationController);
            Optional<String> validationMessage = input.validate();
            if (validationMessage.isPresent()) {
                LOG.warn((Object)StringUtils.format((String)"Error opening the workflow integration editor.\n%s", (Object[])new Object[]{validationMessage.get()}));
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error opening the integration editor", (String)("Could not open the workflow integration editor.\n" + validationMessage.get()));
            } else {
                activePage.openEditor((IEditorInput)input, desc.getId());
            }
        }
        catch (PartInitException e) {
            LOG.error((Object)"Error opening the workflow integration editor.", (Throwable)e);
        }
        return null;
    }
}

