/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.internal;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.internal.ConfigurationStore;
import de.rcenvironment.core.configuration.internal.WritableConfigurationSegmentImpl;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationStoreImpl
implements ConfigurationStore {
    private static final AtomicInteger sharedBackupDisambiguationNumberSequence = new AtomicInteger(1);
    private File storageFile;
    private boolean backupFileCreated = false;
    private final Log log = LogFactory.getLog(this.getClass());

    public ConfigurationStoreImpl(File storageFile) {
        this.storageFile = storageFile;
    }

    @Override
    public ConfigurationSegment getSnapshotOfRootSegment() throws IOException {
        try {
            if (!this.storageFile.exists()) {
                return new WritableConfigurationSegmentImpl(null);
            }
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            this.validateJsonSyntax(mapper);
            JsonNode node = mapper.readTree(this.storageFile);
            return new WritableConfigurationSegmentImpl(node);
        }
        catch (JsonParseException e) {
            throw new IOException("Malformed configuration file: " + e.toString());
        }
    }

    private void validateJsonSyntax(ObjectMapper mapper) throws JsonParseException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JsonParser parser = mapper.getJsonFactory().createJsonParser(this.storageFile);){
            while (parser.nextToken() != null) {
                parser.version();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ConfigurationSegment createEmptyPlaceholder() {
        return new WritableConfigurationSegmentImpl(null);
    }

    @Override
    public void update(ConfigurationSegment segment) throws ConfigurationException, IOException {
        WritableConfigurationSegmentImpl rootSegment = ((WritableConfigurationSegmentImpl)segment).getRootSegment();
        if (rootSegment != segment) {
            throw new IOException("The parameter passed to the save() method was not a root segment");
        }
        if (!this.backupFileCreated) {
            File backupFile = new File(this.storageFile.getParentFile(), String.valueOf(this.storageFile.getName()) + "." + System.currentTimeMillis() + "-" + sharedBackupDisambiguationNumberSequence.getAndIncrement() + ".bak");
            this.log.debug((Object)("Creating backup of existing configuration file at " + backupFile));
            Files.move(this.storageFile.toPath(), backupFile.toPath(), new CopyOption[0]);
            this.backupFileCreated = true;
        }
        this.writeJsonFile(rootSegment.getSegmentRootNode(), this.storageFile);
    }

    @Override
    public void exportToFile(ConfigurationSegment configurationSegment, File destinationFile) throws IOException {
        JsonNode segmentRootNode = ((WritableConfigurationSegmentImpl)configurationSegment).getSegmentRootNode();
        if (segmentRootNode != null) {
            this.writeJsonFile(segmentRootNode, destinationFile);
        } else {
            FileUtils.write((File)destinationFile, (CharSequence)"{}");
        }
    }

    private void writeJsonFile(JsonNode jsonRootNode, File file) throws IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonFactory jsonFactory = new JsonFactory();
        Throwable throwable = null;
        Object var6_7 = null;
        try (JsonGenerator jsonGenerator = jsonFactory.createGenerator(file, JsonEncoding.UTF8);){
            DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
            CustomIndenter customIndenter = new CustomIndenter();
            prettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)customIndenter);
            prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)customIndenter);
            jsonGenerator.setPrettyPrinter((PrettyPrinter)prettyPrinter);
            mapper.writeTree(jsonGenerator, jsonRootNode);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class CustomIndenter
    extends DefaultIndenter {
        private CustomIndenter() {
        }

        public void writeIndentation(JsonGenerator jg, int level) throws IOException, JsonGenerationException {
            super.writeIndentation(jg, level * 2);
        }
    }
}

