/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.ComponentNode;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.InputMappingNode;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.MappingType;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.OutputMappingNode;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.StringJoiner;
import org.eclipse.jface.viewers.TreeNode;

public abstract class MappingNode
extends TreeNode
implements Comparable<MappingNode> {
    private static final String FILTER_DELIMITER = ";";
    private static final String DEFAULT_MAPPED_NAME_TEMPLATE = "%s_%s";
    private MappingType mappingType;
    private boolean checked = false;
    private boolean checkable = true;
    private boolean nameValid = true;

    protected MappingNode(ComponentNode parent) {
        super((Object)parent);
        this.setParent(parent);
    }

    public void setCheckable(boolean checkable) {
        this.checkable = checkable;
        if (!checkable) {
            this.setChecked(true);
        }
    }

    public boolean isCheckable() {
        return this.checkable;
    }

    public static InputMappingNode createInputMappingNode(ComponentNode parent, String inputName, DataType dataType, String mappedName, EndpointDefinition.InputDatumHandling handling, EndpointDefinition.InputExecutionContraint constraint) {
        return new InputMappingNode(parent, inputName, dataType, mappedName, handling, constraint);
    }

    public static MappingNode createInputMappingNode(ComponentNode component, String inputName, DataType dataType, EndpointDefinition.InputDatumHandling handling, EndpointDefinition.InputExecutionContraint constraint) {
        return MappingNode.createInputMappingNode(component, inputName, dataType, MappingNode.getDefaultExternalName(inputName, component.getComponentName()), handling, constraint);
    }

    private static String getDefaultExternalName(String inputName, String componentName) {
        return StringUtils.format((String)DEFAULT_MAPPED_NAME_TEMPLATE, (Object[])new Object[]{inputName, componentName});
    }

    public static OutputMappingNode createOutputMappingNode(ComponentNode parent, String inputName, DataType dataType, String mappedName) {
        return new OutputMappingNode(parent, inputName, dataType, mappedName);
    }

    public static OutputMappingNode createOutputMappingNode(ComponentNode parent, String inputName, DataType dataType) {
        return MappingNode.createOutputMappingNode(parent, inputName, dataType, MappingNode.getDefaultExternalName(inputName, parent.getComponentName()));
    }

    public abstract String getDetails();

    public boolean hasChildren() {
        return false;
    }

    public MappingType getMappingType() {
        return this.mappingType;
    }

    public abstract String getInternalName();

    public void setMappingType(MappingType mappingType) {
        this.mappingType = mappingType;
    }

    public abstract DataType getDataType();

    public abstract String getExternalName();

    public abstract void setExternalName(String var1);

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getInternalName() == null ? 0 : this.getInternalName().hashCode());
        result = 31 * result + (this.getDataType() == null ? 0 : this.getDataType().hashCode());
        result = 31 * result + (this.getExternalName() == null ? 0 : this.getExternalName().hashCode());
        result = 31 * result + (this.getMappingType() == null ? 0 : this.getMappingType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappingNode other = (MappingNode)obj;
        if (!this.getParent().equals((Object)other.getParent())) {
            return false;
        }
        if (this.getInternalName() == null ? other.getInternalName() != null : !this.getInternalName().equals(other.getInternalName())) {
            return false;
        }
        if (this.getDataType() != other.getDataType()) {
            return false;
        }
        return this.getMappingType() == other.getMappingType();
    }

    @Override
    public int compareTo(MappingNode o) {
        return this.getInternalName().compareToIgnoreCase(o.getInternalName());
    }

    public void setNameValid(boolean isValid) {
        this.nameValid = isValid;
    }

    public boolean isNameValid() {
        return this.nameValid;
    }

    public String getFilterString() {
        StringJoiner builder = new StringJoiner(FILTER_DELIMITER);
        builder.add(this.getInternalName());
        builder.add(this.getMappingType().name());
        builder.add(this.getDataType().getDisplayName());
        builder.add(this.getDetails());
        builder.add(this.getExternalName());
        return builder.toString();
    }

    public void setDefaultExternalName() {
        if (this.getParent() instanceof ComponentNode) {
            this.setExternalName(this.getDefaultExternalName());
        }
    }

    public String getDefaultExternalName() {
        if (this.getParent() instanceof ComponentNode) {
            return MappingNode.getDefaultExternalName(this.getInternalName(), ((ComponentNode)this.getParent()).getComponentName());
        }
        return "";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(((ComponentNode)this.getParent()).getComponentName());
        builder.append(":");
        builder.append(this.getInternalName());
        builder.append("->");
        builder.append(this.getExternalName());
        builder.append(FILTER_DELIMITER);
        builder.append(this.getDataType());
        builder.append(FILTER_DELIMITER);
        builder.append((Object)this.getMappingType());
        builder.append("]");
        return builder.toString();
    }
}

